/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.io.socket;

import com.sun.jna.Platform;
import java.io.IOException;
import org.mariadb.jdbc.internal.io.socket.NamedPipeSocket;
import org.mariadb.jdbc.internal.io.socket.SharedMemorySocket;
import org.mariadb.jdbc.internal.io.socket.SocketHandlerFunction;
import org.mariadb.jdbc.internal.io.socket.UnixDomainSocket;
import org.mariadb.jdbc.internal.util.Utils;

public class SocketUtility {
    public static SocketHandlerFunction getSocketHandler() {
        try {
            Platform.getOSType();
            return (options, host) -> {
                if (options.pipe != null) {
                    return new NamedPipeSocket(host, options.pipe);
                }
                if (options.localSocket != null) {
                    try {
                        return new UnixDomainSocket(options.localSocket);
                    }
                    catch (RuntimeException re) {
                        throw new IOException(re.getMessage(), re.getCause());
                    }
                }
                if (options.sharedMemory != null) {
                    try {
                        return new SharedMemorySocket(options.sharedMemory);
                    }
                    catch (RuntimeException re) {
                        throw new IOException(re.getMessage(), re.getCause());
                    }
                }
                return Utils.standardSocket(options, host);
            };
        }
        catch (Throwable throwable) {
            return (options, host) -> Utils.standardSocket(options, host);
        }
    }
}

