/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectProject;
import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.enterprise.DomainCategory;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class SQLTypeTreeModel
implements TreeModel {
    private static final Logger logger = Logger.getLogger(SQLTypeTreeModel.class);
    private final Comparator<SPObject> typeComparator = new Comparator<SPObject>(){

        @Override
        public int compare(SPObject spo1, SPObject spo2) {
            if (spo1 instanceof UserDefinedSQLType && spo2 instanceof UserDefinedSQLType) {
                return Integer.signum(spo1.getName().compareToIgnoreCase(spo2.getName()));
            }
            if (spo1 instanceof DomainCategory && spo2 instanceof DomainCategory) {
                return Integer.signum(spo1.getName().compareToIgnoreCase(spo2.getName()));
            }
            if (spo1 instanceof DomainCategory) {
                return -1;
            }
            return 1;
        }
    };
    private final ArchitectProject root;
    private final List<UserDefinedSQLType> sqlTypes;
    private final Multimap<String, UserDefinedSQLType> domainCategoryMap = ArrayListMultimap.create();
    private final ArrayList<String> domainCategoryNameList;

    public SQLTypeTreeModel(ArchitectSession session) {
        this.root = session.getWorkspace();
        this.sqlTypes = new ArrayList<UserDefinedSQLType>(session.getSQLTypes());
        Collections.sort(this.sqlTypes, this.typeComparator);
        List<UserDefinedSQLType> domains = session.getDomains();
        for (UserDefinedSQLType domain : domains) {
            this.domainCategoryMap.put((Object)domain.getParent().getName(), (Object)domain);
        }
        this.domainCategoryNameList = new ArrayList(this.domainCategoryMap.keySet());
        Collections.sort(this.domainCategoryNameList);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (this.root == parent) {
            if (index < this.domainCategoryNameList.size()) {
                return new DomainCategory(this.domainCategoryNameList.get(index));
            }
            if (index < this.domainCategoryNameList.size() + this.sqlTypes.size()) {
                return this.sqlTypes.get(index - this.domainCategoryNameList.size());
            }
        } else if (parent instanceof DomainCategory && this.domainCategoryMap.keySet().contains(((DomainCategory)((Object)parent)).getName())) {
            return this.getDomainTypes((DomainCategory)((Object)parent)).get(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (this.root == parent) {
            return this.domainCategoryNameList.size() + this.sqlTypes.size();
        }
        if (parent instanceof DomainCategory && this.domainCategoryMap.keySet().contains(((DomainCategory)((Object)parent)).getName())) {
            return this.getDomainTypes((DomainCategory)((Object)parent)).size();
        }
        return 0;
    }

    private List<UserDefinedSQLType> getDomainTypes(DomainCategory category) {
        ArrayList children = new ArrayList(this.domainCategoryMap.get((Object)category.getName()));
        Collections.sort(children, this.typeComparator);
        return Collections.unmodifiableList(children);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        if (this.root == parent) {
            if (this.domainCategoryNameList.contains(child)) {
                return this.domainCategoryNameList.indexOf(child);
            }
            if (this.sqlTypes.contains(child)) {
                return this.domainCategoryNameList.size() + this.sqlTypes.indexOf(child);
            }
        } else if (parent instanceof DomainCategory && this.domainCategoryMap.keySet().contains((Object)((DomainCategory)((Object)parent))) && child instanceof UserDefinedSQLType) {
            return this.getDomainTypes((DomainCategory)((Object)parent)).indexOf(child);
        }
        return -1;
    }

    public ArchitectProject getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof UserDefinedSQLType;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

