/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.security.Principal;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;

public class PrincipalEndpointContextMatcher
implements EndpointContextMatcher {
    private final boolean usePrincipalAsIdentity;

    public PrincipalEndpointContextMatcher() {
        this(false);
    }

    public PrincipalEndpointContextMatcher(boolean usePrincipalAsIdentity) {
        this.usePrincipalAsIdentity = usePrincipalAsIdentity;
    }

    @Override
    public String getName() {
        return "principal correlation";
    }

    @Override
    public Object getEndpointIdentity(EndpointContext context) {
        if (this.usePrincipalAsIdentity) {
            Principal identity = context.getPeerIdentity();
            if (identity == null) {
                throw new IllegalArgumentException("Principal identity missing in provided endpoint context!");
            }
            return identity;
        }
        return context.getPeerAddress();
    }

    @Override
    public boolean isResponseRelatedToRequest(EndpointContext requestContext, EndpointContext responseContext) {
        return this.internalMatch(requestContext, responseContext);
    }

    @Override
    public boolean isToBeSent(EndpointContext messageContext, EndpointContext connectorContext) {
        if (null == connectorContext) {
            return true;
        }
        return this.internalMatch(messageContext, connectorContext);
    }

    private final boolean internalMatch(EndpointContext requestedContext, EndpointContext availableContext) {
        String cipher;
        if (requestedContext.getPeerIdentity() != null) {
            if (availableContext.getPeerIdentity() == null) {
                return false;
            }
            if (!this.matchPrincipals(requestedContext.getPeerIdentity(), availableContext.getPeerIdentity())) {
                return false;
            }
        }
        return (cipher = requestedContext.get("DTLS_CIPHER")) == null || cipher.equals(availableContext.get("DTLS_CIPHER"));
    }

    @Override
    public String toRelevantState(EndpointContext context) {
        if (context == null) {
            return "n.a.";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(context.getPeerIdentity());
        String cipher = context.get("DTLS_CIPHER");
        if (cipher != null) {
            builder.append(",").append(cipher);
        }
        builder.append("]");
        return builder.toString();
    }

    protected boolean matchPrincipals(Principal requestedPrincipal, Principal availablePrincipal) {
        return requestedPrincipal.equals(availablePrincipal);
    }
}

