/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jitsimeet;

import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;

public class ConferenceProperties
extends AbstractPacketExtension {
    public static final String NAMESPACE = "http://jitsi.org/protocol/focus";
    public static final String ELEMENT = "conference-properties";
    public static final String KEY_CREATED_MS = "created-ms";
    public static final String KEY_OCTO_ENABLED = "octo-enabled";
    public static final String KEY_BRIDGE_COUNT = "bridge-count";
    public static final String KEY_VISITORS_ENABLED = "visitors-enabled";
    public static final String KEY_VISITOR_COUNT = "visitor-count";
    public static final String KEY_VISITOR_CODECS = "visitor-codecs";
    public static final String KEY_SUPPORTS_SESSION_RESTART = "support-terminate-restart";

    public static ConferenceProperties clone(ConferenceProperties source) {
        ConferenceProperties destination = AbstractPacketExtension.clone(source);
        for (ConferenceProperty property : source.getProperties()) {
            destination.addProperty(ConferenceProperty.clone(property));
        }
        return destination;
    }

    public ConferenceProperties() {
        super(NAMESPACE, ELEMENT);
    }

    public List<ConferenceProperty> getProperties() {
        return this.getChildExtensionsOfType(ConferenceProperty.class);
    }

    public void addProperty(ConferenceProperty property) {
        this.clear(property.getKey());
        this.addChildExtension(property);
    }

    public void put(String key, String value2) {
        this.clear(key);
        this.addChildExtension(new ConferenceProperty(key, value2));
    }

    private void clear(String key) {
        Objects.requireNonNull(key);
        for (ConferenceProperty property : this.getChildExtensionsOfType(ConferenceProperty.class)) {
            if (!key.equals(property.getKey())) continue;
            this.removeChildExtension(property);
        }
    }

    public static class ConferenceProperty
    extends AbstractPacketExtension {
        public static final String ELEMENT = "property";
        public static final QName QNAME = new QName("http://jitsi.org/protocol/focus", "property");
        public static final String KEY_ATTR_NAME = "key";
        public static final String VALUE_ATTR_NAME = "value";

        public ConferenceProperty() {
            super(ConferenceProperties.NAMESPACE, ELEMENT);
        }

        public ConferenceProperty(String key, String value2) {
            super(ConferenceProperties.NAMESPACE, ELEMENT);
            this.setAttribute(KEY_ATTR_NAME, key);
            this.setAttribute(VALUE_ATTR_NAME, value2);
        }

        public String getKey() {
            return (String)this.getAttribute(KEY_ATTR_NAME);
        }

        public String getValue() {
            return (String)this.getAttribute(VALUE_ATTR_NAME);
        }
    }
}

