/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.sourceloader;

import java.io.File;
import java.util.Collection;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.extension.ExtensionService;
import org.jd.gui.spi.SourceLoader;

public class SourceLoaderService {
    protected static final SourceLoaderService SOURCE_LOADER_SERVICE = new SourceLoaderService();
    protected Collection<SourceLoader> providers = ExtensionService.getInstance().load(SourceLoader.class);

    public static SourceLoaderService getInstance() {
        return SOURCE_LOADER_SERVICE;
    }

    public String getSource(API api, Container.Entry entry) {
        for (SourceLoader provider : this.providers) {
            String source = provider.getSource(api, entry);
            if (source == null || source.isEmpty()) continue;
            return source;
        }
        return null;
    }

    public String loadSource(API api, Container.Entry entry) {
        for (SourceLoader provider : this.providers) {
            String source = provider.loadSource(api, entry);
            if (source == null || source.isEmpty()) continue;
            return source;
        }
        return null;
    }

    public File getSourceFile(API api, Container.Entry entry) {
        for (SourceLoader provider : this.providers) {
            File file = provider.loadSourceFile(api, entry);
            if (file == null) continue;
            return file;
        }
        return null;
    }
}

