/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.launcher.cli.WelcomeMessageConfiguration;
import org.gradle.api.launcher.cli.WelcomeMessageDisplayMode;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.IoActions;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.configuration.BuildLayoutResult;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.GFileUtils;

public class WelcomeMessageAction
implements Action<ExecutionListener> {
    public static final String WELCOME_MESSAGE_ENABLED_SYSTEM_PROPERTY = "org.gradle.internal.launcher.welcomeMessageEnabled";
    private final Logger logger;
    private final BuildLayoutResult buildLayout;
    private final GradleVersion gradleVersion;
    private final Function<String, InputStream> inputStreamProvider;
    private final WelcomeMessageConfiguration welcomeMessageConfiguration;
    private final Action<ExecutionListener> action;

    WelcomeMessageAction(BuildLayoutResult buildLayout, WelcomeMessageConfiguration welcomeMessageConfiguration, Action<ExecutionListener> action) {
        this(Logging.getLogger(WelcomeMessageAction.class), buildLayout, welcomeMessageConfiguration, GradleVersion.current(), new Function<String, InputStream>(){

            @Nullable
            public InputStream apply(@Nullable String input) {
                return this.getClass().getClassLoader().getResourceAsStream(input);
            }
        }, action);
    }

    @VisibleForTesting
    WelcomeMessageAction(Logger logger, BuildLayoutResult buildLayout, WelcomeMessageConfiguration welcomeMessageConfiguration, GradleVersion gradleVersion, Function<String, InputStream> inputStreamProvider, Action<ExecutionListener> action) {
        this.logger = logger;
        this.buildLayout = buildLayout;
        this.gradleVersion = gradleVersion;
        this.inputStreamProvider = inputStreamProvider;
        this.welcomeMessageConfiguration = welcomeMessageConfiguration;
        this.action = action;
    }

    public void execute(ExecutionListener executionListener) {
        File markerFile;
        if (this.isEnabledBySystemProperty() && this.isEnabledByGradleProperty() && !(markerFile = this.getMarkerFile()).exists() && this.logger.isLifecycleEnabled()) {
            this.logger.lifecycle("");
            this.logger.lifecycle("Welcome to Gradle " + this.gradleVersion.getVersion() + "!");
            String featureList = this.readReleaseFeatures();
            if (StringUtils.isNotBlank((String)featureList)) {
                this.logger.lifecycle("");
                this.logger.lifecycle("Here are the highlights of this release:");
                this.logger.lifecycle(StringUtils.stripEnd((String)featureList, (String)" \n\r"));
            }
            if (!this.gradleVersion.isSnapshot()) {
                this.logger.lifecycle("");
                this.logger.lifecycle("For more details see https://docs.gradle.org/" + this.gradleVersion.getVersion() + "/release-notes.html");
            }
            this.logger.lifecycle("");
            this.writeMarkerFile(markerFile);
        }
        this.action.execute((Object)executionListener);
    }

    private boolean isEnabledBySystemProperty() {
        String messageEnabled = System.getProperty(WELCOME_MESSAGE_ENABLED_SYSTEM_PROPERTY);
        if (messageEnabled == null) {
            return true;
        }
        return Boolean.parseBoolean(messageEnabled);
    }

    private boolean isEnabledByGradleProperty() {
        if (this.welcomeMessageConfiguration != null) {
            return this.welcomeMessageConfiguration.getWelcomeMessageDisplayMode() == WelcomeMessageDisplayMode.ONCE;
        }
        return true;
    }

    private File getMarkerFile() {
        File gradleUserHomeDir = this.buildLayout.getGradleUserHomeDir();
        File notificationsDir = new File(gradleUserHomeDir, "notifications");
        File versionedNotificationsDir = new File(notificationsDir, this.gradleVersion.getVersion());
        return new File(versionedNotificationsDir, "release-features.rendered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readReleaseFeatures() {
        InputStream inputStream = (InputStream)this.inputStreamProvider.apply((Object)"release-features.txt");
        if (inputStream != null) {
            StringWriter writer = new StringWriter();
            try {
                IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)"UTF-8");
                String string = writer.toString();
                return string;
            }
            catch (IOException iOException) {
            }
            finally {
                IoActions.closeQuietly((Closeable)inputStream);
            }
        }
        return null;
    }

    private void writeMarkerFile(File markerFile) {
        GFileUtils.mkdirs((File)markerFile.getParentFile());
        GFileUtils.touch((File)markerFile);
    }
}

