/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.blockdevicelib.vmdk;

import com.amazon.aes.webservices.client.blockdevicelib.DiskImage;
import com.amazon.aes.webservices.client.blockdevicelib.FileDiskImage;
import com.amazon.aes.webservices.client.blockdevicelib.ImageVerificationException;
import com.amazon.aes.webservices.client.blockdevicelib.vmdk.GrainIterator;
import com.amazon.aes.webservices.client.blockdevicelib.vmdk.SparseExtentHeader;
import com.amazon.aes.webservices.client.blockdevicelib.vmdk.VMDKDescriptor;
import java.nio.ByteBuffer;

public class StreamOptimizedVMDK
extends DiskImage {
    protected FileDiskImage image;
    protected SparseExtentHeader header = null;
    protected SparseExtentHeader footer = null;
    protected VMDKDescriptor descriptor = null;
    protected GrainIterator grainIterator = null;

    public StreamOptimizedVMDK(FileDiskImage diskImage) throws ImageVerificationException {
        this.image = diskImage;
        this.parseHeader();
        if (this.isGDOffsetAtFooter()) {
            this.parseFooter();
        }
        this.parseDescriptor();
        this.loadGrainDirectory();
    }

    @Override
    public long size() {
        return this.header.capacity * 512L;
    }

    @Override
    public byte[] read(long offset, int length) throws ImageVerificationException {
        byte[] bytes = new byte[length];
        if (this.grainIterator == null) {
            throw new ImageVerificationException("VMDK verifier not initialized.");
        }
        this.grainIterator.fillInBytes(bytes, offset);
        return bytes;
    }

    protected void parseHeader() throws ImageVerificationException {
        ByteBuffer buff = this.image.readLittleEndian(0L, 512);
        this.header = new SparseExtentHeader(buff);
        this.header.validateHeader();
    }

    protected void parseFooter() throws ImageVerificationException {
        long footerLoc = this.image.size() - 1024L;
        ByteBuffer buff = this.image.readLittleEndian(footerLoc, 512);
        this.footer = new SparseExtentHeader(buff);
        this.footer.validateHeader();
    }

    protected void parseDescriptor() throws ImageVerificationException {
        byte[] buff = this.image.read(this.header.descriptorOffset * 512L, (int)this.header.descriptorOffset * 512);
        this.descriptor = new VMDKDescriptor(buff);
        this.descriptor.validateDescriptor();
    }

    protected void loadGrainDirectory() throws ImageVerificationException {
        long gdOffset = (this.isGDOffsetAtFooter() ? this.footer.gdOffset : this.header.gdOffset) * 512L;
        int numberOfGDEntries = this.header.getNumberOfGDEntries();
        this.grainIterator = new GrainIterator(this.image, gdOffset, numberOfGDEntries);
    }

    private boolean isGDOffsetAtFooter() {
        return Long.toHexString(this.header.gdOffset).equals("ffffffffffffffff");
    }
}

