/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class BlueProtocolDecoder
extends BaseProtocolDecoder {
    public BlueProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private double readCoordinate(ByteBuf buf, boolean negative) {
        int value = buf.readUnsignedShort();
        int degrees = value / 100;
        double minutes = (double)(value % 100) + (double)buf.readUnsignedShort() * 1.0E-4;
        double coordinate = (double)degrees + minutes / 60.0;
        return negative ? -coordinate : coordinate;
    }

    private void sendResponse(Channel channel, int deviceIndex) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(170);
            response.writeShort(11);
            response.writeByte(134);
            response.writeByte(0);
            response.writeByte(6);
            response.writeByte(164);
            response.writeByte(0);
            response.writeByte(deviceIndex);
            response.writeByte(0);
            response.writeByte(0);
            response.writeByte(Checksum.xor(response.nioBuffer(1, response.writerIndex() - 1)));
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private String decodeAlarm(int value) {
        return switch (value) {
            case 1 -> "sos";
            case 8 -> "overspeed";
            case 19 -> "lowPower";
            default -> null;
        };
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        String id = String.valueOf(buf.readUnsignedInt());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        while (buf.readableBytes() > 1) {
            int frameEnd = buf.readerIndex() + buf.readUnsignedByte();
            short type = buf.readUnsignedByte();
            short index = buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            if (type == 1) {
                buf.readUnsignedByte();
                short flags = buf.readUnsignedByte();
                position.setValid(BitUtil.check(flags, 7));
                position.setLatitude(this.readCoordinate(buf, BitUtil.check(flags, 6)));
                position.setLongitude(this.readCoordinate(buf, BitUtil.check(flags, 5)));
                position.setSpeed((double)buf.readUnsignedShort() + (double)buf.readUnsignedShort() * 0.001);
                position.setCourse((double)buf.readUnsignedShort() + (double)buf.readUnsignedByte() * 0.01);
                DateBuilder dateBuilder = new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                position.setTime(dateBuilder.getDate());
                buf.readUnsignedShort();
                buf.readUnsignedShort();
            } else if (type == 18) {
                short status = buf.readUnsignedByte();
                position.addAlarm(BitUtil.check(status, 1) ? "vibration" : null);
                buf.readUnsignedByte();
                buf.readUnsignedByte();
                status = buf.readUnsignedByte();
                int ignition = BitUtil.between(status, 2, 4);
                if (ignition == 1) {
                    position.set("ignition", false);
                }
                if (ignition == 2) {
                    position.set("ignition", true);
                }
                buf.readUnsignedByte();
                buf.readUnsignedByte();
                position.set("status", buf.readUnsignedShort());
            } else if (type == 129) {
                position.addAlarm(this.decodeAlarm(buf.readUnsignedByte()));
            } else if (type == 132) {
                this.sendResponse(channel, index);
            }
            buf.readerIndex(frameEnd);
        }
        return position.getFixTime() != null ? position : null;
    }
}

