/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import org.keycloak.common.profile.ProfileException;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.command.AbstractStartCommand;
import org.keycloak.quarkus.runtime.cli.command.HelpAllMixin;
import org.keycloak.quarkus.runtime.cli.command.ImportRealmMixin;
import org.keycloak.quarkus.runtime.cli.command.OptimizedMixin;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import picocli.CommandLine;

@CommandLine.Command(name="start", header={"Start the server."}, description={"%nUse this command to run the server in production."}, footer={"%nBy default, this command tries to update the server configuration by running a 'build' before starting the server. You can disable this behavior by using the '--optimized' option:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} '--optimized'%n%nBy doing that, the server should start faster based on any previous configuration you have set when manually running the 'build' command."})
public final class Start
extends AbstractStartCommand
implements Runnable {
    public static final String NAME = "start";
    @CommandLine.Mixin
    OptimizedMixin optimizedMixin = new OptimizedMixin();
    @CommandLine.Mixin
    ImportRealmMixin importRealmMixin;
    @CommandLine.Mixin
    HelpAllMixin helpAllMixin;

    @Override
    protected void doBeforeRun() {
        Environment.updateProfile(true);
        if (Environment.isDevProfile()) {
            throw new PropertyException(Messages.devProfileNotAllowedError(NAME));
        }
    }

    @Override
    public boolean includeRuntime() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static void fastStart(Picocli picocli, boolean dryRun) {
        try {
            Start start = new Start();
            Environment.setParsedCommand(start);
            PropertyMappers.sanitizeDisabledMappers();
            start.optimizedMixin.optimized = true;
            start.dryRunMixin.dryRun = dryRun;
            start.setPicocli(picocli);
            start.run();
        }
        catch (ProfileException | PropertyException e) {
            picocli.usageException(e.getMessage(), e.getCause());
        }
    }
}

