/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;

public class UnionIterator
implements SequenceIterator,
LookaheadIterator {
    private final TreeSet<Intake> intakes;

    public UnionIterator(List<SequenceIterator> inputs, Comparator<? super NodeInfo> comparer) throws XPathException {
        IntakeComparer comp = new IntakeComparer(comparer);
        this.intakes = new TreeSet<Intake>(comp);
        for (SequenceIterator seq : inputs) {
            boolean added;
            NodeInfo next = (NodeInfo)seq.next();
            while (next != null && !(added = this.intakes.add(new Intake(seq, next)))) {
                next = (NodeInfo)seq.next();
            }
        }
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return !this.intakes.isEmpty();
    }

    @Override
    public NodeInfo next() {
        Intake nextIntake = this.intakes.pollFirst();
        if (nextIntake != null) {
            SequenceIterator iter = nextIntake.iter;
            NodeInfo nextNode = (NodeInfo)iter.next();
            while (nextNode != null) {
                boolean added = false;
                if (!nextNode.isSameNodeInfo(nextIntake.nextNode)) {
                    Intake replacement = new Intake(iter, nextNode);
                    added = this.intakes.add(replacement);
                }
                if (added) break;
                nextNode = (NodeInfo)iter.next();
            }
            return nextIntake.nextNode;
        }
        return null;
    }

    @Override
    public void close() {
        for (Intake intake : this.intakes) {
            intake.iter.close();
        }
    }

    @Override
    public void discharge() {
        for (Intake intake : this.intakes) {
            intake.iter.discharge();
        }
    }

    private static class IntakeComparer
    implements Comparator<Intake> {
        private final Comparator<? super NodeInfo> itemOrderComparer;

        public IntakeComparer(Comparator<? super NodeInfo> itemOrderComparer) {
            this.itemOrderComparer = itemOrderComparer;
        }

        @Override
        public int compare(Intake o1, Intake o2) {
            return this.itemOrderComparer.compare(o1.nextNode, o2.nextNode);
        }
    }

    private static class Intake {
        public SequenceIterator iter;
        public NodeInfo nextNode;

        public Intake(SequenceIterator iter, NodeInfo nextNode) {
            this.iter = iter;
            this.nextNode = nextNode;
        }
    }
}

