/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateSubnetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateSubnetRequestMarshaller
implements Marshaller<Request<CreateSubnetRequest>, CreateSubnetRequest> {
    public Request<CreateSubnetRequest> marshall(CreateSubnetRequest createSubnetRequest) {
        if (createSubnetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSubnetRequest, "AmazonEC2");
        request.addParameter("Action", "CreateSubnet");
        request.addParameter("Version", "2015-04-15");
        if (createSubnetRequest.isDryRun() != null) {
            request.addParameter("DryRun", StringUtils.fromBoolean((Boolean)createSubnetRequest.isDryRun()));
        }
        if (createSubnetRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)createSubnetRequest.getVpcId()));
        }
        if (createSubnetRequest.getCidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString((String)createSubnetRequest.getCidrBlock()));
        }
        if (createSubnetRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createSubnetRequest.getAvailabilityZone()));
        }
        return request;
    }
}

