#!/bin/sh

#  Modification History

#  Changed on 11/05/98 by DanEspen (dje):
#  - Changed from ksh to sh for extra portability.

#  Created on 10/31/98 by DanEspen (dje):
#  - Takes certain text files from the Fvwm distribution and
#  converts them to html.

# Arg 1 is the input file name.
# This has to be run from the directory where the output file is wanted.
# This is designed for the files, ChangeLog, TO-DO, FAQ

name=`basename $1`
outfile=$name.html

# make header:
echo "<html>
<head>
<title>The Official FVWM Homepage - $name Information</title>
</head>
  <body BACKGROUND=\"black-stone1.jpg\"
    bgcolor=\"#000000\" text=\"#ffffff\"
    link=\"#FFFF88\" vlink=\"#EEDDDD\" alink=\"#ff0000\">
<center>
<h1><font color=\"pink\">The Official FVWM Homepage - $name Information</font></h1>
</center>
<pre>
" > $outfile

# Embed the text with some adjustment:
sed -e 's/&/\&amp;/' \
    -e 's/</\&lt;/' \
    -e 's/>/\&gt;/' $1 >> $outfile

# make footer:
echo "</pre>
    <hr>
<!-- This file automatically generated by txt2html.sh
     on `date` -->
  </body>
</html>
" >> $outfile
