/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3.fontface;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssValue;

public class CssFontFamily
extends org.w3c.css.properties.css.fontface.CssFontFamily {
    public CssFontFamily() {
        this.value = initial;
    }

    public CssFontFamily(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        switch (val.getType()) {
            case 1: {
                this.value = val;
                if (!check || expression.getCount() <= 1) break;
                throw new InvalidParamException("unrecognize", ac);
            }
            case 0: {
                ArrayList<CssIdent> idval = new ArrayList<CssIdent>();
                idval.add(val.getIdent());
                while (op == ' ' && expression.getRemainingCount() > 1) {
                    expression.next();
                    op = expression.getOperator();
                    val = expression.getValue();
                    if (val.getType() == 0) {
                        idval.add(val.getIdent());
                        continue;
                    }
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                if (op != ' ') {
                    throw new InvalidParamException("operator", Character.toString(op), ac);
                }
                this.value = this.checkExpression(ac, idval);
                break;
            }
            default: {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    public CssFontFamily(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    private CssValue checkExpression(ApplContext ac, ArrayList<CssIdent> values) throws InvalidParamException {
        if (values.size() > 1) {
            StringBuilder sb = new StringBuilder("\"");
            boolean addSpace = false;
            for (CssIdent id : values) {
                if (addSpace) {
                    sb.append(' ');
                } else {
                    addSpace = true;
                }
                sb.append(id);
            }
            sb.append('\"');
            ac.getFrame().addWarning("with-space", 1);
            return new CssString(sb.toString());
        }
        CssIdent val = values.get(0);
        if (null != org.w3c.css.properties.css3.CssFontFamily.getGenericFontName(val)) {
            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
        }
        return val;
    }
}

