/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class NumericPromoter
extends UnaryExpression {
    private BuiltInAtomicType requiredType;

    public NumericPromoter(Expression sequence, BuiltInAtomicType requiredType) {
        super(sequence);
        this.requiredType = requiredType;
        ExpressionTool.copyLocationInfo(sequence, this);
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        if (this.operand instanceof Literal) {
            if (((Literal)this.operand).getValue() instanceof AtomicValue) {
                return Literal.makeLiteral(this.promote((AtomicValue)((Literal)this.operand).getValue(), null));
            }
            return Literal.makeLiteral(((Value)SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()))).reduce());
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        return this;
    }

    public SequenceIterator iterate(final XPathContext context) throws XPathException {
        SequenceIterator base = this.operand.iterate(context);
        ItemMappingFunction promoter = new ItemMappingFunction(){

            public Item map(Item item) throws XPathException {
                return NumericPromoter.this.promote((AtomicValue)item, context);
            }
        };
        return new ItemMappingIterator(base, promoter);
    }

    public Expression copy() {
        return new NumericPromoter(this.getBaseExpression().copy(), this.requiredType);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item = this.operand.evaluateItem(context);
        if (item == null) {
            return null;
        }
        return this.promote((AtomicValue)item, context);
    }

    private AtomicValue promote(AtomicValue value, XPathContext context) throws XPathException {
        if (!(value instanceof NumericValue) && !(value instanceof UntypedAtomicValue)) {
            TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
            XPathException err = new XPathException("Cannot promote non-numeric value to " + this.getItemType(th).toString(), "XPTY0004", context);
            err.setLocator(this);
            throw err;
        }
        return value.convert(this.requiredType, true, context).asAtomic();
    }

    public int getRequiredType() {
        return this.requiredType.getFingerprint();
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.requiredType.equals(BuiltInAtomicType.DOUBLE)) {
            return BuiltInAtomicType.DOUBLE;
        }
        return BuiltInAtomicType.FLOAT;
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.requiredType == ((NumericPromoter)other).requiredType;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("promoteNumeric");
        out.emitAttribute("to", this.getItemType(out.getTypeHierarchy()).toString(out.getConfiguration().getNamePool()));
        this.operand.explain(out);
        out.endElement();
    }
}

