/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.fileio;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.views.fileio.FileIOViewSupport;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.openide.util.ImageUtilities;

abstract class FileIONode
extends CCTNode {
    private static final FileIONode[] NO_NODES = new FileIONode[0];
    private final FileIONode parent;
    private final List<FileIONode> children;
    final String name;
    final Icon icon;
    long countR;
    long countW = 0L;
    long bytesR;
    long bytesW = 0L;
    Duration durationR;
    Duration durationRMax;
    Duration durationW;
    Duration durationWMax;

    FileIONode(String name, Icon icon, FileIONode parent, List<FileIONode> children) {
        this.parent = parent;
        this.children = children;
        this.name = name;
        this.icon = icon;
    }

    final void processRead(Duration duration, long bytes) {
        if (this.parent != null) {
            ++this.countR;
            this.bytesR += bytes;
            this.durationR = this.durationR == null ? duration : this.durationR.plus(duration);
            if (this.durationRMax == null || this.durationRMax.compareTo(duration) < 0) {
                this.durationRMax = duration;
            }
            this.parent.processRead(duration, bytes);
        }
    }

    final void processWrite(Duration duration, long bytes) {
        if (this.parent != null) {
            ++this.countW;
            this.bytesW += bytes;
            this.durationW = this.durationW == null ? duration : this.durationW.plus(duration);
            if (this.durationWMax == null || this.durationWMax.compareTo(duration) < 0) {
                this.durationWMax = duration;
            }
            this.parent.processWrite(duration, bytes);
        }
    }

    FileIONode getChild(String name) {
        if (this.children != null) {
            for (FileIONode child : this.children) {
                if (!Objects.equals(name, child.name)) continue;
                return child;
            }
        }
        return null;
    }

    public FileIONode getChild(int index) {
        return this.children == null ? null : this.children.get(index);
    }

    public FileIONode[] getChildren() {
        return this.children == null ? NO_NODES : this.children.toArray(NO_NODES);
    }

    public int getIndexOfChild(Object child) {
        return this.children == null ? -1 : this.children.indexOf(child);
    }

    public int getNChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    public boolean isLeaf() {
        return this.children == null ? true : this.children.isEmpty();
    }

    public FileIONode getParent() {
        return this.parent;
    }

    protected void addChild(FileIONode child) {
        if (this.children != null) {
            this.children.add(child);
        }
    }

    protected void removeAllChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileIONode)) {
            return false;
        }
        return Objects.equals(this.name, ((FileIONode)((Object)o)).name);
    }

    public String toString() {
        return this.name;
    }

    static final class Root
    extends FileIONode
    implements JFREventVisitor {
        private final FileIOViewSupport.Aggregation primary;
        private final FileIOViewSupport.Aggregation secondary;

        Root() {
            this(null, null);
        }

        Root(FileIOViewSupport.Aggregation primary, FileIOViewSupport.Aggregation secondary) {
            super(null, null, null, (List<FileIONode>)(primary == null && secondary == null ? null : new ArrayList<FileIONode>()));
            this.primary = primary;
            this.secondary = FileIOViewSupport.Aggregation.NONE.equals((Object)secondary) ? null : secondary;
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            Boolean rw = "jdk.FileRead".equals(typeName) ? Boolean.FALSE : ("jdk.FileWrite".equals(typeName) ? Boolean.TRUE : null);
            if (rw != null) {
                FileIONode primaryNode;
                String primaryName = Root.getName(this.primary, event);
                if (primaryName == null) {
                    primaryName = "<unknown>";
                }
                if ((primaryNode = this.getChild(primaryName)) == null) {
                    primaryNode = this.createNode(primaryName, this.primary, this, this.secondary == null);
                    this.addChild(primaryNode);
                }
                if (this.secondary != null) {
                    FileIONode secondaryNode;
                    String secondaryName = Root.getName(this.secondary, event);
                    if (secondaryName == null) {
                        secondaryName = "<unknown>";
                    }
                    if ((secondaryNode = primaryNode.getChild(secondaryName)) == null) {
                        secondaryNode = this.createNode(secondaryName, this.secondary, primaryNode, true);
                        primaryNode.addChild(secondaryNode);
                    }
                    Root.processEvent(secondaryNode, event, rw);
                } else {
                    Root.processEvent(primaryNode, event, rw);
                }
            }
            return false;
        }

        private static void processEvent(FileIONode node, JFREvent event, Boolean rw) {
            try {
                if (Boolean.FALSE.equals(rw)) {
                    node.processRead(event.getDuration("eventDuration"), event.getLong("bytesRead"));
                } else {
                    node.processWrite(event.getDuration("eventDuration"), event.getLong("bytesWritten"));
                }
            }
            catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                // empty catch block
            }
        }

        @Override
        public int hashCode() {
            return 37;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Root;
        }

        private static String getName(FileIOViewSupport.Aggregation aggregation, JFREvent event) {
            try {
                if (FileIOViewSupport.Aggregation.FILE.equals((Object)aggregation)) {
                    return event.getString("path");
                }
                if (FileIOViewSupport.Aggregation.THREAD.equals((Object)aggregation)) {
                    return event.getThread("eventThread").getName();
                }
            }
            catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                // empty catch block
            }
            return null;
        }

        private FileIONode createNode(String name, FileIOViewSupport.Aggregation aggregation, FileIONode parent, boolean terminal) {
            if (FileIOViewSupport.Aggregation.FILE.equals((Object)aggregation)) {
                return new File(name, parent, terminal);
            }
            if (FileIOViewSupport.Aggregation.THREAD.equals((Object)aggregation)) {
                return new Thread(name, parent, terminal);
            }
            return null;
        }
    }

    static final class Thread
    extends FileIONode {
        Thread(String name, FileIONode parent, boolean terminal) {
            super(name, Icons.getIcon((String)"ProfilerIcons.Thread"), parent, terminal ? null : new ArrayList());
        }
    }

    static final class File
    extends FileIONode {
        private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/file.png";
        private static final Icon ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/jfr/resources/file.png", (boolean)true));

        File(String name, FileIONode parent, boolean terminal) {
            super(name, ICON, parent, terminal ? null : new ArrayList());
        }
    }
}

