/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sendopts;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.modules.sendopts.OptionImpl;
import org.netbeans.spi.sendopts.Arg;
import org.netbeans.spi.sendopts.ArgsProcessor;
import org.netbeans.spi.sendopts.Description;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.util.Lookup;

public final class DefaultProcessor
extends OptionProcessor {
    private static final Option defArgs = Option.defaultArguments();
    private final String clazz;
    private final Object instance;
    private final Set<Option> options;

    private DefaultProcessor(String string, Object object, Set<Option> set) {
        this.clazz = string;
        this.instance = object;
        this.options = Collections.unmodifiableSet(set);
    }

    private static Option createOption(String string, Character c, String string2, String string3, String string4) {
        String[] stringArray;
        Option option = null;
        if (c == null) {
            c = Character.valueOf('\uffff');
        }
        switch (Type.valueOf(string)) {
            case withoutArgument: {
                option = Option.withoutArgument(c.charValue(), string2);
                break;
            }
            case requiredArgument: {
                option = Option.requiredArgument(c.charValue(), string2);
                break;
            }
            case optionalArgument: {
                option = Option.optionalArgument(c.charValue(), string2);
                break;
            }
            case additionalArguments: {
                option = Option.additionalArguments(c.charValue(), string2);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (string3 != null) {
            stringArray = DefaultProcessor.fixBundles(string3.split("#", 2));
            option = Option.displayName(option, stringArray[0], stringArray[1]);
        }
        if (string4 != null) {
            stringArray = DefaultProcessor.fixBundles(string4.split("#", 2));
            option = Option.shortDescription(option, stringArray[0], stringArray[1]);
        }
        return option;
    }

    public static OptionProcessor create(Class<?> clazz, Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("class", clazz.getName());
        if (object != null) {
            hashMap.put("instance", object);
        }
        int n = 1;
        for (Field field : clazz.getFields()) {
            Arg arg = field.getAnnotation(Arg.class);
            if (arg == null) continue;
            Description description = field.getAnnotation(Description.class);
            if (arg.shortName() != '\uffff') {
                hashMap.put(n + ".shortName", Character.valueOf(arg.shortName()));
            }
            if (!arg.longName().isEmpty()) {
                hashMap.put(n + ".longName", arg.longName());
            }
            if (field.getType() == Boolean.TYPE) {
                hashMap.put(n + ".type", "withoutArgument");
            } else if (String.class == field.getType()) {
                if (arg.defaultValue().equals("\u0000")) {
                    hashMap.put(n + ".type", "requiredArgument");
                } else {
                    hashMap.put(n + ".type", "optionalArgument");
                }
            } else {
                if (!String[].class.equals(field.getType())) {
                    throw new IllegalStateException("Field type has to be either boolean, String or String[]! " + field);
                }
                hashMap.put(n + ".type", "additionalArguments");
            }
            if (arg.implicit()) {
                hashMap.put(n + ".implicit", true);
            }
            if (description != null) {
                DefaultProcessor.writeBundle(hashMap, n + ".displayName", description.displayName(), field);
                DefaultProcessor.writeBundle(hashMap, n + ".shortDescription", description.shortDescription(), field);
            }
            ++n;
        }
        return DefaultProcessor.create(hashMap);
    }

    static OptionProcessor create(Map<?, ?> map) {
        String string = (String)map.get("class");
        LinkedHashSet<Option> linkedHashSet = new LinkedHashSet<Option>();
        int n = 1;
        while (true) {
            Character c = (Character)map.get(n + ".shortName");
            String string2 = (String)map.get(n + ".longName");
            if (c == null && string2 == null) break;
            String string3 = (String)map.get(n + ".type");
            String string4 = (String)map.get(n + ".displayName");
            String string5 = (String)map.get(n + ".shortDescription");
            linkedHashSet.add(DefaultProcessor.createOption(string3, c, string2, string4, string5));
            if (Boolean.TRUE.equals(map.get(n + ".implicit"))) {
                linkedHashSet.add(defArgs);
            }
            ++n;
        }
        Object obj = map.get("instance");
        return new DefaultProcessor(string, obj, linkedHashSet);
    }

    @Override
    protected Set<Option> getOptions() {
        return this.options;
    }

    @Override
    protected void process(Env env, Map<Option, String[]> map) throws CommandException {
        try {
            Object object;
            Class<?> clazz;
            ClassLoader classLoader = DefaultProcessor.findClassLoader();
            if (this.instance == null) {
                clazz = Class.forName(this.clazz, true, classLoader);
                object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                clazz = this.instance.getClass();
                object = this.instance;
            }
            Map<Option, Field> map2 = DefaultProcessor.processFields(clazz, this.options);
            for (Map.Entry<Option, String[]> entry : map.entrySet()) {
                Option option = entry.getKey();
                Type type = Type.valueOf(option);
                Field field = map2.get(option);
                assert (field != null) : "No field for option: " + option;
                switch (type) {
                    case withoutArgument: {
                        field.setBoolean(object, true);
                        break;
                    }
                    case requiredArgument: {
                        field.set(object, entry.getValue()[0]);
                        break;
                    }
                    case optionalArgument: {
                        if (entry.getValue().length == 1) {
                            field.set(object, entry.getValue()[0]);
                            break;
                        }
                        field.set(object, field.getAnnotation(Arg.class).defaultValue());
                        break;
                    }
                    case additionalArguments: {
                        field.set(object, entry.getValue());
                        break;
                    }
                    case defaultArguments: {
                        field.set(object, entry.getValue());
                    }
                }
            }
            if (object instanceof Runnable) {
                ((Runnable)object).run();
            }
            if (object instanceof ArgsProcessor) {
                ((ArgsProcessor)object).process(env);
            }
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (Exception exception) {
            throw (CommandException)new CommandException(10, exception.getLocalizedMessage()).initCause(exception);
        }
    }

    public static ClassLoader findClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = DefaultProcessor.findClassLoaderFromLookup();
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = DefaultProcessor.class.getClassLoader();
        }
        return classLoader;
    }

    private static ClassLoader findClassLoaderFromLookup() {
        return (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
    }

    private static Map<Option, Field> processFields(Class<?> clazz, Set<Option> set) {
        HashMap<Option, Field> hashMap = new HashMap<Option, Field>();
        for (Field field : clazz.getFields()) {
            Arg arg = field.getAnnotation(Arg.class);
            if (arg == null) continue;
            Option option = null;
            for (Option option2 : set) {
                char c = (char)OptionImpl.Trampoline.DEFAULT.getShortName(option2);
                String string = OptionImpl.Trampoline.DEFAULT.getLongName(option2);
                if (c != arg.shortName() || !DefaultProcessor.equalStrings(string, arg)) continue;
                option = option2;
                break;
            }
            assert (option != null) : "No option for field " + field + " options: " + set;
            hashMap.put(option, field);
            if (!arg.implicit()) continue;
            hashMap.put(defArgs, field);
        }
        assert (hashMap.size() == set.size()) : "Map " + hashMap + " Options " + set;
        return hashMap;
    }

    private static boolean equalStrings(String string, Arg arg) {
        if (string == null) {
            return arg.longName().isEmpty();
        }
        return string.equals(arg.longName());
    }

    private static void writeBundle(Map<String, Object> map, String string, String string2, Field field) throws IllegalStateException {
        if (string2.isEmpty()) {
            return;
        }
        if (string2.startsWith("#")) {
            Package package_ = field.getDeclaringClass().getPackage();
            string2 = package_.getName() + ".Bundle" + string2;
        }
        map.put(string, string2);
    }

    private static String[] fixBundles(String[] stringArray) {
        if (stringArray.length == 2) {
            return stringArray;
        }
        return new String[]{OptionImpl.NO_BUNDLE, stringArray[0]};
    }

    private static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type withoutArgument = new Type();
        public static final /* enum */ Type requiredArgument = new Type();
        public static final /* enum */ Type optionalArgument = new Type();
        public static final /* enum */ Type additionalArguments = new Type();
        public static final /* enum */ Type defaultArguments = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        public static Type valueOf(Option option) {
            OptionImpl optionImpl = OptionImpl.Trampoline.DEFAULT.impl(option);
            switch (optionImpl.argumentType) {
                case 0: {
                    return withoutArgument;
                }
                case 1: {
                    return requiredArgument;
                }
                case 2: {
                    return optionalArgument;
                }
                case 3: {
                    return additionalArguments;
                }
                case 4: {
                    return defaultArguments;
                }
            }
            assert (false);
            return null;
        }

        static {
            $VALUES = new Type[]{withoutArgument, requiredArgument, optionalArgument, additionalArguments, defaultArguments};
        }
    }
}

