/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.nodes;

import java.util.Map;
import javax.swing.Icon;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleLocalObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectFieldNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectReferenceNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleStackFrameNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;

public class TruffleNodesRendererProvider
extends HeapViewerRenderer.Provider {
    public boolean supportsView(HeapContext context, String viewID) {
        return true;
    }

    public void registerRenderers(Map<Class<? extends HeapViewerNode>, HeapViewerRenderer> renderers, HeapContext context) {
        Heap heap = context.getFragment().getHeap();
        Icon instanceIcon = Icons.getIcon((String)"LanguageIcons.Instance");
        renderers.put(TruffleObjectNode.InstanceBased.class, new TruffleObjectNode.Renderer(heap, instanceIcon));
        renderers.put(TruffleObjectFieldNode.InstanceBased.class, new TruffleObjectFieldNode.Renderer(heap, instanceIcon));
        renderers.put(TruffleObjectReferenceNode.InstanceBased.class, new TruffleObjectReferenceNode.Renderer(heap, instanceIcon));
        renderers.put(TruffleLocalObjectNode.InstanceBased.class, new TruffleLocalObjectNode.Renderer(heap, instanceIcon));
        renderers.put(TruffleStackFrameNode.class, new TruffleStackFrameNode.Renderer());
    }
}

