/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.modules.autoupdate.ui.SortColumnHeaderRenderer;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UnitTab;
import org.openide.util.NbBundle;

public class UnitTable
extends JTable {
    private UnitCategoryTableModel model = null;
    private static final int DARKER_COLOR_COMPONENT = 10;
    private TableCellRenderer enableRenderer = null;

    public UnitTable(TableModel tableModel) {
        super(tableModel);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTable.class, (String)"ACN_UnitTable"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UnitTab.class, (String)"ACD_UnitTable"));
        this.model = (UnitCategoryTableModel)tableModel;
        this.setShowGrid(false);
        this.setColumnsSize();
        this.setIntercellSpacing(new Dimension(0, 0));
        this.revalidate();
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        return this.model.isExpansionControlAtRow(n) ? new MoreRenderer() : super.getCellRenderer(n, n2);
    }

    public void addNotify() {
        super.addNotify();
        this.getParent().setBackground(this.getBackground());
    }

    public void removeNotify() {
        super.removeNotify();
        this.enableRenderer = null;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n;
        int n2;
        String string = null;
        Point point = mouseEvent.getPoint();
        int n3 = this.rowAtPoint(point);
        string = this.model.getToolTipText(n3, n2 = this.convertColumnIndexToModel(n = this.columnAtPoint(point)));
        return string != null ? string : super.getToolTipText(mouseEvent);
    }

    void resetEnableRenderer() {
        if (this.enableRenderer != null) {
            this.setEnableRenderer(this.enableRenderer);
        }
    }

    void setEnableRenderer(TableCellRenderer tableCellRenderer) {
        this.enableRenderer = tableCellRenderer;
        this.columnModel.getColumn(3).setCellRenderer(tableCellRenderer);
    }

    void resortByDefault() {
        ((MyTableHeader)this.getTableHeader()).setDefaultSorting();
    }

    void setColumnsSize() {
        int n = this.model.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(this.model.getPreferredWidth(this.getTableHeader(), i));
        }
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Serializable serializable;
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        Color color = this.getBackground();
        Color color2 = UnitTable.getDarkerColor(color);
        Unit unit = this.model.getUnitAtRow(n);
        if (unit != null && !unit.canBeMarked()) {
            component.setForeground(Color.gray);
        } else {
            if (n2 == 1 && unit != null && UpdateManager.TYPE.FEATURE.equals((Object)unit.updateUnit.getType())) {
                component.setFont(this.getFont().deriveFont(1));
            } else {
                component.setFont(this.getFont());
            }
            if (this.isRowSelected(n)) {
                component.setForeground(this.getSelectionForeground());
            } else {
                component.setForeground(this.getForeground());
            }
        }
        if (!this.isCellSelected(n, n2)) {
            if (n % 2 == 0 && !this.model.isExpansionControlAtRow(n)) {
                component.setBackground(color2);
            } else {
                component.setBackground(color);
            }
        } else if (this.model.isExpansionControlAtRow(n)) {
            component.setBackground(this.getBackground());
            component.setForeground(this.getForeground());
            serializable = (JComponent)component;
            ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder());
        }
        if (this.rowHeight < 0) {
            serializable = component.getFont();
            FontMetrics fontMetrics = component.getFontMetrics((Font)serializable);
            int n3 = new JTable().getRowHeight();
            this.rowHeight = Math.max(n3, fontMetrics.getHeight());
            this.setRowHeight(this.rowHeight);
        }
        return component;
    }

    static Color getDarkerColor(Color color) {
        return new Color(Math.abs(color.getRed() - 10), Math.abs(color.getGreen() - 10), Math.abs(color.getBlue() - 10));
    }

    protected JTableHeader createDefaultTableHeader() {
        return new MyTableHeader(this.columnModel);
    }

    private class MoreRenderer
    extends DefaultTableCellRenderer {
        private MoreRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component == null || object == null) {
                return component;
            }
            if (n2 == 1 && component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                StringBuilder stringBuilder = new StringBuilder();
                if (bl || bl2) {
                    stringBuilder.append("<b>").append(UnitTable.this.model.getExpansionControlText()).append("</b>");
                } else {
                    stringBuilder.append(UnitTable.this.model.getExpansionControlText());
                }
                this.setEnabled(bl);
                jLabel.setText("<html><a href=\"\">" + stringBuilder.toString() + "</a></html>");
            } else if (n2 != 1) {
                component = new JLabel();
            }
            return component;
        }
    }

    private class MyTableHeader
    extends JTableHeader {
        private SortColumnHeaderRenderer sortingRenderer;

        public MyTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            this.addMouseListener(new MouseAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() != 1) return;
                    if (!UnitTable.this.isEnabled()) {
                        return;
                    }
                    int n2 = MyTableHeader.this.columnAtPoint(mouseEvent.getPoint());
                    if (MyTableHeader.this.sortingRenderer == null) return;
                    Unit unit = null;
                    UnitCategoryTableModel unitCategoryTableModel = null;
                    try {
                        Object object;
                        unitCategoryTableModel = (UnitCategoryTableModel)UnitTable.this.getModel();
                        int n3 = UnitTable.this.getSelectedRow();
                        if (n3 > -1) {
                            unit = unitCategoryTableModel.getUnitAtRow(n3);
                        }
                        if (unitCategoryTableModel.isSortAllowed(object = MyTableHeader.this.getColumnModel().getColumn(n2).getIdentifier())) {
                            MyTableHeader.this.sortingRenderer.setSorting(object);
                            MyTableHeader.this.repaint();
                        }
                        Object var8_7 = null;
                        if (unit == null) return;
                        List<Unit> list = unitCategoryTableModel.getVisibleUnits();
                        if (unit == null) return;
                        n = list.indexOf(unit);
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        if (unit == null) throw throwable;
                        List<Unit> list = unitCategoryTableModel.getVisibleUnits();
                        int n4 = unit != null ? list.indexOf(unit) : -1;
                        if (n4 <= -1) throw throwable;
                        Unit unit2 = unitCategoryTableModel.getUnitAtRow(n4);
                        if (unit2 == null) throw throwable;
                        if (!unit.updateUnit.getCodeName().equals(unit2.updateUnit.getCodeName())) throw throwable;
                        UnitTable.this.getSelectionModel().setSelectionInterval(n4, n4);
                        Rectangle rectangle = UnitTable.this.getCellRect(n4, 0, true);
                        UnitTable.this.scrollRectToVisible(rectangle);
                        throw throwable;
                    }
                    int n5 = n;
                    if (n5 <= -1) return;
                    Unit unit3 = unitCategoryTableModel.getUnitAtRow(n5);
                    if (unit3 == null) return;
                    if (!unit.updateUnit.getCodeName().equals(unit3.updateUnit.getCodeName())) return;
                    UnitTable.this.getSelectionModel().setSelectionInterval(n5, n5);
                    Rectangle rectangle = UnitTable.this.getCellRect(n5, 0, true);
                    UnitTable.this.scrollRectToVisible(rectangle);
                }
            });
            this.setReorderingAllowed(false);
        }

        public void setDraggedColumn(TableColumn tableColumn) {
            if (null != tableColumn && tableColumn.getModelIndex() == 0) {
                return;
            }
            super.setDraggedColumn(tableColumn);
        }

        public void setDefaultRenderer(TableCellRenderer tableCellRenderer) {
            if (!(tableCellRenderer instanceof SortColumnHeaderRenderer)) {
                this.sortingRenderer = new SortColumnHeaderRenderer((UnitCategoryTableModel)UnitTable.this.getModel(), tableCellRenderer);
                tableCellRenderer = this.sortingRenderer;
            }
            super.setDefaultRenderer(tableCellRenderer);
        }

        public void setResizingColumn(TableColumn tableColumn) {
            if (null == this.getResizingColumn() || null == tableColumn) {
                // empty if block
            }
            super.setResizingColumn(tableColumn);
        }

        public void setDefaultSorting() {
            if (this.sortingRenderer != null) {
                this.sortingRenderer.setDefaultSorting();
            }
        }
    }
}

