/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.aqua;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonListener;

class AquaToolBarButtonUI
extends ButtonUI
implements ChangeListener {
    private static BasicButtonListener listener = new BasicButtonListener(null);
    private final Rectangle scratch = new Rectangle();
    private FontMetrics fm = null;
    private static final int minButtonSize = 32;

    public void installUI(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        abstractButton.addMouseListener(listener);
        abstractButton.addChangeListener(this);
        abstractButton.setContentAreaFilled(false);
        abstractButton.setOpaque(false);
        abstractButton.setFocusable(false);
        abstractButton.setBorderPainted(false);
        abstractButton.setBorder(BorderFactory.createEmptyBorder());
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removeMouseListener(listener);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        ((AbstractButton)changeEvent.getSource()).repaint();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = jComponent.getBounds(this.scratch);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        rectangle.x = 0;
        rectangle.y = 0;
        Paint paint = ((Graphics2D)graphics).getPaint();
        this.paintBackground((Graphics2D)graphics, abstractButton, rectangle);
        this.paintIcon(graphics, abstractButton, rectangle);
        this.paintText(graphics, abstractButton, rectangle);
        ((Graphics2D)graphics).setPaint(paint);
    }

    private void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle) {
        int n;
        String string = abstractButton.getText();
        if (string == null || string.length() == 0) {
            return;
        }
        graphics.setColor(abstractButton.getForeground());
        Font font = abstractButton.getFont();
        if (abstractButton.isSelected()) {
            font = new Font(font.getName(), 1, font.getSize());
        }
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.fm == null) {
            this.fm = fontMetrics;
        }
        int n2 = 0;
        Icon icon = abstractButton.getIcon();
        if (icon != null) {
            n2 = icon.getIconWidth() + 2;
        } else {
            n = fontMetrics.stringWidth(string);
            if (n <= rectangle.width) {
                n2 = rectangle.width / 2 - n / 2;
            }
        }
        n = fontMetrics.getHeight();
        int n3 = fontMetrics.getMaxAscent();
        if (n <= rectangle.height) {
            n3 += rectangle.height / 2 - n / 2;
        }
        graphics.drawString(string, n2, n3);
    }

    private void paintBackground(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
        if (abstractButton.isEnabled()) {
            if (abstractButton.getModel().isPressed()) {
                this.compositeColor(graphics2D, rectangle, Color.BLUE, 0.3f);
            } else if (abstractButton.getModel().isSelected()) {
                this.compositeColor(graphics2D, rectangle, new Color(0, 120, 255), 0.2f);
            }
        }
    }

    private void compositeColor(Graphics2D graphics2D, Rectangle rectangle, Color color, float f) {
        graphics2D.setColor(color);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setComposite(composite);
    }

    private static boolean isFirst(AbstractButton abstractButton) {
        if (abstractButton.getParent() != null && abstractButton.getParent().getComponentCount() > 1) {
            return abstractButton == abstractButton.getParent().getComponent(1);
        }
        return false;
    }

    private void paintIcon(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle) {
        boolean bl;
        Icon icon = this.getIconForState(abstractButton);
        boolean bl2 = bl = abstractButton.getText() == null || abstractButton.getText().length() == 0;
        if (icon != null) {
            int n = 0;
            int n2 = 0;
            int n3 = icon.getIconWidth();
            int n4 = icon.getIconHeight();
            if (n3 <= rectangle.width && bl) {
                n = rectangle.width / 2 - n3 / 2;
            }
            if (n4 <= rectangle.height) {
                n2 = rectangle.height / 2 - n4 / 2;
            }
            icon.paintIcon(abstractButton, graphics, n, n2);
        }
    }

    private Icon getIconForState(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = null;
        if (!abstractButton.isEnabled()) {
            Icon icon2 = icon = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            if (icon == null && buttonModel.isSelected()) {
                icon = abstractButton.getDisabledIcon();
            }
        } else {
            if (buttonModel.isArmed() && !buttonModel.isPressed() && (icon = buttonModel.isSelected() ? abstractButton.getRolloverSelectedIcon() : abstractButton.getRolloverIcon()) == null & buttonModel.isSelected()) {
                icon = abstractButton.getRolloverIcon();
            }
            if (buttonModel.isPressed()) {
                icon = abstractButton.getPressedIcon();
            } else if (buttonModel.isSelected()) {
                icon = abstractButton.getSelectedIcon();
            }
        }
        if (icon == null) {
            icon = abstractButton.getIcon();
        }
        return icon;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        int n;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        boolean bl = abstractButton.getText() == null || abstractButton.getText().length() == 0;
        Icon icon = this.getIconForState((AbstractButton)jComponent);
        int n2 = n = AquaToolBarButtonUI.isFirst(abstractButton) ? 0 : 32;
        Dimension dimension2 = icon == null ? new Dimension(bl ? 32 : 0, 32) : (dimension = new Dimension(Math.max(n, icon.getIconWidth() + 1), Math.max(32, icon.getIconHeight() + 1)));
        if (!bl) {
            FontMetrics fontMetrics = this.fm;
            if (fontMetrics == null && jComponent.getGraphicsConfiguration() != null) {
                fontMetrics = jComponent.getGraphicsConfiguration().createCompatibleImage(1, 1).getGraphics().getFontMetrics(jComponent.getFont());
            }
            if (fontMetrics == null) {
                fontMetrics = new BufferedImage(1, 1, 1).getGraphics().getFontMetrics(jComponent.getFont());
            }
            dimension.width += fontMetrics.stringWidth(abstractButton.getText());
        }
        return dimension;
    }
}

