/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.trafo;

import de.escape.quincunx.trafo.Point3D;
import de.escape.quincunx.trafo.Vector3D;

public final class Matrix4D {
    private static final double DEG2RAD = Math.PI / 180;
    public float xx;
    public float xy;
    public float xz;
    public float xw;
    public float yx;
    public float yy;
    public float yz;
    public float yw;
    public float zx;
    public float zy;
    public float zz;
    public float zw;
    public float wx;
    public float wy;
    public float wz;
    public float ww;

    public Matrix4D() {
        this.ww = 1.0f;
        this.zz = 1.0f;
        this.yy = 1.0f;
        this.xx = 1.0f;
    }

    public Matrix4D(Matrix4D m) {
        this.xx = m.xx;
        this.xy = m.xy;
        this.xz = m.xz;
        this.xw = m.xw;
        this.yx = m.yx;
        this.yy = m.yy;
        this.yz = m.yz;
        this.yw = m.yw;
        this.zx = m.zx;
        this.zy = m.zy;
        this.zz = m.zz;
        this.zw = m.zw;
        this.wx = m.wx;
        this.wy = m.wy;
        this.wz = m.wz;
        this.ww = m.ww;
    }

    public Matrix4D(float mxx, float mxy, float mxz, float mxw, float myx, float myy, float myz, float myw, float mzx, float mzy, float mzz, float mzw, float mwx, float mwy, float mwz, float mww) {
        this.xx = mxx;
        this.xy = mxy;
        this.xz = mxz;
        this.xw = mxw;
        this.yx = myx;
        this.yy = myy;
        this.yz = myz;
        this.yw = myw;
        this.zx = mzx;
        this.zy = mzy;
        this.zz = mzz;
        this.zw = mzw;
        this.wx = mwx;
        this.wy = mwy;
        this.wz = mwz;
        this.ww = mww;
    }

    public void identity() {
        this.ww = 1.0f;
        this.zz = 1.0f;
        this.yy = 1.0f;
        this.xx = 1.0f;
        this.wz = 0.0f;
        this.wy = 0.0f;
        this.wx = 0.0f;
        this.zw = 0.0f;
        this.zy = 0.0f;
        this.zx = 0.0f;
        this.yw = 0.0f;
        this.yz = 0.0f;
        this.yx = 0.0f;
        this.xw = 0.0f;
        this.xz = 0.0f;
        this.xy = 0.0f;
    }

    public void transponize() {
        float t = this.xy;
        this.xy = this.yx;
        this.yx = t;
        t = this.xz;
        this.xz = this.zx;
        this.zx = t;
        t = this.xw;
        this.xw = this.wx;
        this.wx = t;
        t = this.yz;
        this.yz = this.zy;
        this.zy = t;
        t = this.yw;
        this.yw = this.wy;
        this.wy = t;
        t = this.zw;
        this.zw = this.wz;
        this.wz = t;
    }

    public Vector3D mult(Vector3D v) {
        return new Vector3D(this.xx * v.x + this.xy * v.y + this.xz * v.z, this.yx * v.x + this.yy * v.y + this.yz * v.z, this.zx * v.x + this.zy * v.y + this.zz * v.z);
    }

    public void transform(Vector3D v) {
        float x = this.xx * v.x + this.xy * v.y + this.xz * v.z;
        float y = this.yx * v.x + this.yy * v.y + this.yz * v.z;
        float z = this.zx * v.x + this.zy * v.y + this.zz * v.z;
        v.x = x;
        v.y = y;
        v.z = z;
    }

    public Point3D mult(Point3D p) {
        Point3D ret = new Point3D(this.xx * p.x + this.xy * p.y + this.xz * p.z + this.xw, this.yx * p.x + this.yy * p.y + this.yz * p.z + this.yw, this.zx * p.x + this.zy * p.y + this.zz * p.z + this.zw);
        ret.scale(1.0f / (this.wx * p.x + this.wy * p.y + this.wz * p.z + this.ww));
        return ret;
    }

    public void transform(Point3D p) {
        float x = this.xx * p.x + this.xy * p.y + this.xz * p.z + this.xw;
        float y = this.yx * p.x + this.yy * p.y + this.yz * p.z + this.yw;
        float z = this.zx * p.x + this.zy * p.y + this.zz * p.z + this.zw;
        float w = this.wx * p.x + this.wy * p.y + this.wz * p.z + this.ww;
        p.x = x / w;
        p.y = y / w;
        p.z = z / w;
    }

    public Matrix4D mult(Matrix4D m) {
        if (m != null) {
            return new Matrix4D(this.xx * m.xx + this.xy * m.yx + this.xz * m.zx + this.xw * m.wx, this.xx * m.xy + this.xy * m.yy + this.xz * m.zy + this.xw * m.wy, this.xx * m.xz + this.xy * m.yz + this.xz * m.zz + this.xw * m.wz, this.xx * m.xw + this.xy * m.yw + this.xz * m.zw + this.xw * m.ww, this.yx * m.xx + this.yy * m.yx + this.yz * m.zx + this.yw * m.wx, this.yx * m.xy + this.yy * m.yy + this.yz * m.zy + this.yw * m.wy, this.yx * m.xz + this.yy * m.yz + this.yz * m.zz + this.yw * m.wz, this.yx * m.xw + this.yy * m.yw + this.yz * m.zw + this.yw * m.ww, this.zx * m.xx + this.zy * m.yx + this.zz * m.zx + this.zw * m.wx, this.zx * m.xy + this.zy * m.yy + this.zz * m.zy + this.zw * m.wy, this.zx * m.xz + this.zy * m.yz + this.zz * m.zz + this.zw * m.wz, this.zx * m.xw + this.zy * m.yw + this.zz * m.zw + this.zw * m.ww, this.wx * m.xx + this.wy * m.yx + this.wz * m.zx + this.ww * m.wx, this.wx * m.xy + this.wy * m.yy + this.wz * m.zy + this.ww * m.wy, this.wx * m.xz + this.wy * m.yz + this.wz * m.zz + this.ww * m.wz, this.wx * m.xw + this.wy * m.yw + this.wz * m.zw + this.ww * m.ww);
        }
        return new Matrix4D(this);
    }

    public void multBy(Matrix4D m) {
        float x = this.xx * m.xx + this.xy * m.yx + this.xz * m.zx + this.xw * m.wx;
        float y = this.xx * m.xy + this.xy * m.yy + this.xz * m.zy + this.xw * m.wy;
        float z = this.xx * m.xz + this.xy * m.yz + this.xz * m.zz + this.xw * m.wz;
        float w = this.xx * m.xw + this.xy * m.yw + this.xz * m.zw + this.xw * m.ww;
        this.xx = x;
        this.xy = y;
        this.xz = z;
        this.xw = w;
        x = this.yx * m.xx + this.yy * m.yx + this.yz * m.zx + this.yw * m.wx;
        y = this.yx * m.xy + this.yy * m.yy + this.yz * m.zy + this.yw * m.wy;
        z = this.yx * m.xz + this.yy * m.yz + this.yz * m.zz + this.yw * m.wz;
        w = this.yx * m.xw + this.yy * m.yw + this.yz * m.zw + this.yw * m.ww;
        this.yx = x;
        this.yy = y;
        this.yz = z;
        this.yw = w;
        x = this.zx * m.xx + this.zy * m.yx + this.zz * m.zx + this.zw * m.wx;
        y = this.zx * m.xy + this.zy * m.yy + this.zz * m.zy + this.zw * m.wy;
        z = this.zx * m.xz + this.zy * m.yz + this.zz * m.zz + this.zw * m.wz;
        w = this.zx * m.xw + this.zy * m.yw + this.zz * m.zw + this.zw * m.ww;
        this.zx = x;
        this.zy = y;
        this.zz = z;
        this.zw = w;
        x = this.wx * m.xx + this.wy * m.yx + this.wz * m.zx + this.ww * m.wx;
        y = this.wx * m.xy + this.wy * m.yy + this.wz * m.zy + this.ww * m.wy;
        z = this.wx * m.xz + this.wy * m.yz + this.wz * m.zz + this.ww * m.wz;
        w = this.wx * m.xw + this.wy * m.yw + this.wz * m.zw + this.ww * m.ww;
        this.wx = x;
        this.wy = y;
        this.wz = z;
        this.ww = w;
    }

    public void multLeftBy(Matrix4D m) {
        float x = m.xx * this.xx + m.xy * this.yx + m.xz * this.zx + m.xw * this.wx;
        float y = m.yx * this.xx + m.yy * this.yx + m.yz * this.zx + m.yw * this.wx;
        float z = m.zx * this.xx + m.zy * this.yx + m.zz * this.zx + m.zw * this.wx;
        float w = m.wx * this.xx + m.wy * this.yx + m.wz * this.zx + m.ww * this.wx;
        this.xx = x;
        this.yx = y;
        this.zx = z;
        this.wx = w;
        x = m.xx * this.xy + m.xy * this.yy + m.xz * this.zy + m.xw * this.wy;
        y = m.yx * this.xy + m.yy * this.yy + m.yz * this.zy + m.yw * this.wy;
        z = m.zx * this.xy + m.zy * this.yy + m.zz * this.zy + m.zw * this.wy;
        w = m.wx * this.xy + m.wy * this.yy + m.wz * this.zy + m.ww * this.wy;
        this.xy = x;
        this.yy = y;
        this.zy = z;
        this.wy = w;
        x = m.xx * this.xz + m.xy * this.yz + m.xz * this.zz + m.xw * this.wz;
        y = m.yx * this.xz + m.yy * this.yz + m.yz * this.zz + m.yw * this.wz;
        z = m.zx * this.xz + m.zy * this.yz + m.zz * this.zz + m.zw * this.wz;
        w = m.wx * this.xz + m.wy * this.yz + m.wz * this.zz + m.ww * this.wz;
        this.xz = x;
        this.yz = y;
        this.zz = z;
        this.wz = w;
        x = m.xx * this.xw + m.xy * this.yw + m.xz * this.zw + m.xw * this.ww;
        y = m.yx * this.xw + m.yy * this.yw + m.yz * this.zw + m.yw * this.ww;
        z = m.zx * this.xw + m.zy * this.yw + m.zz * this.zw + m.zw * this.ww;
        w = m.wx * this.xw + m.wy * this.yw + m.wz * this.zw + m.ww * this.ww;
        this.xw = x;
        this.yw = y;
        this.zw = z;
        this.ww = w;
    }

    public void translate(float x, float y, float z) {
        this.xw += x * this.xx + y * this.xy + z * this.xz;
        this.yw += x * this.yx + y * this.yy + z * this.yz;
        this.zw += x * this.zx + y * this.zy + z * this.zz;
        this.ww += x * this.wx + y * this.wy + z * this.wz;
    }

    public void translate(Vector3D v) {
        this.translate(v.x, v.y, v.z);
    }

    public void translateLeft(float x, float y, float z) {
        if (x != 0.0f) {
            this.xx += x * this.wx;
            this.xy += x * this.wy;
            this.xz += x * this.wz;
            this.xw += x * this.ww;
        }
        if (y != 0.0f) {
            this.yx += y * this.wx;
            this.yy += y * this.wy;
            this.yz += y * this.wz;
            this.yw += y * this.ww;
        }
        if (z != 0.0f) {
            this.zx += z * this.wx;
            this.zy += z * this.wy;
            this.zz += z * this.wz;
            this.zw += z * this.ww;
        }
    }

    public void translateLeft(Vector3D v) {
        this.translateLeft(v.x, v.y, v.z);
    }

    public void moveBy(float x, float y, float z) {
        if (x != 0.0f) {
            this.xx += x * this.xw;
            this.yx += x * this.yw;
            this.zx += x * this.zw;
            this.wx += x * this.ww;
        }
        if (y != 0.0f) {
            this.xy += y * this.xw;
            this.yy += y * this.yw;
            this.zy += y * this.zw;
            this.wy += y * this.ww;
        }
        if (z != 0.0f) {
            this.xz += z * this.xw;
            this.yz += z * this.yw;
            this.zz += z * this.zw;
            this.wz += z * this.ww;
        }
    }

    public void moveBy(Vector3D v) {
        this.moveBy(v.x, v.y, v.z);
    }

    public void yrot(double theta) {
        if (theta == 0.0) {
            return;
        }
        double ct = Math.cos(theta);
        double st = -Math.sin(theta);
        float Nx = (float)((double)this.xx * ct - (double)this.zx * st);
        float Nz = (float)((double)this.xx * st + (double)this.zx * ct);
        this.xx = Nx;
        this.zx = Nz;
        Nx = (float)((double)this.xy * ct - (double)this.zy * st);
        Nz = (float)((double)this.xy * st + (double)this.zy * ct);
        this.xy = Nx;
        this.zy = Nz;
        Nx = (float)((double)this.xz * ct - (double)this.zz * st);
        Nz = (float)((double)this.xz * st + (double)this.zz * ct);
        this.xz = Nx;
        this.zz = Nz;
        Nx = (float)((double)this.xw * ct - (double)this.zw * st);
        Nz = (float)((double)this.xw * st + (double)this.zw * ct);
        this.xw = Nx;
        this.zw = Nz;
    }

    public void xrot(double theta) {
        if (theta == 0.0) {
            return;
        }
        double ct = Math.cos(theta);
        double st = Math.sin(theta);
        float Ny = (float)((double)this.yx * ct - (double)this.zx * st);
        float Nz = (float)((double)this.yx * st + (double)this.zx * ct);
        this.yx = Ny;
        this.zx = Nz;
        Ny = (float)((double)this.yy * ct - (double)this.zy * st);
        Nz = (float)((double)this.yy * st + (double)this.zy * ct);
        this.yy = Ny;
        this.zy = Nz;
        Ny = (float)((double)this.yz * ct - (double)this.zz * st);
        Nz = (float)((double)this.yz * st + (double)this.zz * ct);
        this.yz = Ny;
        this.zz = Nz;
        Ny = (float)((double)this.yw * ct - (double)this.zw * st);
        Nz = (float)((double)this.yw * st + (double)this.zw * ct);
        this.yw = Ny;
        this.zw = Nz;
    }

    public void zrot(double theta) {
        if (theta == 0.0) {
            return;
        }
        double ct = Math.cos(theta);
        double st = Math.sin(theta);
        float Nx = (float)((double)this.xx * ct - (double)this.yx * st);
        float Ny = (float)((double)this.xx * st + (double)this.yx * ct);
        this.xx = Nx;
        this.yx = Ny;
        Nx = (float)((double)this.xy * ct - (double)this.yy * st);
        Ny = (float)((double)this.xy * st + (double)this.yy * ct);
        this.xy = Nx;
        this.yy = Ny;
        Nx = (float)((double)this.xz * ct - (double)this.yz * st);
        Ny = (float)((double)this.xz * st + (double)this.yz * ct);
        this.xz = Nx;
        this.yz = Ny;
        Nx = (float)((double)this.xw * ct - (double)this.yw * st);
        Ny = (float)((double)this.xw * st + (double)this.yw * ct);
        this.xw = Nx;
        this.yw = Ny;
    }

    public void scale(float f) {
        this.xx *= f;
        this.yx *= f;
        this.zx *= f;
        this.wx *= f;
        this.xy *= f;
        this.yy *= f;
        this.zy *= f;
        this.wy *= f;
        this.xz *= f;
        this.yz *= f;
        this.zz *= f;
        this.wz *= f;
    }

    public void scale(float fx, float fy, float fz) {
        this.xx *= fx;
        this.yx *= fx;
        this.zx *= fx;
        this.wx *= fx;
        this.xy *= fy;
        this.yy *= fy;
        this.zy *= fy;
        this.wy *= fy;
        this.xz *= fz;
        this.yz *= fz;
        this.zz *= fz;
        this.wz *= fz;
    }

    public void transform(Point3D[] v, int[] tx, int[] ty, int[] tz, int npoints) {
        int i = npoints;
        while (--i >= 0) {
            Point3D tmp = this.mult(v[i]);
            tx[i] = (int)tmp.x;
            ty[i] = (int)tmp.y;
            tz[i] = (int)tmp.z;
        }
    }

    public String toString() {
        return new String(new StringBuffer().append("{{").append(this.xx).append(",").append(this.xy).append(",").append(this.xz).append(",").append(this.xw).append("},{").append(this.yx).append(",").append(this.yy).append(",").append(this.yz).append(",").append(this.yw).append("},{").append(this.zx).append(",").append(this.zy).append(",").append(this.zz).append(",").append(this.zw).append("},{").append(this.wx).append(",").append(this.wy).append(",").append(this.wz).append(",").append(this.ww).append("}}"));
    }
}

