/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.corrector;

import java.util.Arrays;
import java.util.Map;
import org.openstreetmap.josm.actions.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.Utils;

public final class ReverseWayNoTagCorrector {
    private static final TagCollection DIRECTIONAL_TAGS = new TagCollection(Arrays.asList(new Tag("natural", "coastline"), new Tag("natural", "cliff"), new Tag("barrier", "guard_rail"), new Tag("barrier", "kerb"), new Tag("barrier", "retaining_wall"), new Tag("man_made", "embankment")));

    private ReverseWayNoTagCorrector() {
    }

    public static TagCollection getDirectionalTags(Tagged way) {
        TagCollection collection = new TagCollection();
        for (Map.Entry<String, String> entry : way.getKeys().entrySet()) {
            boolean cannotBeCorrected;
            Tag tag = new Tag(entry.getKey(), entry.getValue());
            boolean isDirectional = DIRECTIONAL_TAGS.contains(tag) || tag.isDirectionKey();
            if (!isDirectional || !(cannotBeCorrected = ReverseWayTagCorrector.getTagCorrections(tag).isEmpty())) continue;
            collection.add(tag);
        }
        return collection;
    }

    public static boolean isReversible(Tagged way) {
        return ReverseWayNoTagCorrector.getDirectionalTags(way).isEmpty();
    }

    private static boolean confirmReverseWay(Way way, TagCollection tags) {
        String msg = I18n.trn("<html>You are going to reverse the way ''{0}'',<br/> whose semantic meaning of its tag ''{1}'' is defined by its direction.<br/>Do you really want to change the way direction, thus its semantic meaning?</html>", "<html>You are going to reverse the way ''{0}'',<br/> whose semantic meaning of these tags are defined by its direction:<br/>{1}Do you really want to change the way direction, thus its semantic meaning?</html>", tags.size(), Utils.escapeReservedCharactersHTML(way.getDisplayName(DefaultNameFormatter.getInstance())), Utils.joinAsHtmlUnorderedList(tags));
        int ret = ConditionalOptionPaneUtil.showOptionDialog("reverse_directional_way", MainApplication.getMainFrame(), msg, I18n.tr("Reverse directional way.", new Object[0]), 1, 2, null, null);
        switch (ret) {
            case -2147483648: 
            case 0: {
                return true;
            }
        }
        return false;
    }

    public static void checkAndConfirmReverseWay(Way way) throws UserCancelException {
        TagCollection tags = ReverseWayNoTagCorrector.getDirectionalTags(way);
        if (!tags.isEmpty() && !ReverseWayNoTagCorrector.confirmReverseWay(way, tags)) {
            throw new UserCancelException();
        }
    }
}

