/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge.colibri;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.OctoConfig;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.CascadeLink;
import org.jitsi.jicofo.bridge.CascadeNode;
import org.jitsi.jicofo.bridge.colibri.Colibri2Session;
import org.jitsi.jicofo.bridge.colibri.Colibri2SessionKt;
import org.jitsi.jicofo.bridge.colibri.ColibriV2SessionManager;
import org.jitsi.jicofo.bridge.colibri.ExtensionsKt;
import org.jitsi.jicofo.bridge.colibri.ParticipantInfo;
import org.jitsi.jicofo.codec.CodecUtil;
import org.jitsi.jicofo.codec.Config;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.conference.source.EndpointSourceSet;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.colibri2.AbstractConferenceEntity;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Endpoint;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Error;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Relay;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifiedIQ;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQ;
import org.jitsi.xmpp.extensions.colibri2.Endpoints;
import org.jitsi.xmpp.extensions.colibri2.InitialLastN;
import org.jitsi.xmpp.extensions.colibri2.Media;
import org.jitsi.xmpp.extensions.colibri2.Sctp;
import org.jitsi.xmpp.extensions.colibri2.Transport;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ExtmapAllowMixedPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.util.XmlStringBuilderUtil;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.packet.AbstractError;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.muc.MUCRole;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0000\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001]B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ5\u0010)\u001a\u00020*2\u0006\u0010 \u001a\u00020\u001c2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020\b2\b\u0010/\u001a\u0004\u0018\u00010\u001cH\u0000\u00a2\u0006\u0002\b0J\u0017\u00101\u001a\u000702\u00a2\u0006\u0002\b32\b\b\u0002\u00104\u001a\u00020\bH\u0002J\r\u00105\u001a\u00020*H\u0000\u00a2\u0006\u0002\b6J\u001b\u00105\u001a\u00020*2\f\u00107\u001a\b\u0012\u0004\u0012\u00020-0,H\u0000\u00a2\u0006\u0002\b6J\u0015\u00105\u001a\u00020*2\u0006\u00108\u001a\u00020-H\u0000\u00a2\u0006\u0002\b6J\r\u00109\u001a\u00020*H\u0000\u00a2\u0006\u0002\b:J\u0015\u0010;\u001a\u00020*2\u0006\u0010 \u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b<J\u0016\u0010=\u001a\u00020*2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001c0,H\u0002J#\u0010?\u001a\u00020*2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010 \u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\bAJ\u0015\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020-H\u0000\u00a2\u0006\u0002\bEJ\u0018\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u001cH\u0002J\u001d\u0010J\u001a\u00020*2\u0006\u0010K\u001a\u00020L2\u0006\u0010 \u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\bMJ\u0006\u0010N\u001a\u00020OJ\b\u0010P\u001a\u00020\u001cH\u0016J\u001b\u0010Q\u001a\u00020*2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020-0RH\u0000\u00a2\u0006\u0002\bSJ3\u0010T\u001a\u00020*2\u0006\u0010D\u001a\u00020-2\b\u0010K\u001a\u0004\u0018\u00010L2\b\u0010U\u001a\u0004\u0018\u00010V2\b\u0010W\u001a\u0004\u0018\u00010XH\u0000\u00a2\u0006\u0002\bYJ%\u0010Z\u001a\u00020*2\u0006\u0010[\u001a\u00020-2\u0006\u0010 \u001a\u00020\u001c2\u0006\u00104\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\\R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\u0004\u0018\u00010\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR$\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u001c\u0012\b\u0012\u00060\u0002R\u00020\u00000#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0012R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lorg/jitsi/jicofo/bridge/colibri/Colibri2Session;", "Lorg/jitsi/jicofo/bridge/CascadeNode;", "Lorg/jitsi/jicofo/bridge/colibri/Colibri2Session$Relay;", "colibriSessionManager", "Lorg/jitsi/jicofo/bridge/colibri/ColibriV2SessionManager;", "bridge", "Lorg/jitsi/jicofo/bridge/Bridge;", "visitor", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/jicofo/bridge/colibri/ColibriV2SessionManager;Lorg/jitsi/jicofo/bridge/Bridge;ZLorg/jitsi/utils/logging2/Logger;)V", "getBridge", "()Lorg/jitsi/jicofo/bridge/Bridge;", "getColibriSessionManager", "()Lorg/jitsi/jicofo/bridge/colibri/ColibriV2SessionManager;", "created", "getCreated", "()Z", "setCreated", "(Z)V", "feedbackSources", "Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;", "getFeedbackSources$jicofo_selector", "()Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;", "setFeedbackSources$jicofo_selector", "(Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;)V", "id", "", "getId", "()Ljava/lang/String;", "logger", "relayId", "getRelayId", "relays", "", "getRelays", "()Ljava/util/Map;", "getVisitor", "xmppConnection", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "createRelay", "", "initialParticipants", "", "Lorg/jitsi/jicofo/bridge/colibri/ParticipantInfo;", "initiator", "meshId", "createRelay$jicofo_selector", "createRequest", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ$Builder;", "Lorg/jetbrains/annotations/NotNull;", "create", "expire", "expire$jicofo_selector", "participantsToExpire", "participantToExpire", "expireAllRelays", "expireAllRelays$jicofo_selector", "expireRelay", "expireRelay$jicofo_selector", "expireRelays", "relayIds", "expireRemoteParticipants", "participants", "expireRemoteParticipants$jicofo_selector", "sendAllocationRequest", "Lorg/jivesoftware/smack/StanzaCollector;", "participant", "sendAllocationRequest$jicofo_selector", "sendRequest", "iq", "Lorg/jivesoftware/smack/packet/IQ;", "name", "setRelayTransport", "transport", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "setRelayTransport$jicofo_selector", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "toString", "updateForceMute", "", "updateForceMute$jicofo_selector", "updateParticipant", "sources", "Lorg/jitsi/jicofo/conference/source/EndpointSourceSet;", "initialLastN", "Lorg/jitsi/xmpp/extensions/colibri2/InitialLastN;", "updateParticipant$jicofo_selector", "updateRemoteParticipant", "participantInfo", "updateRemoteParticipant$jicofo_selector", "Relay", "jicofo-selector"})
@SourceDebugExtension(value={"SMAP\nColibri2Session.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Colibri2Session.kt\norg/jitsi/jicofo/bridge/colibri/Colibri2Session\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,546:1\n1#2:547\n1855#3,2:548\n1855#3,2:550\n1855#3,2:552\n1549#3:554\n1620#3,3:555\n1855#3,2:558\n1855#3,2:560\n1855#3,2:562\n1549#3:564\n1620#3,3:565\n1549#3:568\n1620#3,3:569\n*S KotlinDebug\n*F\n+ 1 Colibri2Session.kt\norg/jitsi/jicofo/bridge/colibri/Colibri2Session\n*L\n111#1:548,2\n157#1:550,2\n186#1:552,2\n222#1:554\n222#1:555,3\n277#1:558,2\n286#1:560,2\n341#1:562,2\n188#1:564\n188#1:565,3\n251#1:568\n251#1:569,3\n*E\n"})
public final class Colibri2Session
implements CascadeNode<Colibri2Session, Relay> {
    @NotNull
    private final ColibriV2SessionManager colibriSessionManager;
    @NotNull
    private final Bridge bridge;
    private final boolean visitor;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AbstractXMPPConnection xmppConnection;
    @NotNull
    private final String id;
    @Nullable
    private final String relayId;
    private boolean created;
    @NotNull
    private ConferenceSourceMap feedbackSources;
    @NotNull
    private final Map<String, Relay> relays;

    /*
     * WARNING - void declaration
     */
    public Colibri2Session(@NotNull ColibriV2SessionManager colibriSessionManager, @NotNull Bridge bridge2, boolean visitor2, @NotNull Logger parentLogger) {
        Logger logger;
        Intrinsics.checkNotNullParameter(colibriSessionManager, "colibriSessionManager");
        Intrinsics.checkNotNullParameter(bridge2, "bridge");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.colibriSessionManager = colibriSessionManager;
        this.bridge = bridge2;
        this.visitor = visitor2;
        Logger logger2 = logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        Colibri2Session colibri2Session = this;
        boolean bl = false;
        CharSequence charSequence = this.bridge.getJid().getResourceOrNull();
        if (charSequence != null && (charSequence = charSequence.toString()) != null) {
            void $this$logger_u24lambda_u241;
            CharSequence it = charSequence;
            boolean bl2 = false;
            $this$logger_u24lambda_u241.addContext("bridge", (String)it);
        }
        colibri2Session.logger = logger;
        this.xmppConnection = this.colibriSessionManager.getXmppConnection$jicofo_selector();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.id = string;
        this.relayId = this.bridge.getRelayId();
        this.feedbackSources = new ConferenceSourceMap(null, 1, null);
        this.relays = new LinkedHashMap();
    }

    @NotNull
    public final ColibriV2SessionManager getColibriSessionManager() {
        return this.colibriSessionManager;
    }

    @NotNull
    public final Bridge getBridge() {
        return this.bridge;
    }

    public final boolean getVisitor() {
        return this.visitor;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getRelayId() {
        return this.relayId;
    }

    public final boolean getCreated() {
        return this.created;
    }

    public final void setCreated(boolean bl) {
        this.created = bl;
    }

    @NotNull
    public final ConferenceSourceMap getFeedbackSources$jicofo_selector() {
        return this.feedbackSources;
    }

    public final void setFeedbackSources$jicofo_selector(@NotNull ConferenceSourceMap conferenceSourceMap) {
        Intrinsics.checkNotNullParameter(conferenceSourceMap, "<set-?>");
        this.feedbackSources = conferenceSourceMap;
    }

    @Override
    @NotNull
    public Map<String, Relay> getRelays() {
        return this.relays;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StanzaCollector sendAllocationRequest$jicofo_selector(@NotNull ParticipantInfo participant) {
        void $this$sendAllocationRequest_u24lambda_u243_u24lambda_u242;
        Transport.Builder builder;
        Colibri2Endpoint.Builder builder2;
        Intrinsics.checkNotNullParameter(participant, "participant");
        ConferenceModifyIQ.Builder request = this.createRequest(!this.created);
        Colibri2Endpoint.Builder $this$sendAllocationRequest_u24lambda_u243 = builder2 = ExtensionsKt.toEndpoint(participant, true, false);
        boolean bl = false;
        if (participant.getAudioMuted() || participant.getVideoMuted()) {
            $this$sendAllocationRequest_u24lambda_u243.setForceMute(participant.getAudioMuted(), participant.getVideoMuted());
        }
        if (participant.getVisitor()) {
            $this$sendAllocationRequest_u24lambda_u243.setMucRole(MUCRole.visitor);
        }
        Transport.Builder builder3 = builder = Transport.getBuilder();
        Colibri2Endpoint.Builder builder4 = $this$sendAllocationRequest_u24lambda_u243;
        boolean bl2 = false;
        $this$sendAllocationRequest_u24lambda_u243_u24lambda_u242.setIceControlling(true);
        if (participant.getUseSctp()) {
            $this$sendAllocationRequest_u24lambda_u243_u24lambda_u242.setSctp(new Sctp.Builder().build());
        }
        builder4.setTransport(builder.build());
        Colibri2Endpoint.Builder endpoint = builder2;
        Iterable $this$forEach$iv = participant.getMedias();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Media it = (Media)element$iv;
            boolean bl3 = false;
            endpoint.addMedia(it);
        }
        request.addEndpoint(endpoint.build());
        this.logger.trace(() -> Colibri2Session.sendAllocationRequest$lambda$5(participant, request));
        this.created = true;
        StanzaCollector stanzaCollector = this.xmppConnection.createStanzaCollectorAndSend(request.build());
        Intrinsics.checkNotNullExpressionValue(stanzaCollector, "createStanzaCollectorAndSend(...)");
        return stanzaCollector;
    }

    public final void updateParticipant$jicofo_selector(@NotNull ParticipantInfo participant, @Nullable IceUdpTransportPacketExtension transport, @Nullable EndpointSourceSet sources, @Nullable InitialLastN initialLastN) {
        Colibri2Endpoint.Builder builder;
        Intrinsics.checkNotNullParameter(participant, "participant");
        if (transport == null && sources == null && initialLastN == null) {
            this.logger.info("Nothing to update.");
            return;
        }
        ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this, false, 1, null);
        Colibri2Endpoint.Builder $this$updateParticipant_u24lambda_u246 = builder = Colibri2Endpoint.getBuilder();
        boolean bl = false;
        $this$updateParticipant_u24lambda_u246.setId(participant.getId());
        $this$updateParticipant_u24lambda_u246.setStatsId(participant.getStatsId());
        Colibri2Endpoint.Builder builder2 = builder;
        Intrinsics.checkNotNullExpressionValue(builder2, "apply(...)");
        Colibri2Endpoint.Builder endpoint = builder2;
        if (transport != null) {
            endpoint.setTransport(Transport.getBuilder().setIceUdpExtension(transport).build());
        }
        if (sources != null) {
            endpoint.setSources(ExtensionsKt.toColibriMediaSources(sources, participant.getId()));
        }
        InitialLastN initialLastN2 = initialLastN;
        if (initialLastN2 != null) {
            InitialLastN it = initialLastN2;
            boolean bl2 = false;
            endpoint.setInitialLastN(it);
        }
        request.addEndpoint(endpoint.build());
        ConferenceModifyIQ conferenceModifyIQ = request.build();
        Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "build(...)");
        this.sendRequest(conferenceModifyIQ, "updateParticipant");
    }

    /*
     * WARNING - void declaration
     */
    public final void updateForceMute$jicofo_selector(@NotNull Set<ParticipantInfo> participants) {
        Intrinsics.checkNotNullParameter(participants, "participants");
        ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this, false, 1, null);
        Iterable $this$forEach$iv = participants;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$updateForceMute_u24lambda_u249_u24lambda_u248;
            Colibri2Endpoint.Builder builder;
            ParticipantInfo participant = (ParticipantInfo)element$iv;
            boolean bl = false;
            Colibri2Endpoint.Builder builder2 = builder = Colibri2Endpoint.getBuilder();
            ConferenceModifyIQ.Builder builder3 = request;
            boolean bl2 = false;
            $this$updateForceMute_u24lambda_u249_u24lambda_u248.setId(participant.getId());
            $this$updateForceMute_u24lambda_u249_u24lambda_u248.setForceMute(participant.getAudioMuted(), participant.getVideoMuted());
            builder3.addEndpoint(builder.build());
        }
        ConferenceModifyIQ conferenceModifyIQ = request.build();
        Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "build(...)");
        this.sendRequest(conferenceModifyIQ, "updateForceMute");
    }

    public final void expire$jicofo_selector() {
        this.getRelays().clear();
        ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this, false, 1, null).setExpire(true);
        ConferenceModifyIQ conferenceModifyIQ = request.build();
        Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "build(...)");
        this.sendRequest(conferenceModifyIQ, "expire");
    }

    public final void expire$jicofo_selector(@NotNull ParticipantInfo participantToExpire) {
        Intrinsics.checkNotNullParameter(participantToExpire, "participantToExpire");
        List<ParticipantInfo> list = Collections.singletonList(participantToExpire);
        Intrinsics.checkNotNullExpressionValue(list, "singletonList(...)");
        this.expire$jicofo_selector(list);
    }

    public final void expire$jicofo_selector(@NotNull List<ParticipantInfo> participantsToExpire) {
        Intrinsics.checkNotNullParameter(participantsToExpire, "participantsToExpire");
        if (participantsToExpire.isEmpty()) {
            this.logger.debug(Colibri2Session::expire$lambda$10);
            return;
        }
        ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this, false, 1, null);
        Iterable $this$forEach$iv = participantsToExpire;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParticipantInfo it = (ParticipantInfo)element$iv;
            boolean bl = false;
            Colibri2SessionKt.access$addExpire(request, it.getId());
        }
        this.logger.debug(() -> Colibri2Session.expire$lambda$13(participantsToExpire));
        ConferenceModifyIQ conferenceModifyIQ = request.build();
        Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "build(...)");
        this.sendRequest(conferenceModifyIQ, "expire(participantsToExpire)");
    }

    private final ConferenceModifyIQ.Builder createRequest(boolean create) {
        ConferenceModifyIQ.Builder builder;
        ConferenceModifyIQ.Builder $this$createRequest_u24lambda_u2414 = builder = ConferenceModifyIQ.builder(this.xmppConnection);
        boolean bl = false;
        $this$createRequest_u24lambda_u2414.to(this.bridge.getJid());
        $this$createRequest_u24lambda_u2414.setMeetingId(this.colibriSessionManager.getMeetingId$jicofo_selector());
        if (create) {
            $this$createRequest_u24lambda_u2414.setCreate(true);
            $this$createRequest_u24lambda_u2414.setConferenceName(this.colibriSessionManager.getConferenceName$jicofo_selector());
            $this$createRequest_u24lambda_u2414.setRtcstatsEnabled(this.colibriSessionManager.getRtcStatsEnabled$jicofo_selector());
        }
        ConferenceModifyIQ.Builder builder2 = builder;
        Intrinsics.checkNotNullExpressionValue(builder2, "apply(...)");
        return builder2;
    }

    static /* synthetic */ ConferenceModifyIQ.Builder createRequest$default(Colibri2Session colibri2Session, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return colibri2Session.createRequest(bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void createRelay$jicofo_selector(@NotNull String relayId, @NotNull List<ParticipantInfo> initialParticipants, boolean initiator, @Nullable String meshId) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(relayId, "relayId");
        Intrinsics.checkNotNullParameter(initialParticipants, "initialParticipants");
        Iterable iterable = initialParticipants;
        boolean bl = initiator;
        String string = relayId;
        Logger logger = this.logger;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParticipantInfo participantInfo = (ParticipantInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getId());
        }
        collection = (List)destination$iv$iv;
        logger.info("Creating relay " + string + " (initiator=" + bl + "), initial participants: " + (List)collection);
        if (this.getRelays().containsKey(relayId)) {
            throw new IllegalStateException("Relay " + relayId + " already exists (bridge=" + this.getRelayId());
        }
        Relay relay = new Relay(this, relayId, initiator, meshId);
        this.getRelays().put(relayId, relay);
        relay.start$jicofo_selector(initialParticipants);
    }

    public final void updateRemoteParticipant$jicofo_selector(@NotNull ParticipantInfo participantInfo, @NotNull String relayId, boolean create) {
        Unit unit;
        Intrinsics.checkNotNullParameter(participantInfo, "participantInfo");
        Intrinsics.checkNotNullParameter(relayId, "relayId");
        this.logger.debug(() -> Colibri2Session.updateRemoteParticipant$lambda$16(participantInfo, relayId));
        Relay relay = this.getRelays().get(relayId);
        if (relay != null) {
            relay.updateParticipant(participantInfo, create);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("Relay " + relayId + " doesn't exist (bridge=" + this.getRelayId() + ")");
        }
    }

    public final void expireRemoteParticipants$jicofo_selector(@NotNull List<ParticipantInfo> participants, @NotNull String relayId) {
        Unit unit;
        Intrinsics.checkNotNullParameter(participants, "participants");
        Intrinsics.checkNotNullParameter(relayId, "relayId");
        this.logger.debug(() -> Colibri2Session.expireRemoteParticipants$lambda$18(relayId, participants));
        Relay relay = this.getRelays().get(relayId);
        if (relay != null) {
            relay.expireParticipants(participants);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("Relay " + relayId + " doesn't exist (bridge=" + this.getRelayId() + ")");
        }
    }

    public final void setRelayTransport$jicofo_selector(@NotNull IceUdpTransportPacketExtension transport, @NotNull String relayId) {
        Unit unit;
        Intrinsics.checkNotNullParameter(transport, "transport");
        Intrinsics.checkNotNullParameter(relayId, "relayId");
        this.logger.info("Setting relay transport for " + relayId);
        this.logger.debug(() -> Colibri2Session.setRelayTransport$lambda$19(relayId, transport));
        Relay relay = this.getRelays().get(relayId);
        if (relay != null) {
            relay.setTransport(transport);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new IllegalStateException("Relay " + relayId + " doesn't exist (bridge=" + this.getRelayId());
        }
    }

    public final void expireAllRelays$jicofo_selector() {
        this.expireRelays(CollectionsKt.toList((Iterable)this.getRelays().keySet()));
    }

    public final void expireRelay$jicofo_selector(@NotNull String relayId) {
        Intrinsics.checkNotNullParameter(relayId, "relayId");
        this.expireRelays(CollectionsKt.listOf(relayId));
    }

    /*
     * WARNING - void declaration
     */
    private final void expireRelays(List<String> relayIds) {
        String it;
        if (relayIds.isEmpty()) {
            this.logger.debug("No relays to expire.");
            return;
        }
        this.logger.info("Expiring relays: " + relayIds);
        ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this, false, 1, null);
        Iterable $this$forEach$iv = relayIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$expireRelays_u24lambda_u2421_u24lambda_u2420;
            Colibri2Relay.Builder builder;
            it = (String)element$iv;
            boolean bl = false;
            Colibri2Relay.Builder builder2 = builder = Colibri2Relay.getBuilder();
            ConferenceModifyIQ.Builder builder3 = request;
            boolean bl2 = false;
            $this$expireRelays_u24lambda_u2421_u24lambda_u2420.setId(it);
            $this$expireRelays_u24lambda_u2421_u24lambda_u2420.setExpire(true);
            builder3.addRelay(builder.build());
        }
        $this$forEach$iv = relayIds;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            this.getRelays().remove(it);
        }
        ConferenceModifyIQ conferenceModifyIQ = request.build();
        Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "build(...)");
        this.sendRequest(conferenceModifyIQ, "expireRelays");
    }

    private final void sendRequest(IQ iq, String name) {
        this.logger.debug(() -> Colibri2Session.sendRequest$lambda$23(name, iq));
        ExtensionsKt.sendIqAndHandleResponseAsync(this.xmppConnection, iq, (Function1<? super IQ, Unit>)new Function1<IQ, Unit>(this, name, iq){
            final /* synthetic */ Colibri2Session this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ IQ $iq;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                this.$iq = $iq;
                super(1);
            }

            public final void invoke(@Nullable IQ it) {
                IQ iQ = it;
                if (iQ instanceof ConferenceModifiedIQ) {
                    Colibri2Session.access$getLogger$p(this.this$0).debug(() -> sendRequest.2.invoke$lambda$0(this.$name, it));
                } else if (iQ == null) {
                    Colibri2Session.access$getLogger$p(this.this$0).info(this.$name + " request timed out. Ignoring.");
                } else {
                    if (it instanceof ErrorIQ) {
                        boolean reInvite;
                        Colibri2Endpoint colibri2Endpoint;
                        ExtensionElement extensionElement;
                        StanzaError stanzaError = ((ErrorIQ)it).getError();
                        Colibri2Error.Reason reason = stanzaError != null && (extensionElement = (Colibri2Error)stanzaError.getExtension("error", "jitsi:colibri2")) != null ? ((Colibri2Error)extensionElement).getReason() : null;
                        extensionElement = ((ErrorIQ)it).getError();
                        String endpointId = extensionElement != null && (colibri2Endpoint = (Colibri2Endpoint)((AbstractError)((Object)extensionElement)).getExtension("endpoint", "jitsi:colibri2")) != null ? colibri2Endpoint.getId() : null;
                        boolean bl = reInvite = reason == Colibri2Error.Reason.UNKNOWN_ENDPOINT && endpointId != null;
                        if (reInvite) {
                            Colibri2Session.access$getLogger$p(this.this$0).warn("Endpoint [" + endpointId + "] is not found, session failed: " + XmlStringBuilderUtil.Companion.toStringOpt(it) + ", request was: " + XmlStringBuilderUtil.Companion.toStringOpt(this.$iq));
                            ColibriV2SessionManager colibriV2SessionManager = this.this$0.getColibriSessionManager();
                            String string = endpointId;
                            Intrinsics.checkNotNull(string);
                            colibriV2SessionManager.endpointFailed$jicofo_selector(string);
                            return;
                        }
                    }
                    Colibri2Session.access$getLogger$p(this.this$0).error("Received error response for " + this.$name + ", session failed: " + XmlStringBuilderUtil.Companion.toStringOpt(it));
                    this.this$0.getColibriSessionManager().sessionFailed$jicofo_selector(this.this$0);
                }
            }

            private static final String invoke$lambda$0(String $name, IQ $it) {
                Intrinsics.checkNotNullParameter($name, "$name");
                return "Received " + $name + " response: " + XmlStringBuilderUtil.Companion.toStringOpt($it);
            }
        });
    }

    @NotNull
    public String toString() {
        return "Colibri2Session[bridge=" + this.bridge.getJid().getResourceOrNull() + ", id=" + this.id + "]";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OrderedJsonObject toJson() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject orderedJsonObject2;
        OrderedJsonObject $this$toJson_u24lambda_u2426 = orderedJsonObject2 = new OrderedJsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u2426.put("bridge", this.bridge.getDebugState());
        $this$toJson_u24lambda_u2426.put("id", this.id);
        $this$toJson_u24lambda_u2426.put("feedback_sources", this.feedbackSources.toJson());
        $this$toJson_u24lambda_u2426.put("created", (Object)this.created);
        OrderedJsonObject orderedJsonObject3 = orderedJsonObject = new OrderedJsonObject();
        String string = "relays";
        OrderedJsonObject orderedJsonObject4 = $this$toJson_u24lambda_u2426;
        boolean bl2 = false;
        Iterable $this$forEach$iv = this.getRelays().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$toJson_u24lambda_u2426_u24lambda_u2425;
            Relay it = (Relay)element$iv;
            boolean bl3 = false;
            $this$toJson_u24lambda_u2426_u24lambda_u2425.put(it.getRelayId(), it.toJson());
        }
        Unit unit = Unit.INSTANCE;
        orderedJsonObject4.put(string, orderedJsonObject);
        return orderedJsonObject2;
    }

    private static final String sendAllocationRequest$lambda$5(ParticipantInfo $participant, ConferenceModifyIQ.Builder $request) {
        Intrinsics.checkNotNullParameter($participant, "$participant");
        Intrinsics.checkNotNullParameter($request, "$request");
        String string = $participant.getId();
        ConferenceModifyIQ conferenceModifyIQ = $request.build();
        Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "build(...)");
        return "Sending allocation request for " + string + ": " + XmlStringBuilderUtil.Companion.toStringOpt(conferenceModifyIQ);
    }

    private static final String expire$lambda$10() {
        return "No participants to expire.";
    }

    /*
     * WARNING - void declaration
     */
    private static final String expire$lambda$13(List $participantsToExpire) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($participantsToExpire, "$participantsToExpire");
        Iterable $this$map$iv = $participantsToExpire;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParticipantInfo participantInfo = (ParticipantInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return "Expiring endpoint: " + (List)destination$iv$iv;
    }

    private static final String updateRemoteParticipant$lambda$16(ParticipantInfo $participantInfo, String $relayId) {
        Intrinsics.checkNotNullParameter($participantInfo, "$participantInfo");
        Intrinsics.checkNotNullParameter($relayId, "$relayId");
        return "Updating remote participant " + $participantInfo.getId() + " on " + $relayId;
    }

    /*
     * WARNING - void declaration
     */
    private static final String expireRemoteParticipants$lambda$18(String $relayId, List $participants) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter($relayId, "$relayId");
        Intrinsics.checkNotNullParameter($participants, "$participants");
        Iterable iterable = $participants;
        String string = $relayId;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParticipantInfo participantInfo = (ParticipantInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return "Expiring remote participants on " + string + ": " + (List)destination$iv$iv;
    }

    private static final String setRelayTransport$lambda$19(String $relayId, IceUdpTransportPacketExtension $transport) {
        Intrinsics.checkNotNullParameter($relayId, "$relayId");
        Intrinsics.checkNotNullParameter($transport, "$transport");
        return "Setting relay transport for " + $relayId + ": " + XmlStringBuilderUtil.Companion.toStringOpt($transport);
    }

    private static final String sendRequest$lambda$23(String $name, IQ $iq) {
        Intrinsics.checkNotNullParameter($name, "$name");
        Intrinsics.checkNotNullParameter($iq, "$iq");
        return "Sending " + $name + " request: " + XmlStringBuilderUtil.Companion.toStringOpt($iq);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ\u001b\u0010\u001d\u001a\u00020\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019H\u0000\u00a2\u0006\u0002\b\u001fJ\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u0005R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jitsi/jicofo/bridge/colibri/Colibri2Session$Relay;", "Lorg/jitsi/jicofo/bridge/CascadeLink;", "relayId", "", "initiator", "", "meshId", "(Lorg/jitsi/jicofo/bridge/colibri/Colibri2Session;Ljava/lang/String;ZLjava/lang/String;)V", "bridgeChannelActive", "dtlsSetup", "iceControlling", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getMeshId", "()Ljava/lang/String;", "getRelayId", "sctpBridgeChannel", "useUniquePort", "buildCreateRelayRequest", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ;", "participants", "", "Lorg/jitsi/jicofo/bridge/colibri/ParticipantInfo;", "expireParticipants", "", "", "setTransport", "transport", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "start", "initialParticipants", "start$jicofo_selector", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "updateParticipant", "participant", "create", "jicofo-selector"})
    @SourceDebugExtension(value={"SMAP\nColibri2Session.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Colibri2Session.kt\norg/jitsi/jicofo/bridge/colibri/Colibri2Session$Relay\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,546:1\n1#2:547\n1855#3,2:548\n1855#3,2:550\n1726#3,3:552\n1855#3,2:555\n1855#3,2:557\n1855#3,2:559\n1855#3,2:561\n1855#3,2:563\n766#3:565\n857#3,2:566\n1855#3,2:568\n*S KotlinDebug\n*F\n+ 1 Colibri2Session.kt\norg/jitsi/jicofo/bridge/colibri/Colibri2Session$Relay\n*L\n412#1:548,2\n425#1:550,2\n466#1:552,3\n473#1:555,2\n497#1:557,2\n498#1:559,2\n507#1:561,2\n508#1:563,2\n516#1:565\n516#1:566,2\n516#1:568,2\n*E\n"})
    public final class Relay
    implements CascadeLink {
        @NotNull
        private final String relayId;
        @Nullable
        private final String meshId;
        private final boolean useUniquePort;
        private final boolean iceControlling;
        @NotNull
        private final String dtlsSetup;
        private final boolean bridgeChannelActive;
        private final boolean sctpBridgeChannel;
        @NotNull
        private final Logger logger;
        final /* synthetic */ Colibri2Session this$0;

        /*
         * WARNING - void declaration
         */
        public Relay(@NotNull Colibri2Session this$0, String relayId, @Nullable boolean initiator, String meshId) {
            void $this$logger_u24lambda_u240;
            Logger logger;
            Intrinsics.checkNotNullParameter(relayId, "relayId");
            this.this$0 = this$0;
            this.relayId = relayId;
            this.meshId = meshId;
            this.useUniquePort = initiator;
            this.iceControlling = initiator;
            this.dtlsSetup = initiator ? "active" : "passive";
            this.bridgeChannelActive = initiator;
            this.sctpBridgeChannel = OctoConfig.config.getSctpDatachannels();
            Logger logger2 = logger = LoggerExtensionsKt.createChildLogger$default(this, this.this$0.logger, null, 2, null);
            Relay relay = this;
            boolean bl = false;
            $this$logger_u24lambda_u240.addContext("relay", this.getRelayId());
            relay.logger = logger;
        }

        public /* synthetic */ Relay(Colibri2Session colibri2Session, String string, boolean bl, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(colibri2Session, string, bl, string2);
        }

        @Override
        @NotNull
        public String getRelayId() {
            return this.relayId;
        }

        @Override
        @Nullable
        public String getMeshId() {
            return this.meshId;
        }

        public final void start$jicofo_selector(@NotNull List<ParticipantInfo> initialParticipants) {
            Intrinsics.checkNotNullParameter(initialParticipants, "initialParticipants");
            ConferenceModifyIQ request = this.buildCreateRelayRequest((Collection<ParticipantInfo>)initialParticipants);
            this.logger.trace(() -> Relay.start$lambda$1(request));
            ExtensionsKt.sendIqAndHandleResponseAsync(this.this$0.xmppConnection, request, (Function1<? super IQ, Unit>)new Function1<IQ, Unit>(this, this.this$0){
                final /* synthetic */ Relay this$0;
                final /* synthetic */ Colibri2Session this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                public final void invoke(@Nullable IQ response) {
                    Relay.access$getLogger$p(this.this$0).trace(() -> start.2.invoke$lambda$0(response));
                    if (!(response instanceof ConferenceModifiedIQ)) {
                        Logger logger = Relay.access$getLogger$p(this.this$0);
                        Object object = response;
                        if (object == null || (object = XmlStringBuilderUtil.Companion.toStringOpt((IQ)object)) == null) {
                            object = "timeout";
                        }
                        logger.error("Received error: " + (String)object);
                        this.this$1.getColibriSessionManager().sessionFailed$jicofo_selector(this.this$1);
                        return;
                    }
                    List<Colibri2Relay> list = ((ConferenceModifiedIQ)response).getRelays();
                    Intrinsics.checkNotNullExpressionValue(list, "getRelays(...)");
                    AbstractPacketExtension abstractPacketExtension = CollectionsKt.firstOrNull(list);
                    if (abstractPacketExtension == null || (abstractPacketExtension = ((AbstractConferenceEntity)abstractPacketExtension).getTransport()) == null) {
                        Relay relay = this.this$0;
                        Colibri2Session colibri2Session = this.this$1;
                        Relay $this$invoke_u24lambda_u241 = relay;
                        boolean bl = false;
                        Relay.access$getLogger$p($this$invoke_u24lambda_u241).error("No transport in response: " + XmlStringBuilderUtil.Companion.toStringOpt(response));
                        colibri2Session.getColibriSessionManager().sessionFailed$jicofo_selector(colibri2Session);
                        return;
                    }
                    AbstractPacketExtension transport = abstractPacketExtension;
                    IceUdpTransportPacketExtension iceUdpTransport = ((Transport)transport).getIceUdpTransport();
                    if (iceUdpTransport == null) {
                        Relay.access$getLogger$p(this.this$0).error("Response has no iceUdpTransport");
                        this.this$1.getColibriSessionManager().sessionFailed$jicofo_selector(this.this$1);
                        return;
                    }
                    this.this$1.getColibriSessionManager().setRelayTransport$jicofo_selector(this.this$1, iceUdpTransport, this.this$0.getRelayId());
                }

                private static final String invoke$lambda$0(IQ $response) {
                    IQ iQ = $response;
                    return "Received response: " + (iQ != null ? XmlStringBuilderUtil.Companion.toStringOpt(iQ) : null);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        public final void setTransport(@NotNull IceUdpTransportPacketExtension transport) {
            void $this$setTransport_u24lambda_u245;
            AbstractPacketExtension it;
            Object element$iv;
            Intrinsics.checkNotNullParameter(transport, "transport");
            List<DtlsFingerprintPacketExtension> list = transport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
            Intrinsics.checkNotNullExpressionValue(list, "getChildExtensionsOfType(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                it = (DtlsFingerprintPacketExtension)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getSetup(), "actpass")) {
                    this.logger.error("Response has an unexpected dtls setup field: " + it.getSetup());
                    return;
                }
                this.logger.info("Setting setup=" + this.dtlsSetup + " for " + this.getRelayId());
                it.setSetup(this.dtlsSetup);
            }
            if (this.sctpBridgeChannel || !this.bridgeChannelActive) {
                List<WebSocketPacketExtension> list2 = transport.getChildExtensionsOfType(WebSocketPacketExtension.class);
                Intrinsics.checkNotNullExpressionValue(list2, "getChildExtensionsOfType(...)");
                $this$forEach$iv = list2;
                $i$f$forEach = false;
                object = $this$forEach$iv.iterator();
                while (object.hasNext()) {
                    element$iv = object.next();
                    it = (WebSocketPacketExtension)element$iv;
                    boolean bl = false;
                    transport.removeChildExtension(it);
                }
            }
            ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this.this$0, false, 1, null);
            Object $this$setTransport_u24lambda_u244 = element$iv = Colibri2Relay.getBuilder();
            boolean bl = false;
            ((AbstractConferenceEntity.Builder)$this$setTransport_u24lambda_u244).setId(this.getRelayId());
            ((AbstractConferenceEntity.Builder)$this$setTransport_u24lambda_u244).setCreate(false);
            Object object2 = element$iv;
            Intrinsics.checkNotNullExpressionValue(object2, "apply(...)");
            Object relay = object2;
            element$iv = object = Transport.getBuilder();
            Object object3 = relay;
            boolean bl2 = false;
            $this$setTransport_u24lambda_u245.setIceUdpExtension(transport);
            ((AbstractConferenceEntity.Builder)object3).setTransport(((Transport.Builder)object).build());
            request.addRelay(((Colibri2Relay.Builder)relay).build());
            ConferenceModifyIQ conferenceModifyIQ = request.build();
            Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "build(...)");
            this.this$0.sendRequest(conferenceModifyIQ, "Relay.setTransport");
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            block0: {
                OrderedJsonObject $this$toJson_u24lambda_u247 = orderedJsonObject = new OrderedJsonObject();
                boolean bl = false;
                $this$toJson_u24lambda_u247.put("id", this.getRelayId());
                $this$toJson_u24lambda_u247.put("use_unique_port", (Object)this.useUniquePort);
                $this$toJson_u24lambda_u247.put("ice_controlling", (Object)this.iceControlling);
                $this$toJson_u24lambda_u247.put("dtls_setup", this.dtlsSetup);
                $this$toJson_u24lambda_u247.put("bridge_channel_active", (Object)this.bridgeChannelActive);
                $this$toJson_u24lambda_u247.put("sctp_bridge_channel", (Object)this.sctpBridgeChannel);
                String string = this.getMeshId();
                if (string == null) break block0;
                String it = string;
                boolean bl2 = false;
                $this$toJson_u24lambda_u247.put("mesh_id", it);
            }
            return orderedJsonObject;
        }

        public final void updateParticipant(@NotNull ParticipantInfo participant, boolean create) {
            Colibri2Relay.Builder builder;
            Intrinsics.checkNotNullParameter(participant, "participant");
            ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this.this$0, false, 1, null);
            Colibri2Relay.Builder $this$updateParticipant_u24lambda_u248 = builder = Colibri2Relay.getBuilder();
            boolean bl = false;
            $this$updateParticipant_u24lambda_u248.setId(this.getRelayId());
            Colibri2Relay.Builder builder2 = builder;
            Intrinsics.checkNotNullExpressionValue(builder2, "apply(...)");
            Colibri2Relay.Builder relay = builder2;
            Endpoints.Builder builder3 = Endpoints.getBuilder();
            Intrinsics.checkNotNullExpressionValue(builder3, "getBuilder(...)");
            Endpoints.Builder endpoints = builder3;
            endpoints.addEndpoint(ExtensionsKt.toEndpoint(participant, create, false).build());
            relay.setEndpoints(endpoints.build());
            request.addRelay(relay.build());
            ConferenceModifyIQ conferenceModifyIQ = request.build();
            Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "build(...)");
            this.this$0.sendRequest(conferenceModifyIQ, "Relay.updateParticipant");
        }

        public final void expireParticipants(@NotNull List<ParticipantInfo> participants) {
            Object element$iv2;
            boolean bl;
            block5: {
                Intrinsics.checkNotNullParameter(participants, "participants");
                Iterable $this$all$iv = participants;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$all$iv) {
                        ParticipantInfo it = (ParticipantInfo)element$iv2;
                        boolean bl2 = false;
                        if (it.getVisitor()) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
            ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this.this$0, false, 1, null);
            Object $this$expireParticipants_u24lambda_u2410 = element$iv2 = Colibri2Relay.getBuilder();
            boolean bl3 = false;
            ((AbstractConferenceEntity.Builder)$this$expireParticipants_u24lambda_u2410).setId(this.getRelayId());
            Object object = element$iv2;
            Intrinsics.checkNotNullExpressionValue(object, "apply(...)");
            Object relay = object;
            Endpoints.Builder builder = Endpoints.getBuilder();
            Intrinsics.checkNotNullExpressionValue(builder, "getBuilder(...)");
            Endpoints.Builder endpoints = builder;
            Iterable $this$forEach$iv = participants;
            boolean $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                ParticipantInfo it = (ParticipantInfo)element$iv3;
                boolean bl4 = false;
                if (it.getVisitor()) continue;
                endpoints.addEndpoint(ExtensionsKt.toEndpoint(it, false, true).build());
            }
            ((Colibri2Relay.Builder)relay).setEndpoints(endpoints.build());
            request.addRelay(((Colibri2Relay.Builder)relay).build());
            ConferenceModifyIQ conferenceModifyIQ = request.build();
            Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "build(...)");
            this.this$0.sendRequest(conferenceModifyIQ, "Relay.expireParticipants");
        }

        /*
         * WARNING - void declaration
         */
        private final ConferenceModifyIQ buildCreateRelayRequest(Collection<ParticipantInfo> participants) {
            void $this$buildCreateRelayRequest_u24lambda_u2422;
            void $this$forEach$iv;
            Iterator $this$filterTo$iv$iv;
            void $this$buildCreateRelayRequest_u24lambda_u2419;
            AbstractPacketExtension it;
            Object element$iv2;
            Media.Builder $this$buildCreateRelayRequest_u24lambda_u2416;
            ConferenceModifyIQ.Builder request = Colibri2Session.createRequest$default(this.this$0, false, 1, null);
            Object object = Colibri2Relay.getBuilder();
            Colibri2Relay.Builder $this$buildCreateRelayRequest_u24lambda_u2413 = object;
            boolean bl = false;
            $this$buildCreateRelayRequest_u24lambda_u2413.setId(this.getRelayId());
            String string = this.getMeshId();
            if (string != null) {
                String it2 = string;
                boolean bl2 = false;
                $this$buildCreateRelayRequest_u24lambda_u2413.setMeshId(it2);
            }
            $this$buildCreateRelayRequest_u24lambda_u2413.setCreate(true);
            Colibri2Relay.Builder builder = object;
            Intrinsics.checkNotNullExpressionValue(builder, "apply(...)");
            Colibri2Relay.Builder relay = builder;
            Media.Builder builder2 = Media.getBuilder();
            object = builder2;
            Colibri2Relay.Builder builder3 = relay;
            boolean bl3 = false;
            $this$buildCreateRelayRequest_u24lambda_u2416.setType(MediaType.AUDIO);
            Iterable $this$forEach$iv2 = CodecUtil.Companion.createAudioPayloadTypeExtensions$default(CodecUtil.Companion, null, 1, null);
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (PayloadTypePacketExtension)element$iv2;
                boolean bl4 = false;
                $this$buildCreateRelayRequest_u24lambda_u2416.addPayloadType((PayloadTypePacketExtension)it);
            }
            $this$forEach$iv2 = CodecUtil.Companion.createAudioRtpHdrExtExtensions$default(CodecUtil.Companion, null, 1, null);
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (RTPHdrExtPacketExtension)element$iv2;
                boolean bl5 = false;
                $this$buildCreateRelayRequest_u24lambda_u2416.addRtpHdrExt((RTPHdrExtPacketExtension)it);
            }
            if (Config.config.getExtmapAllowMixed()) {
                $this$buildCreateRelayRequest_u24lambda_u2416.setExtmapAllowMixed(new ExtmapAllowMixedPacketExtension());
            }
            builder3.addMedia(builder2.build());
            $this$buildCreateRelayRequest_u24lambda_u2416 = builder2 = Media.getBuilder();
            builder3 = relay;
            boolean bl6 = false;
            $this$buildCreateRelayRequest_u24lambda_u2419.setType(MediaType.VIDEO);
            $this$forEach$iv2 = CodecUtil.Companion.createVideoPayloadTypeExtensions$default(CodecUtil.Companion, null, 1, null);
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (PayloadTypePacketExtension)element$iv2;
                boolean bl7 = false;
                $this$buildCreateRelayRequest_u24lambda_u2419.addPayloadType((PayloadTypePacketExtension)it);
            }
            $this$forEach$iv2 = CodecUtil.Companion.createVideoRtpHdrExtExtensions$default(CodecUtil.Companion, null, 1, null);
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (RTPHdrExtPacketExtension)element$iv2;
                boolean bl8 = false;
                $this$buildCreateRelayRequest_u24lambda_u2419.addRtpHdrExt((RTPHdrExtPacketExtension)it);
            }
            if (Config.config.getExtmapAllowMixed()) {
                $this$buildCreateRelayRequest_u24lambda_u2419.setExtmapAllowMixed(new ExtmapAllowMixedPacketExtension());
            }
            builder3.addMedia(builder2.build());
            Endpoints.Builder builder4 = Endpoints.getBuilder();
            Intrinsics.checkNotNullExpressionValue(builder4, "getBuilder(...)");
            Endpoints.Builder endpoints = builder4;
            Iterable $this$filter$iv = participants;
            boolean $i$f$filter = false;
            $this$forEach$iv2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            element$iv2 = $this$filterTo$iv$iv.iterator();
            while (element$iv2.hasNext()) {
                Object element$iv$iv = element$iv2.next();
                ParticipantInfo it3 = (ParticipantInfo)element$iv$iv;
                boolean bl9 = false;
                if (!(!it3.getVisitor())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach22 = false;
            for (Object element$iv3 : $this$forEach$iv) {
                ParticipantInfo it4 = (ParticipantInfo)element$iv3;
                boolean bl10 = false;
                endpoints.addEndpoint(ExtensionsKt.toEndpoint(it4, true, false).build());
            }
            relay.setEndpoints(endpoints.build());
            Object $i$f$forEach22 = object = Transport.getBuilder();
            builder3 = relay;
            boolean bl11 = false;
            $this$buildCreateRelayRequest_u24lambda_u2422.setUseUniquePort(this.useUniquePort);
            $this$buildCreateRelayRequest_u24lambda_u2422.setIceControlling(this.iceControlling);
            if (this.sctpBridgeChannel) {
                Sctp.Builder sctp = new Sctp.Builder();
                sctp.setRole(this.bridgeChannelActive ? Sctp.Role.CLIENT : Sctp.Role.SERVER);
                $this$buildCreateRelayRequest_u24lambda_u2422.setSctp(sctp.build());
            }
            builder3.setTransport(((Transport.Builder)object).build());
            request.addRelay(relay.build());
            ConferenceModifyIQ conferenceModifyIQ = request.build();
            Intrinsics.checkNotNullExpressionValue(conferenceModifyIQ, "build(...)");
            return conferenceModifyIQ;
        }

        private static final String start$lambda$1(ConferenceModifyIQ $request) {
            Intrinsics.checkNotNullParameter($request, "$request");
            return "Sending create relay: " + XmlStringBuilderUtil.Companion.toStringOpt($request);
        }

        public static final /* synthetic */ Logger access$getLogger$p(Relay $this) {
            return $this.logger;
        }
    }
}

