/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.ContainerEntryGettable;
import org.jd.gui.api.feature.PageChangeListener;
import org.jd.gui.api.feature.PageChangeable;
import org.jd.gui.api.feature.PageClosable;
import org.jd.gui.api.feature.PageCreator;
import org.jd.gui.api.feature.PreferencesChangeListener;
import org.jd.gui.api.feature.TreeNodeExpandable;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.feature.UriOpenable;
import org.jd.gui.api.model.TreeNodeData;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.view.component.Tree;
import org.jd.gui.view.component.panel.TabbedPanel;
import org.jd.gui.view.renderer.TreeNodeRenderer;

public class TreeTabbedPanel<T extends DefaultMutableTreeNode & UriGettable>
extends JPanel
implements UriGettable,
UriOpenable,
PageChangeable,
PageClosable,
PreferencesChangeListener {
    protected API api;
    protected URI uri;
    protected Tree tree;
    protected TabbedPanel tabbedPanel;
    protected ArrayList<PageChangeListener> pageChangedListeners = new ArrayList();
    protected boolean updateTreeMenuEnabled = true;
    protected boolean openUriEnabled = true;
    protected boolean treeNodeChangedEnabled = true;

    public TreeTabbedPanel(final API api, URI uri) {
        this.api = api;
        this.uri = uri;
        this.tree = new Tree();
        this.tree.setShowsRootHandles(true);
        this.tree.setMinimumSize(new Dimension(150, 10));
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setCellRenderer(new TreeNodeRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, true);
            }
        });
        this.tree.addTreeSelectionListener(e -> this.treeNodeChanged((DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()));
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                TreeNode node = (TreeNode)e.getPath().getLastPathComponent();
                if (node instanceof TreeNodeExpandable) {
                    TreeNodeExpandable tne = (TreeNodeExpandable)((Object)node);
                    int oldHashCode = TreeTabbedPanel.createHashCode(node.children());
                    tne.populateTreeNode(api);
                    int newHashCode = TreeTabbedPanel.createHashCode(node.children());
                    if (oldHashCode != newHashCode) {
                        ((DefaultTreeModel)TreeTabbedPanel.this.tree.getModel()).reload(node);
                    }
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                if (SwingUtilities.isRightMouseButton(e) && (path = TreeTabbedPanel.this.tree.getPathForLocation(e.getX(), e.getY())) != null) {
                    TreeTabbedPanel.this.tree.setSelectionPath(path);
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    Collection<Action> actions = api.getContextualActions(((ContainerEntryGettable)((Object)node)).getEntry(), ((UriGettable)((Object)node)).getUri().getFragment());
                    if (actions != null) {
                        JPopupMenu popup = new JPopupMenu();
                        for (Action action : actions) {
                            if (action != null) {
                                popup.add(action);
                                continue;
                            }
                            popup.addSeparator();
                        }
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
        this.tabbedPanel = new TabbedPanel(api);
        this.tabbedPanel.setMinimumSize(new Dimension(150, 10));
        this.tabbedPanel.tabbedPane.addChangeListener(e -> this.pageChanged());
        this.setLayout(new BorderLayout());
        JSplitPane splitter = new JSplitPane(1, new JScrollPane(this.tree), this.tabbedPanel);
        splitter.setResizeWeight(0.2);
        this.add((Component)splitter, "Center");
    }

    protected static int createHashCode(Enumeration enumeration) {
        int hashCode = 1;
        while (enumeration.hasMoreElements()) {
            hashCode *= 31;
            Object element = enumeration.nextElement();
            if (element == null) continue;
            hashCode += element.hashCode();
        }
        return hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void treeNodeChanged(T node) {
        if (this.treeNodeChangedEnabled && node != null) {
            try {
                this.updateTreeMenuEnabled = false;
                URI uri = ((UriGettable)node).getUri();
                if (uri.getFragment() == null && uri.getQuery() == null) {
                    this.showPage(uri, uri, (DefaultMutableTreeNode)node);
                } else {
                    Object baseNode;
                    URI baseUri = new URI(uri.getScheme(), uri.getHost(), uri.getPath(), null);
                    for (baseNode = node; baseNode != null && !((UriGettable)baseNode).getUri().equals(baseUri); baseNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)baseNode).getParent()) {
                    }
                    if (baseNode != null && ((UriGettable)baseNode).getUri().equals(baseUri)) {
                        this.showPage(uri, baseUri, (DefaultMutableTreeNode)baseNode);
                    }
                }
            }
            catch (URISyntaxException e) {
                assert (ExceptionUtil.printStackTrace(e));
            }
            finally {
                this.updateTreeMenuEnabled = true;
            }
        }
    }

    protected <P extends JComponent> boolean showPage(URI uri, URI baseUri, DefaultMutableTreeNode baseNode) {
        Object page = this.tabbedPanel.showPage(baseUri);
        if (page == null && baseNode instanceof PageCreator) {
            page = ((PageCreator)((Object)baseNode)).createPage(this.api);
            ((JComponent)page).putClientProperty("node", baseNode);
            String path = baseUri.getPath();
            String label = path.substring(path.lastIndexOf(47) + 1);
            Object data = baseNode.getUserObject();
            if (data instanceof TreeNodeData) {
                TreeNodeData tnd = (TreeNodeData)data;
                this.tabbedPanel.addPage(label, tnd.getIcon(), tnd.getTip(), page);
            } else {
                this.tabbedPanel.addPage(label, null, null, page);
            }
        }
        if (this.openUriEnabled && page instanceof UriOpenable) {
            ((UriOpenable)page).openUri(uri);
        }
        return page != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <P extends JComponent> void pageChanged() {
        try {
            this.openUriEnabled = false;
            JComponent page = (JComponent)this.tabbedPanel.tabbedPane.getSelectedComponent();
            if (this.updateTreeMenuEnabled) {
                if (page != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)page.getClientProperty("node");
                    TreePath treePath = new TreePath(node.getPath());
                    this.tree.setSelectionPath(treePath);
                    this.tree.scrollPathToVisible(treePath);
                } else {
                    this.tree.clearSelection();
                }
            }
            for (PageChangeListener listener : this.pageChangedListeners) {
                listener.pageChanged(page);
            }
        }
        finally {
            this.openUriEnabled = true;
        }
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean openUri(URI uri) {
        block8: {
            try {
                DefaultMutableTreeNode childNode;
                URI baseUri = new URI(uri.getScheme(), uri.getHost(), uri.getPath(), null);
                if (this.uri.equals(baseUri)) {
                    return true;
                }
                DefaultMutableTreeNode node = this.searchTreeNode(baseUri, (DefaultMutableTreeNode)this.tree.getModel().getRoot());
                if (this.showPage(uri, baseUri, node) && (childNode = this.searchTreeNode(uri, node)) != null) {
                    node = childNode;
                }
                if (node == null) break block8;
                try {
                    this.treeNodeChangedEnabled = false;
                    if (!(node instanceof PageCreator) && node instanceof TreeNodeExpandable) {
                        ((TreeNodeExpandable)((Object)node)).populateTreeNode(this.api);
                        this.tree.expandPath(new TreePath(node.getPath()));
                    }
                    TreePath treePath = new TreePath(node.getPath());
                    this.tree.setSelectionPath(treePath);
                    this.tree.scrollPathToVisible(treePath);
                }
                finally {
                    this.treeNodeChangedEnabled = true;
                }
                return true;
            }
            catch (URISyntaxException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block8;
                throw new AssertionError();
            }
        }
        return false;
    }

    protected DefaultMutableTreeNode searchTreeNode(URI uri, DefaultMutableTreeNode node) {
        if (node instanceof TreeNodeExpandable) {
            ((TreeNodeExpandable)((Object)node)).populateTreeNode(this.api);
        }
        String u = uri.toString();
        DefaultMutableTreeNode child = null;
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode element = (DefaultMutableTreeNode)enumeration.nextElement();
            String childU = ((UriGettable)((Object)element)).getUri().toString();
            if (u.length() > childU.length()) {
                char c;
                if (!u.startsWith(childU) || (c = u.charAt(childU.length())) != '/' && c != '!') continue;
                child = element;
                break;
            }
            if (!u.equals(childU)) continue;
            child = element;
            break;
        }
        if (child != null) {
            if (u.equals(((UriGettable)((Object)child)).getUri().toString())) {
                return child;
            }
            return this.searchTreeNode(uri, child);
        }
        return null;
    }

    @Override
    public void addPageChangeListener(PageChangeListener listener) {
        this.pageChangedListeners.add(listener);
    }

    @Override
    public boolean closePage() {
        Component component = this.tabbedPanel.tabbedPane.getSelectedComponent();
        if (component != null) {
            this.tabbedPanel.removeComponent(component);
            return true;
        }
        return false;
    }

    @Override
    public void preferencesChanged(Map<String, String> preferences) {
        this.tabbedPanel.preferencesChanged(preferences);
    }
}

