/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops.handlers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.IndexedGetIterationHandler;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00020\b*\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/CharSequenceIterationHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/IndexedGetIterationHandler;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "canCacheLast", "", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Z)V", "getFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getGetFunction", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "sizePropertyGetter", "getSizePropertyGetter", "matchIterable", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "matchIteratorCall", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "ir.backend.common"})
public class CharSequenceIterationHandler
extends IndexedGetIterationHandler {
    public CharSequenceIterationHandler(@NotNull CommonBackendContext context, boolean canCacheLast) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, canCacheLast);
    }

    public /* synthetic */ CharSequenceIterationHandler(CommonBackendContext commonBackendContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(commonBackendContext, bl);
    }

    public boolean matchIterable(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return IrTypeUtilsKt.isSubtypeOfClass(expression2.getType(), this.getContext().getIr().getSymbols().getCharSequence());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matchIteratorCall(@NotNull IrCall call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        IrSimpleFunction callee = (IrSimpleFunction)call2.getSymbol().getOwner();
        if (!callee.getValueParameters().isEmpty()) return false;
        IrValueParameter irValueParameter = callee.getExtensionReceiverParameter();
        IrAnnotationContainer irAnnotationContainer = irValueParameter;
        if (irValueParameter == null) return false;
        IrType irType = irAnnotationContainer.getType();
        irAnnotationContainer = irType;
        if (irType == null) return false;
        if (!IrTypePredicatesKt.isCharSequence((IrType)irAnnotationContainer)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getKotlinFqName(callee), (Object)new FqName("kotlin.text." + OperatorNameConventions.ITERATOR))) return false;
        return true;
    }

    @Override
    @NotNull
    public IrSimpleFunction getSizePropertyGetter(@NotNull IrType $this$sizePropertyGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$sizePropertyGetter, (String)"<this>");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getPropertyGetter(this.getContext().getIr().getSymbols().getCharSequence(), "length");
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
        return (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
    }

    @Override
    @NotNull
    public IrSimpleFunction getGetFunction(@NotNull IrType $this$getFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$getFunction, (String)"<this>");
        IrClassSymbol irClassSymbol = this.getContext().getIr().getSymbols().getCharSequence();
        String string2 = OperatorNameConventions.GET.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GET.asString()");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getSimpleFunction(irClassSymbol, string2);
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
        return (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
    }
}

