/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.vcslinks;

import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.vcslinks.ChangeSet;
import com.almworks.tracklink.vcslinks.CustomDiffContent;
import com.almworks.tracklink.vcslinks.RevisionComparator;
import com.almworks.tracklink.vcslinks.VcsFileRevisionWrapper;
import com.almworks.util.Log;
import com.almworks.util.Procedure;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.DefaultRepositoryLocation;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.checkin.DifferenceType;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.peer.PeerFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCSUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.almworks.tracklink.vcslinks.VCSUtil");
    public static final long MIN_DIFF = 60000L;
    public static final Key<Date> VCS_MODIFICATION_DATE = new Key("TrackLink.VcsModificationDate");
    public static final Key<DifferenceType> VCS_DIFFERENCE_TYPE = new Key("TrackLink.VcsDifferenceType");
    private static final String CVS_VCS_NAME = "cvs";

    @Nullable
    public static void getAllChangeSets(Project project, @Nullable Date dateAfter, @Nullable Date dateBefore, Procedure<ChangeSet> sink) {
        Log.debug("getAllChangeSets(project:" + project + ", after:" + dateAfter + ", before:" + dateBefore + ")");
        ChangeBrowserSettings settings = (ChangeBrowserSettings)project.getComponent(ChangeBrowserSettings.class);
        if (settings == null) {
            Log.warn("no ChangeBrowserSettings");
            return;
        }
        if (dateAfter != null && dateAfter.getTime() == 0L) {
            dateAfter = null;
        }
        settings.setDateAfter(dateAfter);
        boolean bl = settings.USE_DATE_AFTER_FILTER = dateAfter != null;
        if (dateBefore != null && dateBefore.getTime() == 0L) {
            dateBefore = null;
        }
        settings.setDateBefore(dateBefore);
        settings.USE_DATE_BEFORE_FILTER = dateBefore != null;
        settings.USE_USER_FILTER = false;
        settings.USE_CHANGE_AFTER_FILTER = false;
        settings.USE_CHANGE_BEFORE_FILTER = false;
        List<Pair<VirtualFile, AbstractVcs>> moduleRoots = VCSUtil.getModuleRoots(project);
        Log.debug("getModuleRoots() = #" + moduleRoots.size());
        for (Pair<VirtualFile, AbstractVcs> pair : moduleRoots) {
            Log.debug("querying for " + pair);
            if (pair == null) continue;
            VirtualFile contentRoot = (VirtualFile)pair.getFirst();
            AbstractVcs vcs = (AbstractVcs)pair.getSecond();
            DefaultRepositoryLocation repositoryLocation = new DefaultRepositoryLocation(project.getBaseDir().getPresentableUrl());
            if (contentRoot == null || vcs == null) {
                Log.warn("Bad pair (Module content root, AbstractVCS): " + pair);
                continue;
            }
            LOG.debug("Loading history from: " + vcs.getDisplayName() + " root: " + contentRoot);
            CommittedChangesProvider committedChangesProvider = vcs.getCommittedChangesProvider();
            if (committedChangesProvider == null) {
                Log.warn("versions provider == null for " + contentRoot);
                continue;
            }
            try {
                List changeLists = committedChangesProvider.getCommittedChanges(settings, (RepositoryLocation)repositoryLocation, 0);
                Log.debug("getFilteredVersions() = #" + changeLists.size());
                for (CommittedChangeList repositoryVersion : changeLists) {
                    sink.process(new ChangeSet(contentRoot, vcs, repositoryVersion));
                }
            }
            catch (VcsException e) {
                Log.debug("getFilteredVersions() got an exception, ignoring: " + (Object)((Object)e));
            }
        }
    }

    public static List<VcsFileRevision> getRevisionsFromVcsHistory(VirtualFile file, Project project) throws VcsException {
        ArrayList<VcsFileRevision> result = new ArrayList<VcsFileRevision>();
        FilePath filePath = PeerFactory.getInstance().getVcsContextFactory().createFilePathOn(file);
        AbstractVcs vcsFor = VCSUtil.getVcsFor(project, file);
        VcsHistoryProvider historyProvider = vcsFor.getVcsBlockHistoryProvider();
        if (historyProvider == null) {
            historyProvider = vcsFor.getVcsHistoryProvider();
        }
        VcsHistorySession session = historyProvider.createSessionFor(filePath);
        List revisionList = session.getRevisionList();
        Collections.sort(revisionList, new RevisionComparator());
        for (VcsFileRevision aRevisionList : revisionList) {
            result.add(new VcsFileRevisionWrapper(file, project, aRevisionList));
        }
        return result;
    }

    public static void showDiffDialog(VcsFileRevision v1, VcsFileRevision v2, Project project, VirtualFile file) throws VcsException, IOException {
        v1.loadContent();
        v2.loadContent();
        DiffManager diff = DiffManager.getInstance();
        DiffTool ideaDiffTool = diff.getIdeaDiffTool();
        SimpleDiffRequest request = new SimpleDiffRequest(project, file.getPath());
        request.setContents((DiffContent)new CustomDiffContent(file, v1), (DiffContent)new CustomDiffContent(file, v2));
        request.setContentTitles(v1.getRevisionNumber().asString(), v2.getRevisionNumber().asString());
        ideaDiffTool.show((DiffRequest)request);
    }

    public static void showRevision(Project project, VirtualFile file, VcsFileRevision revision) {
        VcsVirtualFile vcsVirtualFile = new VcsVirtualFile(file.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance());
        new OpenFileDescriptor(project, (VirtualFile)vcsVirtualFile).navigate(true);
    }

    private static AbstractVcs getVcsFor(Project project, VirtualFile file) {
        AbstractVcs vcs = null;
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        if (file instanceof MockVirtualFile) {
            vcs = ((MockVirtualFile)file).getVcs();
        } else {
            try {
                vcs = projectLevelVcsManager.getVcsFor(file);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return vcs;
    }

    private static List<Pair<VirtualFile, AbstractVcs>> getModuleRoots(Project project) {
        VirtualFile[] roots;
        ArrayList<Pair<VirtualFile, AbstractVcs>> result = new ArrayList<Pair<VirtualFile, AbstractVcs>>();
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        for (VirtualFile root : roots = vcsManager.getAllVersionedRoots()) {
            AbstractVcs vcs = vcsManager.getVcsFor(root);
            if (vcs == null) continue;
            result.add((Pair<VirtualFile, AbstractVcs>)Pair.create((Object)root, (Object)vcs));
        }
        return result;
    }

    @Nullable
    public static VirtualFile getVirtualFileByIOFile(Project project, File file, @Nullable VirtualFile moduleRoot, @Nullable AbstractVcs vcs, Date date) {
        String newPath;
        boolean perforceHack;
        String path = file.getPath();
        if (path == null) {
            path = "/";
        }
        boolean bl = perforceHack = path.startsWith("\\\\") || path.startsWith("//");
        if (Comparing.strEqual((String)path, (String)file.getAbsolutePath()) && !perforceHack) {
            newPath = file.getAbsolutePath();
        } else if (moduleRoot != null) {
            int attic;
            int e;
            String sought;
            int f;
            String nmp = VCSUtil.normalizePath(moduleRoot.getPath());
            String nrp = VCSUtil.normalizePath(path);
            int nrpLen = nrp.length();
            int copyFrom = -1;
            int k = nmp.length();
            while (!(k <= 0 || (f = nrp.indexOf(sought = nmp.substring(Math.max(0, (k = nmp.lastIndexOf(47, k - 1)) + 1)))) < 0 || f > 0 && nrp.charAt(f - 1) != '/' || (e = f + sought.length()) < nrpLen && nrp.charAt(e) != '/')) {
                copyFrom = e;
            }
            if (copyFrom < 0) {
                Log.debug("cannot guess VirtualFile from repository path [" + moduleRoot.getPath() + ", " + path + "]");
                return null;
            }
            newPath = nmp + nrp.substring(copyFrom);
            if (vcs != null && CVS_VCS_NAME.equalsIgnoreCase(vcs.getName()) && (attic = newPath.lastIndexOf("/Attic/")) >= 0 && newPath.indexOf(47, attic + 7) < 0) {
                newPath = newPath.substring(0, attic + 1) + newPath.substring(attic + 7);
            }
            if (File.separatorChar != '/') {
                newPath = newPath.replace('/', File.separatorChar);
            }
            Log.debug("mapped " + path + " to " + newPath);
        } else {
            VirtualFile baseDir = project.getBaseDir();
            if (baseDir == null) {
                newPath = path;
            } else {
                String projectFilePath = baseDir.getPath();
                String filePath = path;
                int pos = VCSUtil.firstSeparatorIndex(filePath);
                filePath = pos > -1 ? filePath.substring(pos) : File.separator + filePath;
                newPath = projectFilePath + filePath;
            }
        }
        VirtualFile result = LocalFileSystem.getInstance().findFileByIoFile(new File(newPath));
        if (result == null) {
            result = VCSUtil.createMockVirtualFile(project, newPath, date);
        }
        if (result != null && result.isDirectory()) {
            return null;
        }
        if (result == null) {
            Log.debug("cannot find VirtualFile " + newPath);
        }
        return result;
    }

    @Nullable
    public static VirtualFile createMockVirtualFile(Project project, String path, Date date) {
        Pair<VirtualFile, AbstractVcs> pair = VCSUtil.getAppropriateModuleRoot(project, path);
        if (pair != null) {
            Log.debug("creating mock VirtualFile " + path);
            return new MockVirtualFile(project, path, (VirtualFileSystem)LocalFileSystem.getInstance(), (AbstractVcs)pair.getSecond(), date);
        }
        Log.debug("file is under no content root: " + path);
        return null;
    }

    private static String normalizePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/vcslinks/VCSUtil.normalizePath must not be null");
        }
        if (path.length() == 0) {
            return path;
        }
        String result = path.replaceAll("[\\\\\\/]+", "/");
        int length = result.length();
        if (length > 0 && result.charAt(length - 1) == '/') {
            result = result.substring(0, length - 1);
        }
        return result;
    }

    private static int firstSeparatorIndex(String path) {
        int f = path.indexOf(47);
        int b = path.indexOf(92);
        return f < 0 || b < 0 ? Math.max(f, b) : Math.min(f, b);
    }

    private static int lastSeparatorIndex(String path) {
        return Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
    }

    private static Pair<VirtualFile, AbstractVcs> getAppropriateModuleRoot(Project project, String filePath) {
        List<Pair<VirtualFile, AbstractVcs>> roots = VCSUtil.getModuleRoots(project);
        TreeMap<File, Pair<VirtualFile, AbstractVcs>> ioRoots = new TreeMap<File, Pair<VirtualFile, AbstractVcs>>();
        for (Pair<VirtualFile, AbstractVcs> pair : roots) {
            ioRoots.put(new File(((VirtualFile)pair.getFirst()).getPath()), pair);
        }
        File f = new File(filePath);
        do {
            Pair pair;
            if ((pair = (Pair)ioRoots.get(f)) == null) continue;
            return pair;
        } while ((f = f.getParentFile()) != null);
        return null;
    }

    @Nullable
    public static Pair<VcsFileRevision, VcsFileRevision> getAppropriateRevisionPair(Project project, VirtualFile file, Date date, long minAllowedDiff) {
        long minDiff = minAllowedDiff;
        List<VcsFileRevision> revisionList = null;
        try {
            revisionList = VCSUtil.getRevisionsFromVcsHistory(file, project);
        }
        catch (VcsException e) {
            return null;
        }
        VcsFileRevision candidate = null;
        VcsFileRevision candidatePrev = null;
        VcsFileRevision prevRevision = null;
        for (VcsFileRevision currentRevision : revisionList) {
            long currentDiff = Math.abs(currentRevision.getRevisionDate().getTime() - date.getTime());
            if (currentDiff < minDiff) {
                minDiff = currentDiff;
                candidate = currentRevision;
                candidatePrev = prevRevision;
            }
            prevRevision = currentRevision;
        }
        if (minDiff > minAllowedDiff || candidate == null) {
            return null;
        }
        return Pair.create(candidatePrev, candidate);
    }

    public static class MockVirtualFile
    extends AbstractVcsVirtualFile {
        private final Project myProject;
        private AbstractVcs myVcs;
        private Date myDate;

        public MockVirtualFile(Project project, String path, VirtualFileSystem fileSystem, AbstractVcs vcsFor, Date date) {
            super(path, fileSystem);
            this.myProject = project;
            this.myVcs = vcsFor;
            this.myDate = date;
        }

        public byte[] contentsToByteArray() throws IOException {
            Pair<VcsFileRevision, VcsFileRevision> revisionPair = VCSUtil.getAppropriateRevisionPair(this.myProject, (VirtualFile)this, this.myDate, 60000L);
            if (revisionPair != null) {
                return ((VcsFileRevision)revisionPair.getSecond()).getContent();
            }
            throw new IOException(StringBundle.get("errors.vcs.cannot.get.content", new Object[0]));
        }

        public boolean isDirectory() {
            return false;
        }

        public AbstractVcs getVcs() {
            return this.myVcs;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof VirtualFile && Comparing.strEqual((String)this.getUrl(), (String)((VirtualFile)obj).getUrl());
        }

        public int hashCode() {
            return this.getUrl().hashCode();
        }

        public String toString() {
            return this.getPath() + "{VCS: " + this.myVcs + "; Date: " + this.myDate + "}";
        }
    }
}

