/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.util.Properties;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class PropertiesConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type2) {
        return Properties.class.isAssignableFrom(type2);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type2, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator, type2);
        if (value != null) {
            return value;
        }
        try {
            Properties properties = this.instantiateProperties(configuration, type2, loader);
            int i = 0;
            int size = configuration.getChildCount();
            while (i < size) {
                PlexusConfiguration element2 = configuration.getChild(i);
                if ("property".equals(element2.getName()) && element2.getChildCount() > 0) {
                    Object name2 = this.fromExpression(element2.getChild("name"), evaluator);
                    this.setProperty(properties, name2, element2.getChild("value"), evaluator);
                } else if (element2.getChildCount() == 0) {
                    this.setProperty(properties, element2.getName(), element2, evaluator);
                }
                ++i;
            }
            return properties;
        }
        catch (ComponentConfigurationException e2) {
            if (e2.getFailedConfiguration() == null) {
                e2.setFailedConfiguration(configuration);
            }
            throw e2;
        }
    }

    private Properties instantiateProperties(PlexusConfiguration configuration, Class<?> type2, ClassLoader loader) throws ComponentConfigurationException {
        Class<?> implType = this.getClassForImplementationHint(type2, configuration, loader);
        if (implType == null || Modifier.isAbstract(implType.getModifiers())) {
            return new Properties();
        }
        Object impl2 = this.instantiateObject(implType);
        this.failIfNotTypeCompatible(impl2, type2, configuration);
        return (Properties)impl2;
    }

    private void setProperty(Properties properties, Object name2, PlexusConfiguration valueConfiguration, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        String key2;
        String string2 = key2 = name2 != null ? name2.toString() : null;
        if (key2 == null) {
            throw new ComponentConfigurationException("Missing name in properties");
        }
        Object value = this.fromExpression(valueConfiguration, evaluator);
        properties.setProperty(key2, value != null ? value.toString() : "");
    }
}

