/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;

public final class logcount
extends Primitive {
    private static final Primitive LOGCOUNT = new logcount();

    private logcount() {
        super("logcount", "integer");
    }

    @Override
    public LispObject execute(LispObject arg) {
        int n;
        if (arg instanceof Fixnum) {
            int value = ((Fixnum)arg).value;
            n = Integer.bitCount(value < 0 ? ~value : value);
        } else if (arg instanceof Bignum) {
            n = ((Bignum)arg).value.bitCount();
        } else {
            return Lisp.type_error(arg, Symbol.INTEGER);
        }
        return Fixnum.getInstance(n);
    }
}

