'''OpenGL extension AMD.multi_draw_indirect

This module customises the behaviour of the 
OpenGL.raw.GL.AMD.multi_draw_indirect to provide a more 
Python-friendly API

Overview (from the spec)
	
	The ARB_draw_indirect extension (included in OpenGL 4.0) introduced
	mechanisms whereby the parameters for a draw function may be provided in
	a structure contained in a buffer object rather than as parameters to the
	drawing procedure. This is known as an indirect draw and is exposed as two
	new functions, glDrawArraysIndirect and glDrawElementsIndirect. Each of
	these functions generates a single batch of primitives.
	
	This extension builds on this functionality by providing procedures to
	invoke multiple draws from a single procedure call. This allows large
	batches of drawing commands to be assembled in server memory (via a buffer
	object) which may then be dispatched through a single function call.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/AMD/multi_draw_indirect.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.AMD.multi_draw_indirect import *
from OpenGL.raw.GL.AMD.multi_draw_indirect import _EXTENSION_NAME

def glInitMultiDrawIndirectAMD():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION