"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggregateMetrics = aggregateMetrics;
exports.createNullableGetterSetter = createNullableGetterSetter;
exports.extractFieldsFromMappings = extractFieldsFromMappings;
exports.setSecurityAnalyticsPluginConfig = exports.getSecurityAnalyticsPluginConfig = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _constants = require("../server/utils/constants");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function aggregateMetrics(metrics, currentMetricsCounter) {
  const partialMetrics = {
    ...currentMetricsCounter
  };
  Object.keys(metrics).forEach(w => {
    const workflow = w;
    const workFlowMetrics = metrics[workflow];
    if (workFlowMetrics) {
      const counterToUpdate = partialMetrics[workflow] || _lodash.default.cloneDeep(_constants.DEFAULT_METRICS_COUNTER[workflow]);
      Object.entries(workFlowMetrics).forEach(([metric, count]) => {
        if (!counterToUpdate[metric]) {
          counterToUpdate[metric] = 0;
        }
        counterToUpdate[metric] += count;
      });
      partialMetrics[workflow] = counterToUpdate;
    }
  });
  return partialMetrics;
}
let securityAnalyticsPluginConfig;
const setSecurityAnalyticsPluginConfig = config => {
  securityAnalyticsPluginConfig = config;
};
exports.setSecurityAnalyticsPluginConfig = setSecurityAnalyticsPluginConfig;
const getSecurityAnalyticsPluginConfig = () => securityAnalyticsPluginConfig;
exports.getSecurityAnalyticsPluginConfig = getSecurityAnalyticsPluginConfig;
function extractFieldsFromMappings(properties, fields, parentField = '') {
  Object.keys(properties).forEach(field => {
    if (properties[field].hasOwnProperty('properties')) {
      extractFieldsFromMappings(properties[field]['properties'], fields, parentField ? `${parentField}.${field}` : field);
    } else {
      fields.push(parentField ? `${parentField}.${field}` : field);
    }
  });
}
function createNullableGetterSetter() {
  let value;
  const get = () => {
    return value;
  };
  const set = newValue => {
    value = newValue;
  };
  return [get, set];
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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