"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "RootFinder", {
  enumerable: true,
  get: function get() {
    return _RootFinder["default"];
  }
});
exports.assertDomAvailable = assertDomAvailable;
exports.compareNodeTypeOf = compareNodeTypeOf;
Object.defineProperty(exports, "createMountWrapper", {
  enumerable: true,
  get: function get() {
    return _createMountWrapper["default"];
  }
});
Object.defineProperty(exports, "createRenderWrapper", {
  enumerable: true,
  get: function get() {
    return _createRenderWrapper["default"];
  }
});
exports.displayNameOfNode = displayNameOfNode;
exports.elementToTree = elementToTree;
exports.ensureKeyOrUndefined = ensureKeyOrUndefined;
exports.fakeDynamicImport = fakeDynamicImport;
exports.findElement = findElement;
exports.flatten = flatten;
exports.getComponentStack = getComponentStack;
exports.getMaskedContext = getMaskedContext;
exports.getNodeFromRootFinder = getNodeFromRootFinder;
exports.getWrappingComponentMountRenderer = getWrappingComponentMountRenderer;
exports.isArrayLike = isArrayLike;
exports.mapNativeEventNames = mapNativeEventNames;
exports.nodeTypeFromType = nodeTypeFromType;
exports.propFromEvent = propFromEvent;
exports.propsWithKeysAndRef = propsWithKeysAndRef;
exports.simulateError = simulateError;
exports.spyMethod = spyMethod;
exports.spyProperty = spyProperty;
exports.withSetStateAllowed = withSetStateAllowed;
Object.defineProperty(exports, "wrap", {
  enumerable: true,
  get: function get() {
    return _wrapWithSimpleWrapper["default"];
  }
});
exports.wrapWithWrappingComponent = wrapWithWrappingComponent;
var _functionPrototype = _interopRequireDefault(require("function.prototype.name"));
var _object = _interopRequireDefault(require("object.fromentries"));
var _hasown = _interopRequireDefault(require("hasown"));
var _createMountWrapper = _interopRequireDefault(require("./createMountWrapper"));
var _createRenderWrapper = _interopRequireDefault(require("./createRenderWrapper"));
var _wrapWithSimpleWrapper = _interopRequireDefault(require("./wrapWithSimpleWrapper"));
var _RootFinder = _interopRequireDefault(require("./RootFinder"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : String(i); }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function mapNativeEventNames(event) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    _ref$animation = _ref.animation,
    animation = _ref$animation === void 0 ? false : _ref$animation,
    _ref$pointerEvents = _ref.pointerEvents,
    pointerEvents = _ref$pointerEvents === void 0 ? false : _ref$pointerEvents,
    _ref$auxClick = _ref.auxClick,
    auxClick = _ref$auxClick === void 0 ? false : _ref$auxClick;
  var nativeToReactEventMap = _objectSpread(_objectSpread(_objectSpread({
    compositionend: 'compositionEnd',
    compositionstart: 'compositionStart',
    compositionupdate: 'compositionUpdate',
    keydown: 'keyDown',
    keyup: 'keyUp',
    keypress: 'keyPress',
    contextmenu: 'contextMenu',
    dblclick: 'doubleClick',
    doubleclick: 'doubleClick',
    // kept for legacy. TODO: remove with next major.
    dragend: 'dragEnd',
    dragenter: 'dragEnter',
    dragexist: 'dragExit',
    dragleave: 'dragLeave',
    dragover: 'dragOver',
    dragstart: 'dragStart',
    mousedown: 'mouseDown',
    mousemove: 'mouseMove',
    mouseout: 'mouseOut',
    mouseover: 'mouseOver',
    mouseup: 'mouseUp',
    touchcancel: 'touchCancel',
    touchend: 'touchEnd',
    touchmove: 'touchMove',
    touchstart: 'touchStart',
    canplay: 'canPlay',
    canplaythrough: 'canPlayThrough',
    durationchange: 'durationChange',
    loadeddata: 'loadedData',
    loadedmetadata: 'loadedMetadata',
    loadstart: 'loadStart',
    ratechange: 'rateChange',
    timeupdate: 'timeUpdate',
    volumechange: 'volumeChange',
    beforeinput: 'beforeInput',
    mouseenter: 'mouseEnter',
    mouseleave: 'mouseLeave',
    transitionend: 'transitionEnd'
  }, animation && {
    animationstart: 'animationStart',
    animationiteration: 'animationIteration',
    animationend: 'animationEnd'
  }), pointerEvents && {
    pointerdown: 'pointerDown',
    pointermove: 'pointerMove',
    pointerup: 'pointerUp',
    pointercancel: 'pointerCancel',
    gotpointercapture: 'gotPointerCapture',
    lostpointercapture: 'lostPointerCapture',
    pointerenter: 'pointerEnter',
    pointerleave: 'pointerLeave',
    pointerover: 'pointerOver',
    pointerout: 'pointerOut'
  }), auxClick && {
    auxclick: 'auxClick'
  });
  return nativeToReactEventMap[event] || event;
}

// 'click' => 'onClick'
// 'mouseEnter' => 'onMouseEnter'
function propFromEvent(event) {
  var eventOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var nativeEvent = mapNativeEventNames(event, eventOptions);
  return "on".concat(nativeEvent[0].toUpperCase()).concat(nativeEvent.slice(1));
}
function withSetStateAllowed(fn) {
  // NOTE(lmr):
  // this is currently here to circumvent a React bug where `setState()` is
  // not allowed without global being defined.
  var cleanup = false;
  if (typeof global.document === 'undefined') {
    cleanup = true;
    global.document = {};
  }
  var result = fn();
  if (cleanup) {
    // This works around a bug in node/jest in that developers aren't able to
    // delete things from global when running in a node vm.
    global.document = undefined;
    delete global.document;
  }
  return result;
}
function assertDomAvailable(feature) {
  if (!global || !global.document || !global.document.createElement) {
    throw new Error("Enzyme's ".concat(feature, " expects a DOM environment to be loaded, but found none"));
  }
}
function displayNameOfNode(node) {
  if (!node) return null;
  var type = node.type;
  if (!type) return null;
  return type.displayName || (typeof type === 'function' ? (0, _functionPrototype["default"])(type) : type.name || type);
}
function nodeTypeFromType(type) {
  if (typeof type === 'string') {
    return 'host';
  }
  if (type && type.prototype && type.prototype.isReactComponent) {
    return 'class';
  }
  return 'function';
}
function getIteratorFn(obj) {
  var iteratorFn = obj && (typeof Symbol === 'function' && _typeof(Symbol.iterator) === 'symbol' && obj[Symbol.iterator] || obj['@@iterator']);
  if (typeof iteratorFn === 'function') {
    return iteratorFn;
  }
  return undefined;
}
function isIterable(obj) {
  return !!getIteratorFn(obj);
}
function isArrayLike(obj) {
  return Array.isArray(obj) || typeof obj !== 'string' && isIterable(obj);
}
function flatten(arrs) {
  // optimize for the most common case
  if (Array.isArray(arrs)) {
    return arrs.reduce(function (flatArrs, item) {
      return flatArrs.concat(isArrayLike(item) ? flatten(item) : item);
    }, []);
  }

  // fallback for arbitrary iterable children
  var flatArrs = [];
  var iteratorFn = getIteratorFn(arrs);
  var iterator = iteratorFn.call(arrs);
  var step = iterator.next();
  while (!step.done) {
    var item = step.value;
    var flatItem = void 0;
    if (isArrayLike(item)) {
      flatItem = flatten(item);
    } else {
      flatItem = item;
    }
    flatArrs = flatArrs.concat(flatItem);
    step = iterator.next();
  }
  return flatArrs;
}
function ensureKeyOrUndefined(key) {
  return key || (key === '' ? '' : undefined);
}
function elementToTree(el) {
  var recurse = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : elementToTree;
  if (typeof recurse !== 'function' && arguments.length === 3) {
    // special case for backwards compat for `.map(elementToTree)`
    recurse = elementToTree; // eslint-disable-line no-param-reassign
  }
  if (el === null || _typeof(el) !== 'object' || !('type' in el)) {
    return el;
  }
  var type = el.type,
    props = el.props,
    key = el.key,
    ref = el.ref;
  var children = props.children;
  var rendered = null;
  if (isArrayLike(children)) {
    rendered = flatten(children).map(function (x) {
      return recurse(x);
    });
  } else if (typeof children !== 'undefined') {
    rendered = recurse(children);
  }
  var nodeType = nodeTypeFromType(type);
  if (nodeType === 'host' && props.dangerouslySetInnerHTML) {
    if (props.children != null) {
      var error = new Error('Can only set one of `children` or `props.dangerouslySetInnerHTML`.');
      error.name = 'Invariant Violation';
      throw error;
    }
  }
  return {
    nodeType: nodeType,
    type: type,
    props: props,
    key: ensureKeyOrUndefined(key),
    ref: ref,
    instance: null,
    rendered: rendered
  };
}
function mapFind(arraylike, mapper, finder) {
  var found;
  var isFound = Array.prototype.find.call(arraylike, function (item) {
    found = mapper(item);
    return finder(found);
  });
  return isFound ? found : undefined;
}
function findElement(el, predicate) {
  if (el === null || _typeof(el) !== 'object' || !('type' in el)) {
    return undefined;
  }
  if (predicate(el)) {
    return el;
  }
  var rendered = el.rendered;
  if (isArrayLike(rendered)) {
    return mapFind(rendered, function (x) {
      return findElement(x, predicate);
    }, function (x) {
      return typeof x !== 'undefined';
    });
  }
  return findElement(rendered, predicate);
}
function propsWithKeysAndRef(node) {
  if (node.ref !== null || node.key !== null) {
    return _objectSpread(_objectSpread({}, node.props), {}, {
      key: node.key,
      ref: node.ref
    });
  }
  return node.props;
}
function getComponentStack(hierarchy) {
  var getNodeType = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : nodeTypeFromType;
  var getDisplayName = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : displayNameOfNode;
  var tuples = hierarchy.filter(function (node) {
    return node.type !== _RootFinder["default"];
  }).map(function (x) {
    return [getNodeType(x.type), getDisplayName(x)];
  }).concat([['class', 'WrapperComponent']]);
  return tuples.map(function (_ref2, i, arr) {
    var _ref3 = _slicedToArray(_ref2, 2),
      name = _ref3[1];
    var _ref4 = arr.slice(i + 1).find(function (_ref6) {
        var _ref7 = _slicedToArray(_ref6, 1),
          nodeType = _ref7[0];
        return nodeType !== 'host';
      }) || [],
      _ref5 = _slicedToArray(_ref4, 2),
      closestComponent = _ref5[1];
    return "\n    in ".concat(name).concat(closestComponent ? " (created by ".concat(closestComponent, ")") : '');
  }).join('');
}
function simulateError(error, catchingInstance, rootNode,
// TODO: remove `rootNode` next semver-major
hierarchy) {
  var getNodeType = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : nodeTypeFromType;
  var getDisplayName = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : displayNameOfNode;
  var catchingType = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : {};
  var instance = catchingInstance || {};
  var componentDidCatch = instance.componentDidCatch;
  var getDerivedStateFromError = catchingType.getDerivedStateFromError;
  if (!componentDidCatch && !getDerivedStateFromError) {
    throw error;
  }
  if (getDerivedStateFromError) {
    var stateUpdate = getDerivedStateFromError.call(catchingType, error);
    instance.setState(stateUpdate);
  }
  if (componentDidCatch) {
    var componentStack = getComponentStack(hierarchy, getNodeType, getDisplayName);
    componentDidCatch.call(instance, error, {
      componentStack: componentStack
    });
  }
}
function getMaskedContext(contextTypes, unmaskedContext) {
  if (!contextTypes || !unmaskedContext) {
    return {};
  }
  return (0, _object["default"])(Object.keys(contextTypes).map(function (key) {
    return [key, unmaskedContext[key]];
  }));
}
function getNodeFromRootFinder(isCustomComponent, tree, options) {
  if (!isCustomComponent(options.wrappingComponent)) {
    return tree.rendered;
  }
  var rootFinder = findElement(tree, function (node) {
    return node.type === _RootFinder["default"];
  });
  if (!rootFinder) {
    throw new Error('`wrappingComponent` must render its children!');
  }
  return rootFinder.rendered;
}
function wrapWithWrappingComponent(createElement, node, options) {
  var wrappingComponent = options.wrappingComponent,
    wrappingComponentProps = options.wrappingComponentProps;
  if (!wrappingComponent) {
    return node;
  }
  return createElement(wrappingComponent, wrappingComponentProps, createElement(_RootFinder["default"], null, node));
}
function getWrappingComponentMountRenderer(_ref8) {
  var toTree = _ref8.toTree,
    getMountWrapperInstance = _ref8.getMountWrapperInstance;
  return {
    getNode: function getNode() {
      var instance = getMountWrapperInstance();
      return instance ? toTree(instance).rendered : null;
    },
    render: function render(el, context, callback) {
      var instance = getMountWrapperInstance();
      if (!instance) {
        throw new Error('The wrapping component may not be updated if the root is unmounted.');
      }
      return instance.setWrappingComponentProps(el.props, callback);
    }
  };
}
function fakeDynamicImport(moduleToImport) {
  return Promise.resolve({
    "default": moduleToImport
  });
}
function compareNodeTypeOf(node, matchingTypeOf) {
  if (!node) {
    return false;
  }
  return node.$$typeof === matchingTypeOf;
}

// TODO: when enzyme v3.12.0 is required, delete this
function spyMethod(instance, methodName) {
  var getStub = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : function () {};
  var lastReturnValue;
  var originalMethod = instance[methodName];
  var hasOwnProp = (0, _hasown["default"])(instance, methodName);
  var descriptor;
  if (hasOwnProp) {
    descriptor = Object.getOwnPropertyDescriptor(instance, methodName);
  }
  Object.defineProperty(instance, methodName, {
    configurable: true,
    enumerable: !descriptor || !!descriptor.enumerable,
    value: getStub(originalMethod) || function spied() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      var result = originalMethod.apply(this, args);
      lastReturnValue = result;
      return result;
    }
  });
  return {
    restore: function restore() {
      if (hasOwnProp) {
        if (descriptor) {
          Object.defineProperty(instance, methodName, descriptor);
        } else {
          /* eslint-disable no-param-reassign */
          instance[methodName] = originalMethod;
          /* eslint-enable no-param-reassign */
        }
      } else {
        /* eslint-disable no-param-reassign */
        delete instance[methodName];
        /* eslint-enable no-param-reassign */
      }
    },
    getLastReturnValue: function getLastReturnValue() {
      return lastReturnValue;
    }
  };
}

// TODO: when enzyme v3.12.0 is required, delete this
function spyProperty(instance, propertyName) {
  var handlers = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var originalValue = instance[propertyName];
  var hasOwnProp = (0, _hasown["default"])(instance, propertyName);
  var descriptor;
  if (hasOwnProp) {
    descriptor = Object.getOwnPropertyDescriptor(instance, propertyName);
  }
  var _wasAssigned = false;
  var holder = originalValue;
  var getV = handlers.get ? function () {
    var value = descriptor && descriptor.get ? descriptor.get.call(instance) : holder;
    return handlers.get.call(instance, value);
  } : function () {
    return holder;
  };
  var set = handlers.set ? function (newValue) {
    _wasAssigned = true;
    var handlerNewValue = handlers.set.call(instance, holder, newValue);
    holder = handlerNewValue;
    if (descriptor && descriptor.set) {
      descriptor.set.call(instance, holder);
    }
  } : function (v) {
    _wasAssigned = true;
    holder = v;
  };
  Object.defineProperty(instance, propertyName, {
    configurable: true,
    enumerable: !descriptor || !!descriptor.enumerable,
    get: getV,
    set: set
  });
  return {
    restore: function restore() {
      if (hasOwnProp) {
        if (descriptor) {
          Object.defineProperty(instance, propertyName, descriptor);
        } else {
          /* eslint-disable no-param-reassign */
          instance[propertyName] = holder;
          /* eslint-enable no-param-reassign */
        }
      } else {
        /* eslint-disable no-param-reassign */
        delete instance[propertyName];
        /* eslint-enable no-param-reassign */
      }
    },
    wasAssigned: function wasAssigned() {
      return _wasAssigned;
    }
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//# sourceMappingURL=Utils.js.map