/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.fontchooser;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jhotdraw.gui.fontchooser.AbstractFontChooserModel;
import org.jhotdraw.gui.fontchooser.FontCollectionNode;
import org.jhotdraw.gui.fontchooser.FontFaceNode;
import org.jhotdraw.gui.fontchooser.FontFamilyNode;
import org.jhotdraw.util.ResourceBundleUtil;

public class DefaultFontChooserModel
extends AbstractFontChooserModel {
    protected DefaultMutableTreeNode root = new DefaultMutableTreeNode();

    public DefaultFontChooserModel() {
    }

    public DefaultFontChooserModel(Font[] fontArray) {
        this.setFonts(fontArray);
    }

    public void setFonts(Font[] fontArray) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.gui.Labels");
        ArrayList<FontFamilyNode> arrayList = new ArrayList<FontFamilyNode>();
        HashMap<String, FontFamilyNode> hashMap = new HashMap<String, FontFamilyNode>();
        for (Font font : fontArray) {
            Object object;
            String object3 = font.getFamily();
            if (hashMap.containsKey(object3)) {
                object = (FontFamilyNode)hashMap.get(object3);
            } else {
                object = new FontFamilyNode(object3);
                hashMap.put(object3, (FontFamilyNode)object);
            }
            ((FontFamilyNode)object).add(new FontFaceNode(font));
        }
        arrayList.addAll(hashMap.values());
        Collections.sort(arrayList);
        this.root.removeAllChildren();
        this.root.add(new FontCollectionNode(resourceBundleUtil.getString("FontCollection.allFonts"), (ArrayList)arrayList.clone()));
        this.root.add(new FontCollectionNode(resourceBundleUtil.getString("FontCollection.web"), this.collectFamiliesNamed(arrayList, "Arial", "Arial Black", "Comic Sans MS", "Georgia", "Impact", "Times New Roman", "Trebuchet MS", "Verdana", "Webdings")));
        this.root.add(new FontCollectionNode(resourceBundleUtil.getString("FontCollection.system"), this.collectFamiliesNamed(arrayList, "Dialog", "DialogInput", "Monospaced", "SansSerif", "Serif")));
        this.root.add(new FontCollectionNode(resourceBundleUtil.getString("FontCollection.serif"), this.collectFamiliesNamed(arrayList, "Adobe Caslon Pro", "Adobe Garamond Pro", "American Typewriter", "Arno Pro", "Baskerville", "Baskerville Old Face", "Bell MT", "Big Caslon", "Bodoni SvtyTwo ITC TT", "Bodoni SvtyTwo OS ITC TT", "Bodoni SvtyTwo SC ITC TT", "Book Antiqua", "Bookman Old Style", "Calisto MT", "Chaparral Pro", "Century", "Century Schoolbook", "Cochin", "Footlight MT Light", "Garamond", "Garamond Premier Pro", "Georgia", "Goudy Old Style", "Hoefler Text", "Lucida Bright", "Lucida Fax", "Minion Pro", "Palatino", "Times", "Times New Roman", "Palatino Linotype", "Bitstream Vera Serif Bold", "Bodoni MT", "Bodoni MT Black", "Bodoni MT Condensed", "Californian FB", "Cambria", "Cambria Math", "Centaur", "Constantia", "High Tower Text", "Perpetua", "Poor Richard", "Rockwell Condensed", "Slimbach-Black", "Slimbach-BlackItalic", "Slimbach-Bold", "Slimbach-BoldItalic", "Slimbach-Book", "Slimbach-BookItalic", "Slimbach-Medium", "Slimbach-MediumItalic", "Sylfaen", "Andalus", "Angsana New", "AngsanaUPC", "Arabic Typesetting", "Cambria", "Cambria Math", "Constantia", "DaunPenh", "David", "DilleniaUPC", "EucrosiaUPC", "Frank Ruehl", "IrisUPC", "Iskoola Pota", "JasmineUPC", "KodchiangUPC", "Narkisim")));
        this.root.add(new FontCollectionNode(resourceBundleUtil.getString("FontCollection.sansSerif"), this.collectFamiliesNamed(arrayList, "Abadi MT Condensed Extra Bold", "Abadi MT Condensed Light", "Al Bayan", "AppleGothic", "Arial", "Arial Black", "Arial Narrow", "Arial Rounded MT Bold", "Arial Unicode MS", "Bell Gothic Std", "Blair MdITC TT", "Century Gothic", "Frutiger", "Futura", "Geneva", "Gill Sans", "Gulim", "Helvetica", "Helvetica Neue", "Lucida Grande", "Lucida Sans", "Microsoft Sans Serif", "Myriad Pro", "News Gothic", "Tahoma", "Trebuchet MS", "Verdana", "Franklin Gothic Medium", "Lucida Sans Unicode", "Agency FB", "Berlin Sans FB", "Berlin Sans FB Demi Bold", "Bitstream Vera Sans Bold", "Calibri", "Candara", "Corbel", "Estrangelo Edessa", "Eras Bold ITC", "Eras Demi ITC", "Eras Light ITC", "Eras Medium ITC", "Franklin Gothic Book", "Franklin Gothic Demi", "Franklin Gothic Demi Cond", "Franklin Gothic Heavy", "Franklin Gothic Medium Cond", "Gill Sans MT", "Gill Sans MT Condensed", "Gill Sans MT Ext Condensed Bold", "Maiandra GD", "MS Reference Sans...", "Tw Cen MT", "Tw Cen MT Condensed", "Tw Cen MT Condensed Extra Bold", "Aharoni", "Browallia New", "BrowalliaUPC", "Calibri", "Candara", "Corbel", "Cordia New", "CordiaUPC", "DokChampa", "Dotum", "Estrangelo Edessa", "Euphemia", "Freesia UPC", "Gautami", "Gisha", "Kalinga", "Kartika", "Levenim MT", "LilyUPC", "Malgun Gothic", "Meiryo", "Miriam", "Segoe UI")));
        this.root.add(new FontCollectionNode(resourceBundleUtil.getString("FontCollection.script"), this.collectFamiliesNamed(arrayList, "Apple Chancery", "Bickham Script Pro", "Blackmoor LET", "Bradley Hand ITC TT", "Brush Script MT", "Brush Script Std", "Chalkboard", "Charlemagne Std", "Comic Sans MS", "Curlz MT", "Edwardian Script ITC", "Footlight MT Light", "Giddyup Std", "Handwriting - Dakota", "Harrington", "Herculanum", "Kokonor", "Lithos Pro", "Lucida Blackletter", "Lucida Calligraphy", "Lucida Handwriting", "Marker Felt", "Matura MT Script Capitals", "Mistral", "Monotype Corsiva", "Party LET", "Papyrus", "Santa Fe LET", "Savoye LET", "SchoolHouse Cursive B", "SchoolHouse Printed A", "Skia", "Snell Roundhand", "Tekton Pro", "Trajan Pro", "Zapfino", "Blackadder ITC", "Bradley Hand ITC", "Chiller", "Freestyle Script", "French Script MT", "Gigi", "Harlow Solid Italic", "Informal Roman", "Juice ITC", "Kristen ITC", "Kunstler Script", "Magneto Bold", "Maiandra GD", "Old English Text", "Palace Script MT", "Parchment", "Pristina", "Rage Italic", "Ravie", "Script MT Bold", "Tempus Sans ITC", "Viner Hand ITC", "Vivaldi Italic", "Vladimir Script", "Segoe Print", "Segoe Script")));
        this.root.add(new FontCollectionNode(resourceBundleUtil.getString("FontCollection.monospaced"), this.collectFamiliesNamed(arrayList, "Andale Mono", "Courier", "Courier New", "Letter Gothic Std", "Lucida Sans Typewriter", "Monaco", "OCR A Std", "Orator Std", "Prestige Elite Std", "Lucida Console", "Bitstream Vera S...", "Consolas", "OCR A Extended", "OCR B", "Consolas", "DotumChe", "Miriam Fixed", "Rod")));
        this.root.add(new FontCollectionNode(resourceBundleUtil.getString("FontCollection.decorative"), this.collectFamiliesNamed(arrayList, "Academy Engraved LET", "Arial Black", "Bank Gothic", "Bauhaus 93", "Bernard MT Condensed", "Birch Std", "Blackoak Std", "BlairMdITC TT", "Bordeaux Roman Bold LET", "Braggadocio", "Britannic Bold", "Capitals", "Colonna MT", "Cooper Black", "Cooper Std", "Copperplate", "Copperplate Gothic Bold", "Copperplate Gothic Light", "Cracked", "Desdemona", "Didot", "Eccentric Std", "Engravers MT", "Eurostile", "Gill Sans Ultra Bold", "Gloucester MT Extra Condensed", "Haettenschweiler", "Hobo Std", "Impact", "Imprint MT Shadow", "Jazz LET", "Kino MT", "Matura MT Script Capitals", "Mesquite Std", "Modern No. 20", "Mona Lisa Solid ITC TT", "MS Gothic", "Nueva Std", "Onyx", "Optima", "Perpetua Titling MT", "Playbill", "Poplar Std", "PortagoITC TT", "Princetown LET", "Rockwell", "Rockwell Extra Bold", "Rosewood Std", "Santa Fe LET", "Stencil", "Stencil Std", "Stone Sans ITC TT", "Stone Sans OS ITC TT", "Stone Sans Sem ITC TT", "Stone Sans Sem OS ITCTT", "Stone Sans Sem OS ITC TT", "Synchro LET", "Wide Latin", "Algerian", "Bodoni MT Black", "Bodoni MT Poster Compressed", "Broadway", "Castellar", "Elephant", "Felix Titling", "Franklin Gothic Heavy", "Gill Sans MT Ext Condensed Bold", "Gill Sans Ultra Bold Condensed", "Goudy Stout", "Jokerman", "Juice ITC", "Magneto", "Magneto Bold", "Niagara Engraved", "Niagara Solid", "Poor Richard", "Ravie", "Rockwell Condensed", "Showcard Gothic", "Slimbach-Black", "Slimbach-BlackItalic", "Snap ITC")));
        this.root.add(new FontCollectionNode(resourceBundleUtil.getString("FontCollection.symbols"), this.collectFamiliesNamed(arrayList, "Apple Symbols", "Blackoack Std", "Bodoni Ornaments ITC TT", "EuropeanPi", "Monotype Sorts", "MT Extra", "Symbol", "Type Embellishments One LET", "Webdings", "Wingdings", "Wingdings 2", "Wingdings 3", "Zapf Dingbats", "Bookshelf Symbol")));
        FontCollectionNode fontCollectionNode = new FontCollectionNode(resourceBundleUtil.getString("FontCollection.other"));
        HashSet<FontFamilyNode> hashSet = new HashSet<FontFamilyNode>();
        hashSet.addAll(arrayList);
        int n = this.root.getChildCount();
        for (int i = 1; i < n; ++i) {
            FontCollectionNode fontCollectionNode2 = (FontCollectionNode)this.root.getChildAt(i);
            for (FontFamilyNode fontFamilyNode : fontCollectionNode2.families()) {
                hashSet.remove(fontFamilyNode);
            }
        }
        ArrayList<FontFamilyNode> arrayList2 = new ArrayList<FontFamilyNode>();
        for (FontFamilyNode fontFamilyNode : hashSet) {
            arrayList2.add(fontFamilyNode.clone());
        }
        Collections.sort(arrayList2);
        fontCollectionNode.addAll(arrayList2);
        this.root.add(fontCollectionNode);
        this.fireTreeStructureChanged(this, new TreePath(this.root));
    }

    protected ArrayList<FontFamilyNode> collectFamiliesNamed(ArrayList<FontFamilyNode> arrayList, String ... stringArray) {
        ArrayList<FontFamilyNode> arrayList2 = new ArrayList<FontFamilyNode>();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        for (FontFamilyNode fontFamilyNode : arrayList) {
            String string = fontFamilyNode.getName();
            if (!hashSet.contains(fontFamilyNode.getName())) continue;
            arrayList2.add(fontFamilyNode.clone());
        }
        return arrayList2;
    }

    @Override
    public boolean isEditable(MutableTreeNode mutableTreeNode) {
        boolean bl = true;
        if (mutableTreeNode instanceof FontFaceNode) {
            bl &= ((FontFaceNode)mutableTreeNode).isEditable();
            mutableTreeNode = (MutableTreeNode)mutableTreeNode.getParent();
        }
        if (bl && mutableTreeNode instanceof FontFamilyNode) {
            bl &= ((FontFamilyNode)mutableTreeNode).isEditable();
            mutableTreeNode = (MutableTreeNode)mutableTreeNode.getParent();
        }
        if (bl && mutableTreeNode instanceof FontCollectionNode) {
            bl &= ((FontFamilyNode)mutableTreeNode).isEditable();
        }
        return bl;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object object, int n) {
        return ((TreeNode)object).getChildAt(n);
    }

    @Override
    public int getChildCount(Object object) {
        return ((TreeNode)object).getChildCount();
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((TreeNode)object).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return ((TreeNode)object).getIndex((TreeNode)object2);
    }

    public static class UIResource
    extends DefaultFontChooserModel
    implements javax.swing.plaf.UIResource {
    }
}

