//: version "2.1"
//: property prefix = "_GG"
//: property title = "Welcome to TkGate Page"

//: /netlistBegin main
module main;    //: root_module
wire w6;    //: /sn:0 {0}(616,227)(607,227){1}
wire [7:0] w7;    //: /sn:0 {0}(447,45)(447,52){1}
wire [7:0] w16;    //: /sn:0 {0}(842,540)(842,562)(683,562){1}
//: {2}(681,560)(681,541){3}
//: {4}(679,562)(446,562)(446,351){5}
//: {6}(446,347)(446,261){7}
//: {8}(448,259)(519,259){9}
//: {10}(446,257)(446,174){11}
//: {12}(444,349)(335,349){13}
wire w19;    //: /sn:0 {0}(496,136)(486,136){1}
wire [7:0] w15;    //: /sn:0 {0}(202,348)(213,348){1}
wire w4;    //: /sn:0 {0}(612,195)(607,195){1}
wire w0;    //: /sn:0 {0}(493,93)(486,93){1}
wire w3;    //: /sn:0 {0}(297,301)(297,309){1}
wire w1;    //: /sn:0 {0}(621,243)(607,243){1}
wire w8;    //: /sn:0 {0}(842,399)(842,407){1}
wire w18;    //: /sn:0 {0}(646,400)(646,408){1}
wire w17;    //: /sn:0 {0}(617,259)(607,259){1}
wire w11;    //: /sn:0 {0}(807,402)(807,407){1}
wire w12;    //: /sn:0 {0}(611,401)(611,408){1}
wire w2;    //: /sn:0 {0}(612,211)(607,211){1}
wire w10;    //: /sn:0 {0}(681,408)(681,398){1}
wire w13;    //: /sn:0 {0}(772,402)(772,407){1}
wire w5;    //: /sn:0 {0}(254,301)(254,309){1}
//: enddecls

  UREGISTER MAR (.CLK(w3), .WRITE(w5), .BUS(w16), .OUT(w15));   //: @(214, 310) /sz:(120, 64) /p:[ Ti0>1 Ti1>1 Ri0>13 Lo0<1 ]
  //: joint g4 (w16) @(446, 259) /w:[ 8 10 -1 7 ]
  //: joint g3 (w16) @(681, 562) /w:[ 1 2 4 -1 ]
  REGISTER regB (.WRITE(w13), .OUT(w11), .CLK(w8), .BUS(w16));   //: @(737, 408) /sz:(140, 131) /p:[ Ti0>1 Ti1>1 Ti2>1 Bt0=0 ]
  UREGISTER IR (.BUS(w16), .CLK(w19), .WRITE(w0), .OUT(w7));   //: @(421, 53) /sz:(64, 120) /p:[ Bi0>11 Ri0>1 Ri1>1 To0<1 ]
  //: joint g1 (w16) @(446, 349) /w:[ -1 6 12 5 ]
  REGISTER regA (.WRITE(w12), .OUT(w18), .CLK(w10), .BUS(w16));   //: @(576, 409) /sz:(140, 131) /p:[ Ti0>1 Ti1>1 Ti2>0 Bt0=3 ]
  PC g0 (.CLK(w17), .LOAD(w1), .OE(w6), .PLUS(w2), .RST(w4), .BUS(w16));   //: @(520, 179) /sz:(86, 96) /sn:0 /p:[ Ri0>1 Ri1>1 Ri2>1 Ri3>1 Ri4>1 Lt0=9 ]

endmodule
//: /netlistEnd

//: /netlistBegin PC
module PC(PLUS, RST, LOAD, BUS, CLK, OE);
//: interface  /sz:(86, 96) /bd:[ Li0>CLK(16/96) Li1>LOAD(32/96) Li2>OE(48/96) Li3>PLUS(64/96) Li4>RST(80/96) Rt0=BUS[7:0](16/96) ]
//: property prot_intf=1
reg [7:0] w6;    //: /sn:0 /dp:1 {0}(417,165)(470,165){1}
input LOAD;    //: /sn:0 {0}(271,832)(271,767){1}
//: {2}(273,765)(286,765)(286,749){3}
//: {4}(271,763)(271,694){5}
inout [7:0] BUS;    //: /sn:0 {0}(578,362)(605,362){1}
//: {2}(609,362)(725,362){3}
//: {4}(607,364)(607,553)(212,553)(212,417)(246,417){5}
supply0 w0;    //: /sn:0 /dp:1 {0}(403,205)(403,254){1}
supply0 w3;    //: /sn:0 {0}(416,338)(416,373){1}
input OE;    //: /sn:0 {0}(570,282)(570,357){1}
input RST;    //: /sn:0 {0}(296,749)(296,779)(232,779){1}
//: {2}(230,777)(230,694){3}
//: {4}(230,781)(230,807){5}
input CLK;    //: /sn:0 {0}(411,509)(411,449){1}
supply1 w11;    //: /sn:0 {0}(406,311)(406,373){1}
supply0 [7:0] w9;    //: /sn:0 {0}(196,393)(246,393){1}
input PLUS;    //: /sn:0 {0}(250,819)(250,775){1}
//: {2}(252,773)(291,773)(291,749){3}
//: {4}(250,771)(250,694){5}
wire [7:0] w7;    //: /sn:0 /dp:1 {0}(421,411)(480,411)(480,364){1}
//: {2}(482,362)(530,362){3}
//: {4}(534,362)(562,362){5}
//: {6}(532,364)(532,539)(236,539)(236,429)(246,429){7}
//: {8}(480,360)(480,197)(417,197){9}
wire w19;    //: /sn:0 {0}(267,510)(267,567){1}
wire w20;    //: /sn:0 {0}(257,510)(257,567){1}
wire [7:0] w8;    //: /sn:0 {0}(388,181)(167,181)(167,405)(246,405){1}
wire w18;    //: /sn:0 {0}(291,728)(291,694){1}
wire [1:0] w12;    //: /sn:0 /dp:1 {0}(262,434)(262,504){1}
wire w10;    //: /sn:0 {0}(403,157)(403,142){1}
wire [7:0] w13;    //: /sn:0 {0}(275,411)(400,411){1}
//: enddecls

  //: GROUND g4 (w0) @(403,260) /sn:0 /w:[ 1 ]
  //: comment g8 @(351,602) /sn:0
  //: /line:"00 reset"
  //: /line:"01 increment"
  //: /line:"10 load"
  //: /line:"11 hold (by default)"
  //: /end
  _GGADD8 #(68, 70, 62, 64) g3 (.A(w6), .B(w7), .S(w8), .CI(w0), .CO(w10));   //: @(401,181) /sn:0 /R:3 /w:[ 0 9 0 0 0 ]
  //: IN g13 (PLUS) @(250,821) /sn:0 /R:1 /w:[ 0 ]
  //: GROUND g2 (w9) @(190,393) /sn:0 /R:3 /w:[ 0 ]
  _GGMUX4x8 #(12, 12) g1 (.I0(w9), .I1(w8), .I2(BUS), .I3(w7), .S(w12), .Z(w13));   //: @(262,411) /sn:0 /R:1 /w:[ 1 1 5 7 0 0 ] /ss:0 /do:1
  //: IN g11 (RST) @(230,809) /sn:0 /R:1 /w:[ 5 ]
  //: joint g16 (PLUS) @(250, 773) /w:[ 2 4 -1 1 ]
  assign w12 = {w20, w19}; //: CONCAT g10  @(262,505) /sn:0 /R:1 /w:[ 1 0 0 ] /dr:0 /tp:0 /drp:1
  _GGBUFIF8 #(4, 6) g19 (.Z(BUS), .I(w7), .E(OE));   //: @(568,362) /sn:0 /w:[ 0 5 1 ]
  //: VDD g6 (w11) @(417,311) /sn:0 /w:[ 0 ]
  //: GROUND g7 (w3) @(416,332) /sn:0 /R:2 /w:[ 0 ]
  FourTwoEncoder g9 (.A(RST), .B(PLUS), .C(LOAD), .D(w18), .X(w20), .Y(w19));   //: @(210, 569) /sz:(102, 125) /sn:0 /p:[ Bi0>3 Bi1>5 Bi2>5 Bi3>1 To0<1 To1<1 ]
  //: joint g15 (LOAD) @(271, 765) /w:[ 2 4 -1 1 ]
  //: joint g20 (w7) @(480, 362) /w:[ 2 8 -1 1 ]
  //: joint g17 (RST) @(230, 779) /w:[ 1 2 -1 4 ]
  //: DIP g5 (w6) @(508,165) /sn:0 /R:3 /w:[ 1 ] /st:1
  //: IN g14 (LOAD) @(271,834) /sn:0 /R:1 /w:[ 0 ]
  //: INOUT g24 (BUS) @(733,362) /sn:0 /R:2 /w:[ 3 ]
  //: joint g21 (w7) @(532, 362) /w:[ 4 -1 3 6 ]
  //: IN g23 (CLK) @(411,511) /sn:0 /R:1 /w:[ 0 ]
  _GGREG8 #(10, 10, 20) g0 (.Q(w7), .D(w13), .EN(w3), .CLR(w11), .CK(CLK));   //: @(411,411) /sn:0 /R:1 /w:[ 0 1 1 1 1 ]
  //: IN g22 (OE) @(570,280) /sn:0 /R:3 /w:[ 0 ]
  _GGNOR3 #(6) g12 (.I0(LOAD), .I1(PLUS), .I2(RST), .Z(w18));   //: @(291,738) /sn:0 /R:1 /w:[ 3 3 0 0 ]
  //: joint g18 (BUS) @(607, 362) /w:[ 2 -1 1 4 ]

endmodule
//: /netlistEnd

//: /netlistBegin REGISTER
module REGISTER(CLK, OUT, BUS, WRITE);
//: interface  /sz:(131, 140) /bd:[ Li0>CLK(35/140) Li1>OUT(70/140) Li2>WRITE(105/140) Rt0=BUS[7:0](35/140) ]
//: property prot_intf=1
inout [7:0] BUS;    //: /sn:0 {0}(681,302)(590,302){1}
//: {2}(586,302)(577,302){3}
//: {4}(588,304)(588,422)(260,422)(260,312)(321,312){5}
supply0 w3;    //: /sn:0 {0}(462,213)(462,264){1}
supply1 w1;    //: /sn:0 {0}(452,192)(452,264){1}
input WRITE;    //: /sn:0 {0}(337,325)(337,369){1}
input CLK;    //: /sn:0 {0}(457,340)(457,370){1}
input OUT;    //: /sn:0 {0}(569,210)(569,297){1}
wire [7:0] w0;    //: /sn:0 {0}(467,302)(490,302){1}
//: {2}(494,302)(561,302){3}
//: {4}(492,300)(492,142)(263,142)(263,292)(321,292){5}
wire [7:0] w8;    //: /sn:0 {0}(350,302)(446,302){1}
//: enddecls

  //: joint g4 (w0) @(492, 302) /anc:1 /w:[ 2 4 1 -1 ]
  //: joint g8 (BUS) @(588, 302) /anc:1 /w:[ 1 -1 2 4 ]
  _GGBUFIF8 #(4, 6) g3 (.Z(BUS), .I(w0), .E(OUT));   //: @(567,302) /sn:0 /anc:1 /w:[ 3 3 1 ]
  //: IN g2 (CLK) @(457,372) /sn:0 /R:1 /anc:1 /w:[ 1 ]
  _GGMUX2x8 #(8, 8) g1 (.I0(w0), .I1(BUS), .S(WRITE), .Z(w8));   //: @(337,302) /sn:0 /R:1 /anc:1 /w:[ 5 5 0 0 ] /ss:0 /do:1
  //: GROUND g10 (w3) @(462,207) /sn:0 /R:2 /anc:1 /w:[ 0 ]
  //: IN g6 (OUT) @(569,208) /sn:0 /R:3 /anc:1 /w:[ 0 ]
  //: INOUT g7 (BUS) @(689,302) /sn:0 /R:2 /anc:1 /w:[ 0 ]
  //: VDD g9 (w1) @(463,192) /sn:0 /anc:1 /w:[ 0 ]
  //: IN g5 (WRITE) @(337,371) /sn:0 /R:1 /anc:1 /w:[ 1 ]
  _GGREG8 #(10, 10, 20) g0 (.Q(w0), .D(w8), .EN(w3), .CLR(w1), .CK(CLK));   //: @(457,302) /sn:0 /R:1 /anc:1 /w:[ 0 1 1 1 0 ]

endmodule
//: /netlistEnd

//: /netlistBegin UREGISTER
module UREGISTER(OUT, WRITE, BUS, CLK);
//: interface  /sz:(120, 64) /bd:[ Li0>BUS[7:0](25/64) Bi0>WRITE(80/120) Bi1>CLK(37/120) Ro0<OUT[7:0](26/64) ]
//: property prot_intf=1
input [7:0] BUS;    //: /sn:0 {0}(236,188)(327,188){1}
supply1 w0;    //: /sn:0 {0}(445,74)(445,160){1}
supply0 w1;    //: /sn:0 {0}(455,111)(455,160){1}
input WRITE;    //: /sn:0 /dp:1 {0}(343,221)(343,275){1}
input CLK;    //: /sn:0 /dp:1 {0}(450,236)(450,295){1}
output [7:0] OUT;    //: /sn:0 /dp:3 {0}(327,208)(277,208)(277,358)(481,358)(481,200){1}
//: {2}(483,198)(581,198){3}
//: {4}(479,198)(460,198){5}
wire [7:0] w8;    //: /sn:0 {0}(356,198)(439,198){1}
//: enddecls

  //: GROUND g8 (w1) @(455,105) /sn:0 /R:2 /w:[ 0 ]
  //: OUT g4 (OUT) @(578,198) /sn:0 /w:[ 3 ]
  //: IN g3 (WRITE) @(343,277) /sn:0 /R:1 /w:[ 1 ]
  _GGMUX2x8 #(8, 8) g2 (.I0(OUT), .I1(BUS), .S(WRITE), .Z(w8));   //: @(343,198) /sn:0 /R:1 /w:[ 0 1 0 0 ] /ss:0 /do:0
  //: IN g1 (BUS) @(234,188) /sn:0 /w:[ 0 ]
  //: IN g6 (CLK) @(450,297) /sn:0 /R:1 /w:[ 1 ]
  //: VDD g7 (w0) @(456,74) /sn:0 /w:[ 0 ]
  //: joint g5 (OUT) @(481, 198) /w:[ 2 -1 4 1 ]
  _GGREG8 #(10, 10, 20) g0 (.Q(OUT), .D(w8), .EN(w1), .CLR(w0), .CK(CLK));   //: @(450,198) /sn:0 /R:1 /w:[ 5 1 1 1 0 ]

endmodule
//: /netlistEnd

//: /netlistBegin FourTwoEncoder
module FourTwoEncoder(A, Y, D, C, B, X);
//: interface  /sz:(125, 80) /bd:[ Li0>A(16/80) Li1>B(32/80) Li2>C(48/80) Li3>D(64/80) Ro0<X(31/80) Ro1<Y(54/80) ]
output X;    //: /sn:0 {0}(530,223)(450,223){1}
input B;    //: /sn:0 {0}(226,165)(226,206){1}
//: {2}(228,208)(300,208){3}
//: {4}(226,210)(226,237){5}
//: {6}(228,239)(300,239){7}
//: {8}(226,241)(226,290){9}
//: {10}(228,292)(301,292){11}
//: {12}(226,294)(226,325)(300,325){13}
input A;    //: /sn:0 {0}(251,168)(251,201){1}
//: {2}(253,203)(300,203){3}
//: {4}(251,205)(251,232){5}
//: {6}(253,234)(300,234){7}
//: {8}(251,236)(251,285){9}
//: {10}(253,287)(301,287){11}
//: {12}(251,289)(251,320)(300,320){13}
input C;    //: /sn:0 {0}(300,213)(205,213){1}
//: {2}(203,211)(203,164){3}
//: {4}(203,215)(203,242){5}
//: {6}(205,244)(300,244){7}
//: {8}(203,246)(203,295){9}
//: {10}(205,297)(301,297){11}
//: {12}(203,299)(203,330)(300,330){13}
input D;    //: /sn:0 {0}(300,335)(184,335)(184,304){1}
//: {2}(186,302)(301,302){3}
//: {4}(184,300)(184,251){5}
//: {6}(186,249)(300,249){7}
//: {8}(184,247)(184,220){9}
//: {10}(186,218)(300,218){11}
//: {12}(184,216)(184,168){13}
output Y;    //: /sn:0 {0}(532,310)(451,310){1}
wire w16;    //: /sn:0 {0}(322,294)(414,294)(414,308)(430,308){1}
wire w21;    //: /sn:0 {0}(321,327)(414,327)(414,313)(430,313){1}
wire w2;    //: /sn:0 {0}(321,210)(414,210)(414,221)(429,221){1}
wire w9;    //: /sn:0 {0}(321,241)(414,241)(414,226)(429,226){1}
//: enddecls

  _GGAND4 #(10) g4 (.I0(!A), .I1(!B), .I2(C), .I3(!D), .Z(w2));   //: @(311,210) /sn:0 /anc:1 /w:[ 3 3 0 11 0 ]
  //: IN g8 (A) @(251,166) /sn:0 /R:3 /anc:1 /w:[ 0 ]
  _GGOR2 #(6) g3 (.I0(w2), .I1(w9), .Z(X));   //: @(440,223) /sn:0 /anc:1 /w:[ 1 1 1 ]
  //: joint g13 (A) @(251, 234) /anc:1 /w:[ 6 5 -1 8 ]
  _GGOR2 #(6) g2 (.I0(w16), .I1(w21), .Z(Y));   //: @(441,310) /sn:0 /anc:1 /w:[ 1 1 1 ]
  //: OUT g1 (Y) @(529,310) /sn:0 /anc:1 /w:[ 0 ]
  //: IN g11 (D) @(184,166) /sn:0 /R:3 /anc:1 /w:[ 13 ]
  //: joint g16 (B) @(226, 239) /anc:1 /w:[ 6 5 -1 8 ]
  //: IN g10 (C) @(203,162) /sn:0 /R:3 /anc:1 /w:[ 3 ]
  //: joint g19 (C) @(203, 244) /anc:1 /w:[ 6 5 -1 8 ]
  _GGAND4 #(10) g6 (.I0(!A), .I1(B), .I2(!C), .I3(!D), .Z(w16));   //: @(312,294) /sn:0 /anc:1 /w:[ 11 11 11 3 0 ]
  _GGAND4 #(10) g7 (.I0(!A), .I1(!B), .I2(!C), .I3(D), .Z(w21));   //: @(311,327) /sn:0 /anc:1 /w:[ 13 13 13 0 0 ]
  //: IN g9 (B) @(226,163) /sn:0 /R:3 /anc:1 /w:[ 0 ]
  //: joint g15 (B) @(226, 292) /anc:1 /w:[ 10 9 -1 12 ]
  //: joint g20 (C) @(203, 213) /anc:1 /w:[ 1 2 -1 4 ]
  //: joint g17 (B) @(226, 208) /anc:1 /w:[ 2 1 -1 4 ]
  _GGAND4 #(10) g5 (.I0(!A), .I1(!B), .I2(!C), .I3(D), .Z(w9));   //: @(311,241) /sn:0 /anc:1 /w:[ 7 7 7 7 0 ]
  //: joint g14 (A) @(251, 203) /anc:1 /w:[ 2 1 -1 4 ]
  //: joint g21 (D) @(184, 218) /anc:1 /w:[ 10 12 -1 9 ]
  //: joint g23 (D) @(184, 302) /anc:1 /w:[ 2 4 -1 1 ]
  //: OUT g0 (X) @(527,223) /sn:0 /anc:1 /w:[ 0 ]
  //: joint g22 (D) @(184, 249) /anc:1 /w:[ 6 8 -1 5 ]
  //: joint g12 (A) @(251, 287) /anc:1 /w:[ 10 9 -1 12 ]
  //: joint g18 (C) @(203, 297) /anc:1 /w:[ 10 9 -1 12 ]

endmodule
//: /netlistEnd
