/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTableContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableColumnsInfo;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableCell;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableRow;

public class RtfTable
extends RtfContainer {
    private RtfTableRow row;
    private int highestRow = 0;
    private Boolean isNestedTable = null;
    private RtfAttributes borderAttributes = null;
    private ITableColumnsInfo tableContext;
    private RtfAttributes headerAttribs = null;

    RtfTable(IRtfTableContainer parent, Writer w, ITableColumnsInfo tc) throws IOException {
        super((RtfContainer)((Object)parent), w);
        this.tableContext = tc;
    }

    RtfTable(IRtfTableContainer parent, Writer w, RtfAttributes attrs, ITableColumnsInfo tc) throws IOException {
        super((RtfContainer)((Object)parent), w, attrs);
        this.tableContext = tc;
    }

    public RtfTableRow newTableRow() throws IOException {
        if (this.row != null) {
            this.row.close();
        }
        ++this.highestRow;
        this.row = new RtfTableRow(this, this.writer, this.attrib, this.highestRow);
        return this.row;
    }

    public RtfTableRow newTableRow(RtfAttributes attrs) throws IOException {
        RtfAttributes attr = null;
        if (this.attrib != null) {
            attr = (RtfAttributes)this.attrib.clone();
            attr.set(attrs);
        } else {
            attr = attrs;
        }
        if (this.row != null) {
            this.row.close();
        }
        ++this.highestRow;
        this.row = new RtfTableRow(this, this.writer, attr, this.highestRow);
        return this.row;
    }

    protected void writeRtfPrefix() throws IOException {
        if (this.isNestedTable()) {
            this.writeControlWordNS("pard");
        }
        this.writeGroupMark(true);
    }

    protected void writeRtfSuffix() throws IOException {
        this.writeGroupMark(false);
        if (this.isNestedTable()) {
            this.getRow().writeRowAndCellsDefintions();
        }
    }

    public boolean isHighestRow(int id) {
        return this.highestRow == id;
    }

    public ITableColumnsInfo getITableColumnsInfo() {
        return this.tableContext;
    }

    public void setHeaderAttribs(RtfAttributes attrs) {
        this.headerAttribs = attrs;
    }

    public RtfAttributes getHeaderAttribs() {
        return this.headerAttribs;
    }

    public RtfAttributes getRtfAttributes() {
        if (this.headerAttribs != null) {
            return this.headerAttribs;
        }
        return super.getRtfAttributes();
    }

    public boolean isNestedTable() {
        if (this.isNestedTable == null) {
            RtfContainer e = this;
            while (e.parent != null) {
                if (e.parent instanceof RtfTableCell) {
                    this.isNestedTable = Boolean.TRUE;
                    return true;
                }
                e = e.parent;
            }
        } else {
            return this.isNestedTable;
        }
        this.isNestedTable = Boolean.FALSE;
        return false;
    }

    public RtfTableRow getRow() {
        RtfContainer e = this;
        while (e.parent != null) {
            if (e.parent instanceof RtfTableRow) {
                return (RtfTableRow)e.parent;
            }
            e = e.parent;
        }
        return null;
    }

    public void setBorderAttributes(RtfAttributes attributes) {
        this.borderAttributes = attributes;
    }

    public RtfAttributes getBorderAttributes() {
        return this.borderAttributes;
    }
}

