/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CookieAction;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.view.projects.PostponeActionCookie;
import tr.view.projects.PostponeActionPanel;

public class PostponeActionAction
extends CookieAction {
    private PostponeActionPanel panel;

    protected String iconResource() {
        return "au/com/thinkingrock/tr/resource/icons/CalendarEdit.png";
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_PostponeActionAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public Class[] cookieClasses() {
        return new Class[]{Action.class};
    }

    public int mode() {
        return 4;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodes) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        Frame frame = WindowManager.getDefault().getMainWindow();
        final JDialog jd = new JDialog(frame, this.getName(), true);
        if (this.panel == null) {
            this.panel = new PostponeActionPanel();
        }
        JOptionPane op = new JOptionPane(this.panel, 1, 2, null, null, null);
        op.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                jd.dispose();
            }
        });
        jd.getContentPane().add((Component)op, "Center");
        jd.setDefaultCloseOperation(2);
        jd.pack();
        Rectangle r = Utilities.findCenterBounds((Dimension)jd.getSize());
        jd.setLocation(r.x, r.y);
        jd.setVisible(true);
        Object value = op.getValue();
        if (value instanceof Integer && (Integer)value == 0) {
            this.postpone(nodes, this.panel.getNumber(), this.panel.getPeriods());
        }
    }

    private void postpone(Node[] nodes, int n, Periods periods) {
        if (nodes == null || periods == null || n < 1) {
            return;
        }
        for (Node node : nodes) {
            PostponeActionCookie cookie = (PostponeActionCookie)node.getCookie(PostponeActionCookie.class);
            if (cookie == null) continue;
            cookie.postponeAction(n, periods);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Periods {
        DAYS,
        WEEKS,
        MONTHS,
        YEARS;

    }
}

