/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) - 0ul) => u64vec3(1333333333333333259ul, 85ul, 94ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) - 3ul) => u64vec3(1333333333333333256ul, 82ul, 91ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) - 1192ul) => u64vec3(1333333333333332067ul, 18446744073709550509ul, 18446744073709550518ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) - 1048576ul) => u64vec3(1333333333332284683ul, 18446744073708503125ul, 18446744073708503134ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) - 4251475ul) => u64vec3(1333333333329081784ul, 18446744073705300226ul, 18446744073705300235ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) - 29852643761ul) => u64vec3(1333333303480689498ul, 18446744043856907940ul, 18446744043856907949ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) - 4398046511104ul) => u64vec3(1333328935286822155ul, 18446739675663040597ul, 18446739675663040606ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) - 3948976685146ul) => u64vec3(1333329384356648113ul, 18446740124732866555ul, 18446740124732866564ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) - 135763469567146206ul) => u64vec3(1197569863766187053ul, 18310980604142405495ul, 18310980604142405504ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) - 11654173250180970009ul) => u64vec3(8125904156861914866ul, 6792570823528581692ul, 6792570823528581701ul)
 * (u64vec3(167ul, 66ul, 187ul) - 0ul) => u64vec3(167ul, 66ul, 187ul)
 * (u64vec3(167ul, 66ul, 187ul) - 3ul) => u64vec3(164ul, 63ul, 184ul)
 * (u64vec3(167ul, 66ul, 187ul) - 1192ul) => u64vec3(18446744073709550591ul, 18446744073709550490ul, 18446744073709550611ul)
 * (u64vec3(167ul, 66ul, 187ul) - 1048576ul) => u64vec3(18446744073708503207ul, 18446744073708503106ul, 18446744073708503227ul)
 * (u64vec3(167ul, 66ul, 187ul) - 4251475ul) => u64vec3(18446744073705300308ul, 18446744073705300207ul, 18446744073705300328ul)
 * (u64vec3(167ul, 66ul, 187ul) - 29852643761ul) => u64vec3(18446744043856908022ul, 18446744043856907921ul, 18446744043856908042ul)
 * (u64vec3(167ul, 66ul, 187ul) - 4398046511104ul) => u64vec3(18446739675663040679ul, 18446739675663040578ul, 18446739675663040699ul)
 * (u64vec3(167ul, 66ul, 187ul) - 3948976685146ul) => u64vec3(18446740124732866637ul, 18446740124732866536ul, 18446740124732866657ul)
 * (u64vec3(167ul, 66ul, 187ul) - 135763469567146206ul) => u64vec3(18310980604142405577ul, 18310980604142405476ul, 18310980604142405597ul)
 * (u64vec3(167ul, 66ul, 187ul) - 11654173250180970009ul) => u64vec3(6792570823528581774ul, 6792570823528581673ul, 6792570823528581794ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) - 0ul), u64vec3(1333333333333333259ul, 85ul, 94ul))) ? 1 : -1] array0;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) - 3ul), u64vec3(1333333333333333256ul, 82ul, 91ul))) ? 1 : -1] array1;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) - 1192ul), u64vec3(1333333333333332067ul, 18446744073709550509ul, 18446744073709550518ul))) ? 1 : -1] array2;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) - 1048576ul), u64vec3(1333333333332284683ul, 18446744073708503125ul, 18446744073708503134ul))) ? 1 : -1] array3;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) - 4251475ul), u64vec3(1333333333329081784ul, 18446744073705300226ul, 18446744073705300235ul))) ? 1 : -1] array4;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) - 29852643761ul), u64vec3(1333333303480689498ul, 18446744043856907940ul, 18446744043856907949ul))) ? 1 : -1] array5;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) - 4398046511104ul), u64vec3(1333328935286822155ul, 18446739675663040597ul, 18446739675663040606ul))) ? 1 : -1] array6;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) - 3948976685146ul), u64vec3(1333329384356648113ul, 18446740124732866555ul, 18446740124732866564ul))) ? 1 : -1] array7;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) - 135763469567146206ul), u64vec3(1197569863766187053ul, 18310980604142405495ul, 18310980604142405504ul))) ? 1 : -1] array8;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) - 11654173250180970009ul), u64vec3(8125904156861914866ul, 6792570823528581692ul, 6792570823528581701ul))) ? 1 : -1] array9;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) - 0ul), u64vec3(167ul, 66ul, 187ul))) ? 1 : -1] array10;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) - 3ul), u64vec3(164ul, 63ul, 184ul))) ? 1 : -1] array11;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) - 1192ul), u64vec3(18446744073709550591ul, 18446744073709550490ul, 18446744073709550611ul))) ? 1 : -1] array12;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) - 1048576ul), u64vec3(18446744073708503207ul, 18446744073708503106ul, 18446744073708503227ul))) ? 1 : -1] array13;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) - 4251475ul), u64vec3(18446744073705300308ul, 18446744073705300207ul, 18446744073705300328ul))) ? 1 : -1] array14;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) - 29852643761ul), u64vec3(18446744043856908022ul, 18446744043856907921ul, 18446744043856908042ul))) ? 1 : -1] array15;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) - 4398046511104ul), u64vec3(18446739675663040679ul, 18446739675663040578ul, 18446739675663040699ul))) ? 1 : -1] array16;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) - 3948976685146ul), u64vec3(18446740124732866637ul, 18446740124732866536ul, 18446740124732866657ul))) ? 1 : -1] array17;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) - 135763469567146206ul), u64vec3(18310980604142405577ul, 18310980604142405476ul, 18310980604142405597ul))) ? 1 : -1] array18;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) - 11654173250180970009ul), u64vec3(6792570823528581774ul, 6792570823528581673ul, 6792570823528581794ul))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
