/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.util.Objects;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.context.WebContainerContextWrapper;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class ContextKey {
    public String contextId;
    public Bundle bundle;
    public HttpContext httpContext;

    private ContextKey(String contextId, Bundle bundle) {
        this.contextId = contextId;
        this.bundle = bundle;
    }

    public static ContextKey with(String contextId, Bundle bundle) {
        return new ContextKey(contextId, bundle);
    }

    public static ContextKey of(OsgiContextModel context) {
        return new ContextKey(context.getName(), context.isShared() ? null : context.getOwnerBundle());
    }

    public static ContextKey of(WebContainerContext context) {
        ContextKey key = ContextKey.with(context.getContextId(), context.getBundle());
        if (context instanceof WebContainerContextWrapper) {
            WebContainerContextWrapper wrapper = (WebContainerContextWrapper)context;
            key.httpContext = wrapper.getHttpContext();
        }
        return key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextKey that = (ContextKey)o;
        boolean idBundleMatch = Objects.equals(this.contextId, that.contextId) && Objects.equals(this.bundle, that.bundle);
        return idBundleMatch || this.httpContext != null && this.httpContext == ((ContextKey)o).httpContext;
    }

    public int hashCode() {
        return Objects.hash(this.contextId, this.bundle);
    }

    public String toString() {
        return "Key{" + this.contextId + ", " + this.bundle + "}";
    }
}

