/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.ForwardingTemplateInstance;
import io.quarkus.qute.TemplateInstance;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class ResultsCollectingTemplateInstance
extends ForwardingTemplateInstance {
    private final TemplateInstance delegate;
    private final BiConsumer<TemplateInstance, String> resultConsumer;

    public ResultsCollectingTemplateInstance(TemplateInstance delegate, BiConsumer<TemplateInstance, String> resultConsumer) {
        this.delegate = delegate;
        this.resultConsumer = resultConsumer;
    }

    @Override
    protected TemplateInstance delegate() {
        return this.delegate;
    }

    @Override
    public String render() {
        String result = this.delegate.render();
        this.resultConsumer.accept(this.delegate, result);
        return result;
    }

    @Override
    public CompletionStage<String> renderAsync() {
        return this.delegate.renderAsync().thenApply(r -> {
            this.resultConsumer.accept(this.delegate, (String)r);
            return r;
        });
    }

    @Override
    public Multi<String> createMulti() {
        Multi<String> multi = this.delegate.createMulti();
        StringBuilder builder = new StringBuilder();
        return multi.onItem().invoke(builder::append).onCompletion().invoke(() -> this.resultConsumer.accept(this.delegate, builder.toString()));
    }

    @Override
    public Uni<String> createUni() {
        Uni uni = this.delegate.createUni();
        uni = uni.onItem().invoke(r -> this.resultConsumer.accept(this.delegate, (String)r));
        return uni;
    }

    @Override
    public CompletionStage<Void> consume(Consumer<String> consumer) {
        StringBuilder builder = new StringBuilder();
        CompletionStage<Void> cs = this.delegate.consume(consumer.andThen(builder::append));
        return cs.thenApply(v -> {
            this.resultConsumer.accept(this.delegate, builder.toString());
            return v;
        });
    }
}

