/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import io.quarkus.runtime.Quarkus;
import io.smallrye.config.ConfigValue;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.KeycloakConfigSourceProvider;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import picocli.CommandLine;

@CommandLine.Command(name="show-config", header={"Print out the current configuration."}, description={"%nPrint out the current configuration."})
public final class ShowConfig
extends AbstractCommand
implements Runnable {
    public static final String NAME = "show-config";
    private static final List<String> allowedSystemPropertyKeys = List.of("kc.version");
    @CommandLine.Parameters(paramLabel="filter", defaultValue="none", description={"Show all configuration options. Use 'all' to show all options."})
    String filter;

    @Override
    public void run() {
        String profile = Environment.updateProfile(true);
        Map<String, Set<String>> properties = ShowConfig.getPropertiesByGroup();
        this.printRunTimeConfig(properties, profile);
        if (this.filter.equalsIgnoreCase("all")) {
            this.spec.commandLine().getOut().println("Quarkus Configuration:");
            properties.get("quarkus").stream().sorted().forEachOrdered(this::printProperty);
        }
        Quarkus.asyncExit((int)0);
    }

    private void printRunTimeConfig(Map<String, Set<String>> properties, String profile) {
        HashSet uniqueNames = new HashSet();
        this.spec.commandLine().getOut().printf("Current Mode: %s%n", Environment.getKeycloakModeFromProfile(profile));
        this.spec.commandLine().getOut().println("Current Configuration:");
        properties.get("kc").stream().sorted().filter(uniqueNames::add).forEachOrdered(this::printProperty);
    }

    private static Map<String, Set<String>> getPropertiesByGroup() {
        Map<String, Set<String>> properties = StreamSupport.stream(Configuration.getPropertyNames().spliterator(), false).filter(ShowConfig::filterByGroup).collect(Collectors.groupingBy(ShowConfig::groupProperties, Collectors.toSet()));
        return properties;
    }

    private void printProperty(String property) {
        PropertyMapper<?> mapper;
        ConfigValue configValue = Configuration.getConfigValue(property);
        if (configValue.getValue() == null) {
            return;
        }
        if (configValue.getSourceName() == null) {
            return;
        }
        String value = configValue.getRawValue();
        if (value == null) {
            value = configValue.getValue();
        }
        if ((mapper = PropertyMappers.getMapper(property)) == null && configValue.getSourceName().equals("SysPropConfigSource") && !allowedSystemPropertyKeys.contains(property)) {
            return;
        }
        value = PropertyMappers.maskValue(configValue.getName(), value, configValue.getConfigSourceName());
        this.spec.commandLine().getOut().printf("\t%s =  %s (%s)%n", configValue.getName(), value, KeycloakConfigSourceProvider.getConfigSourceDisplayName(configValue.getConfigSourceName()));
    }

    private static String groupProperties(String property) {
        int endIndex = property.indexOf(46);
        if (endIndex == -1) {
            return "";
        }
        return property.substring(0, endIndex);
    }

    private static boolean filterByGroup(String property) {
        return property.startsWith("kc.") || property.startsWith("quarkus.");
    }

    @Override
    public String getName() {
        return NAME;
    }
}

