/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands.remote;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.xsite.SingleXSiteRpcCommand;
import org.infinispan.xsite.commands.remote.IracClearKeysRequest;
import org.infinispan.xsite.commands.remote.IracPutManyRequest;
import org.infinispan.xsite.commands.remote.IracTombstoneCheckRequest;
import org.infinispan.xsite.commands.remote.IracTouchKeyRequest;
import org.infinispan.xsite.commands.remote.XSiteRemoteEventCommand;
import org.infinispan.xsite.commands.remote.XSiteRequest;
import org.infinispan.xsite.commands.remote.XSiteStatePushRequest;
import org.infinispan.xsite.commands.remote.XSiteStateTransferControlRequest;

public final class Ids {
    private static final byte START_ID = 0;
    public static final byte STATE_TRANSFER_CONTROL = 0;
    public static final byte STATE_TRANSFER_STATE = 1;
    public static final byte VISITABLE_COMMAND = 2;
    public static final byte IRAC_UPDATE = 3;
    public static final byte IRAC_CLEAR = 4;
    public static final byte IRAC_TOUCH = 5;
    public static final byte IRAC_TOMBSTONE_CHECK = 6;
    public static final byte SITE_EVENT = 7;
    private static final byte END_ID = 8;
    private static final Builder[] ID_TO_COMMAND = new Builder[8];
    private static final Set<Class<? extends XSiteRequest>> CLASSES;

    private static Set<Class<? extends XSiteRequest>> checkMappingAndCreateClassSet() {
        HashSet<Class<? extends XSiteRequest>> classSet = new HashSet<Class<? extends XSiteRequest>>();
        for (byte i = 0; i < 8; i = (byte)(i + 1)) {
            XSiteRequest<?> cmd = Ids.fromId(i);
            if (i != Ids.fromId(i).getCommandId()) {
                throw new IllegalStateException("Id does not match. id=" + i + " command=" + String.valueOf(Ids.fromId(i).getClass()));
            }
            classSet.add(cmd.getClass());
        }
        return classSet;
    }

    private Ids() {
    }

    public static XSiteRequest<?> fromId(byte id) {
        return ID_TO_COMMAND[id].build();
    }

    public static Set<Class<? extends XSiteRequest>> getTypeClasses() {
        return CLASSES;
    }

    static {
        Ids.ID_TO_COMMAND[0] = XSiteStateTransferControlRequest::new;
        Ids.ID_TO_COMMAND[1] = XSiteStatePushRequest::new;
        Ids.ID_TO_COMMAND[2] = SingleXSiteRpcCommand::new;
        Ids.ID_TO_COMMAND[3] = IracPutManyRequest::new;
        Ids.ID_TO_COMMAND[4] = IracClearKeysRequest::new;
        Ids.ID_TO_COMMAND[5] = IracTouchKeyRequest::new;
        Ids.ID_TO_COMMAND[6] = IracTombstoneCheckRequest::new;
        Ids.ID_TO_COMMAND[7] = XSiteRemoteEventCommand::new;
        CLASSES = Set.copyOf(Ids.checkMappingAndCreateClassSet());
    }

    @FunctionalInterface
    private static interface Builder {
        public XSiteRequest<?> build();
    }
}

