/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.micrometer.runtime.MeterTagsSupport;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.TypesUtil;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.tuples.Functions;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.jboss.logging.Logger;

@Interceptor
@Timed
@Priority(value=1010)
public class MicrometerTimedInterceptor {
    private static final Logger log = Logger.getLogger(MicrometerTimedInterceptor.class);
    public static final String DEFAULT_METRIC_NAME = "method.timed";
    private final MeterRegistry meterRegistry;
    private final MeterTagsSupport meterTagsSupport;

    public MicrometerTimedInterceptor(MeterRegistry meterRegistry, MeterTagsSupport meterTagsSupport) {
        this.meterRegistry = meterRegistry;
        this.meterTagsSupport = meterTagsSupport;
    }

    @AroundInvoke
    Object timedMethod(ArcInvocationContext context) throws Exception {
        final List<Sample> samples = this.getSamples(context);
        if (samples.isEmpty()) {
            return context.proceed();
        }
        Class<?> returnType = context.getMethod().getReturnType();
        if (TypesUtil.isCompletionStage(returnType)) {
            try {
                return ((CompletionStage)context.proceed()).whenComplete((result, throwable) -> this.stop(samples, MicrometerRecorder.getExceptionTag(throwable)));
            }
            catch (Exception ex) {
                this.stop(samples, MicrometerRecorder.getExceptionTag(ex));
                throw ex;
            }
        }
        if (TypesUtil.isUni(returnType)) {
            try {
                return ((Uni)context.proceed()).onTermination().invoke((Functions.TriConsumer)new Functions.TriConsumer<Object, Throwable, Boolean>(){

                    public void accept(Object o, Throwable throwable, Boolean cancelled) {
                        MicrometerTimedInterceptor.this.stop(samples, MicrometerRecorder.getExceptionTag(throwable));
                    }
                });
            }
            catch (Exception ex) {
                this.stop(samples, MicrometerRecorder.getExceptionTag(ex));
                throw ex;
            }
        }
        String exceptionClass = MicrometerRecorder.getExceptionTag(null);
        try {
            Object object = context.proceed();
            return object;
        }
        catch (Exception ex) {
            exceptionClass = MicrometerRecorder.getExceptionTag(ex);
            throw ex;
        }
        finally {
            this.stop(samples, exceptionClass);
        }
    }

    private List<Sample> getSamples(ArcInvocationContext context) {
        List timed = context.findIterceptorBindings(Timed.class);
        if (timed.isEmpty()) {
            return Collections.emptyList();
        }
        Tags tags = this.meterTagsSupport.getTags(context);
        ArrayList<Sample> samples = new ArrayList<Sample>(timed.size());
        for (Timed t : timed) {
            if (t.longTask()) {
                samples.add(new LongTimerSample(t, tags));
                continue;
            }
            samples.add(new TimerSample(t, tags));
        }
        return samples;
    }

    private void stop(List<Sample> samples, String throwableClassName) {
        for (Sample sample : samples) {
            sample.stop(throwableClassName);
        }
    }

    private void record(Timed timed, Timer.Sample sample, String exceptionClass, Tags timerTags) {
        String metricName = timed.value().isEmpty() ? DEFAULT_METRIC_NAME : timed.value();
        try {
            Timer.Builder builder = Timer.builder((String)metricName).description(timed.description().isEmpty() ? null : timed.description()).tags((Iterable)timerTags).tag("exception", exceptionClass).publishPercentileHistogram(Boolean.valueOf(timed.histogram())).publishPercentiles(timed.percentiles().length == 0 ? null : timed.percentiles());
            sample.stop(builder.register(this.meterRegistry));
        }
        catch (Exception e) {
            log.warnf((Throwable)e, "Unable to record observed timer value for %s with exceptionClass %s", (Object)metricName, (Object)exceptionClass);
        }
    }

    LongTaskTimer.Sample startLongTaskTimer(Timed timed, Tags commonTags, String metricName) {
        try {
            return LongTaskTimer.builder((String)metricName).description(timed.description().isEmpty() ? null : timed.description()).tags((Iterable)commonTags).tags(timed.extraTags()).publishPercentileHistogram(Boolean.valueOf(timed.histogram())).register(this.meterRegistry).start();
        }
        catch (Exception e) {
            log.warnf((Throwable)e, "Unable to create long task timer named %s", (Object)metricName);
            return null;
        }
    }

    private void stopLongTaskTimer(String metricName, LongTaskTimer.Sample sample) {
        try {
            sample.stop();
        }
        catch (Exception e) {
            log.warnf((Throwable)e, "Unable to update long task timer named %s", (Object)metricName);
        }
    }

    private Tags getCommonTags(String className, String methodName) {
        return Tags.of((String[])new String[]{"class", className, "method", methodName});
    }

    final class LongTimerSample
    extends Sample {
        private final LongTaskTimer.Sample sample;

        public LongTimerSample(Timed timed, Tags commonTags) {
            super(timed, commonTags);
            this.sample = MicrometerTimedInterceptor.this.startLongTaskTimer(timed, commonTags, this.metricName());
        }

        @Override
        void stop(String exceptionClass) {
            MicrometerTimedInterceptor.this.stopLongTaskTimer(this.metricName(), this.sample);
        }
    }

    final class TimerSample
    extends Sample {
        private final Timer.Sample sample;

        public TimerSample(Timed timed, Tags commonTags) {
            super(timed, commonTags);
            this.sample = Timer.start((MeterRegistry)MicrometerTimedInterceptor.this.meterRegistry);
        }

        @Override
        void stop(String exceptionClass) {
            MicrometerTimedInterceptor.this.record(this.timed, this.sample, exceptionClass, Tags.concat((Iterable)this.commonTags, (String[])this.timed.extraTags()));
        }
    }

    static abstract class Sample {
        protected final Timed timed;
        protected final Tags commonTags;

        public Sample(Timed timed, Tags commonTags) {
            this.timed = timed;
            this.commonTags = commonTags;
        }

        String metricName() {
            return this.timed.value().isEmpty() ? MicrometerTimedInterceptor.DEFAULT_METRIC_NAME : this.timed.value();
        }

        abstract void stop(String var1);
    }
}

