/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.function.Supplier;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.crypto.KeyUse;
import org.keycloak.provider.ProviderConfigProperty;

public interface Attributes {
    public static final String PRIORITY_KEY = "priority";
    public static final ProviderConfigProperty PRIORITY_PROPERTY = new ProviderConfigProperty("priority", "Priority", "Priority for the provider", "String", (Object)"0");
    public static final String ENABLED_KEY = "enabled";
    public static final ProviderConfigProperty ENABLED_PROPERTY = new ProviderConfigProperty("enabled", "Enabled", "Set if the keys are enabled", "boolean", (Object)"true");
    public static final String ACTIVE_KEY = "active";
    public static final ProviderConfigProperty ACTIVE_PROPERTY = new ProviderConfigProperty("active", "Active", "Set if the keys can be used for signing", "boolean", (Object)"true");
    public static final String PRIVATE_KEY_KEY = "privateKey";
    public static final ProviderConfigProperty PRIVATE_KEY_PROPERTY = new ProviderConfigProperty("privateKey", "Private RSA Key", "Private RSA Key encoded in PEM format", "File", null, true);
    public static final String CERTIFICATE_KEY = "certificate";
    public static final ProviderConfigProperty CERTIFICATE_PROPERTY = new ProviderConfigProperty("certificate", "X509 Certificate", "X509 Certificate encoded in PEM format", "File", null);
    public static final String KEY_SIZE_KEY = "keySize";
    public static final Supplier<ProviderConfigProperty> KEY_SIZE_PROPERTY = () -> new ProviderConfigProperty(KEY_SIZE_KEY, "Key size", "Size for the generated keys", "List", (Object)"2048", CryptoIntegration.getProvider().getSupportedRsaKeySizes());
    public static final String KEY_USE = "keyUse";
    public static final ProviderConfigProperty KEY_USE_PROPERTY = new ProviderConfigProperty("keyUse", "Key use", "Whether the key should be used for signing or encryption.", "List", (Object)KeyUse.SIG.getSpecName(), new String[]{KeyUse.SIG.getSpecName(), KeyUse.ENC.getSpecName()});
    public static final String EC_GENERATE_CERTIFICATE_KEY = "ecGenerateCertificate";
    public static final ProviderConfigProperty EC_GENERATE_CERTIFICATE_PROPERTY = new ProviderConfigProperty("ecGenerateCertificate", "Generate Certificate", "If a certificate should be build on creation. If the certificate is build, it will be available in the realm JWK for the key in the claim x5c and corresponding thumbprints may be available in the claims like x5t or x5t#S256.", "boolean", (Object)false);
    public static final String KID_KEY = "kid";
    public static final String SECRET_KEY = "secret";
    public static final String SECRET_SIZE_KEY = "secretSize";
    public static final ProviderConfigProperty SECRET_SIZE_PROPERTY = new ProviderConfigProperty("secretSize", "Secret size", "Size in bytes for the generated secret", "List", (Object)String.valueOf(128), new String[]{"16", "24", "32", "64", "128", "256", "512"});
    public static final String ALGORITHM_KEY = "algorithm";
    public static final ProviderConfigProperty RS_ALGORITHM_PROPERTY = new ProviderConfigProperty("algorithm", "Algorithm", "Intended algorithm for the key", "List", (Object)"RS256", new String[]{"RS256", "RS384", "RS512", "PS256", "PS384", "PS512"});
    public static final ProviderConfigProperty HS_ALGORITHM_PROPERTY = new ProviderConfigProperty("algorithm", "Algorithm", "Intended algorithm for the key", "List", (Object)"HS512", new String[]{"HS256", "HS384", "HS512"});
    public static final ProviderConfigProperty RS_ENC_ALGORITHM_PROPERTY = new ProviderConfigProperty("algorithm", "Algorithm", "Intended algorithm for the key encryption", "List", (Object)"RSA-OAEP", new String[]{"RSA1_5", "RSA-OAEP", "RSA-OAEP-256"});
}

