/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionPointModifier;
import jakarta.enterprise.inject.spi.DefinitionException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class Injection {
    private static final Logger LOGGER = Logger.getLogger(Injection.class);
    final AnnotationTarget target;
    final List<InjectionPointInfo> injectionPoints;

    static Injection forSyntheticBean(Iterable<InjectionPointInfo.TypeAndQualifiers> injectionPoints) {
        return Injection.forSynthetic(injectionPoints, BeanType.SYNTHETIC_BEAN);
    }

    static Injection forSyntheticInterceptor(Iterable<InjectionPointInfo.TypeAndQualifiers> injectionPoints) {
        return Injection.forSynthetic(injectionPoints, BeanType.SYNTHETIC_INTERCEPTOR);
    }

    private static Injection forSynthetic(Iterable<InjectionPointInfo.TypeAndQualifiers> injectionPoints, BeanType beanType) {
        ArrayList<InjectionPointInfo> ret = new ArrayList<InjectionPointInfo>();
        for (InjectionPointInfo.TypeAndQualifiers injectionPoint : injectionPoints) {
            InjectionPointInfo ip = InjectionPointInfo.fromSyntheticInjectionPoint(injectionPoint);
            Injection.validateInjections(ip, beanType);
            ret.add(ip);
        }
        return new Injection(null, ret);
    }

    private static void validateInjections(InjectionPointInfo injectionPointInfo, BeanType beanType) {
        DotName expectedType;
        AnnotationTarget ipTarget;
        Type actualType;
        if (beanType == BeanType.MANAGED_BEAN || beanType == BeanType.SYNTHETIC_BEAN || beanType == BeanType.PRODUCER_METHOD) {
            if (injectionPointInfo.getType().name().equals((Object)DotNames.INTERCEPTOR_BEAN)) {
                throw new DefinitionException("Invalid injection of Interceptor<T> bean, can only be used in interceptors but was detected in: " + injectionPointInfo.getTargetInfo());
            }
            if (injectionPointInfo.getType().name().equals((Object)DotNames.BEAN) && injectionPointInfo.getRequiredQualifier(DotNames.INTERCEPTED) != null) {
                throw new DefinitionException("Invalid injection of @Intercepted Bean<T>, can only be injected into interceptors but was detected in: " + injectionPointInfo.getTargetInfo());
            }
            if (injectionPointInfo.getRequiredType().name().equals((Object)DotNames.BEAN) && injectionPointInfo.getRequiredType().kind() == Type.Kind.PARAMETERIZED_TYPE && injectionPointInfo.getRequiredType().asParameterizedType().arguments().size() == 1 && injectionPointInfo.hasDefaultedQualifier()) {
                actualType = (Type)injectionPointInfo.getRequiredType().asParameterizedType().arguments().get(0);
                ipTarget = injectionPointInfo.getAnnotationTarget();
                expectedType = null;
                if (ipTarget.kind() == AnnotationTarget.Kind.FIELD) {
                    expectedType = ipTarget.asField().declaringClass().name();
                } else if (ipTarget.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                    expectedType = beanType == BeanType.PRODUCER_METHOD ? ipTarget.asMethodParameter().method().returnType().name() : ipTarget.asMethodParameter().method().declaringClass().name();
                }
                if (expectedType != null && !expectedType.equals((Object)actualType.name())) {
                    throw new DefinitionException("Type of injected Bean<T> does not match the type of the bean declaring the injection point. Problematic injection point: " + injectionPointInfo.getTargetInfo());
                }
            }
        }
        if (beanType == BeanType.INTERCEPTOR) {
            ParameterizedType parameterizedType;
            if (injectionPointInfo.getRequiredType().name().equals((Object)DotNames.BEAN) && injectionPointInfo.getRequiredQualifier(DotNames.INTERCEPTED) != null && injectionPointInfo.getRequiredType().kind() == Type.Kind.PARAMETERIZED_TYPE && ((parameterizedType = injectionPointInfo.getRequiredType().asParameterizedType()).arguments().size() != 1 || ((Type)parameterizedType.arguments().get(0)).kind() != Type.Kind.WILDCARD_TYPE || !((Type)parameterizedType.arguments().get(0)).asWildcardType().extendsBound().name().equals((Object)DotNames.OBJECT) || ((Type)parameterizedType.arguments().get(0)).asWildcardType().superBound() != null)) {
                throw new DefinitionException("Injected @Intercepted Bean<?> has to use unbound wildcard as its type parameter. Problematic injection point: " + injectionPointInfo.getTargetInfo());
            }
            if (injectionPointInfo.getRequiredType().name().equals((Object)DotNames.INTERCEPTOR_BEAN) && injectionPointInfo.getRequiredType().kind() == Type.Kind.PARAMETERIZED_TYPE && injectionPointInfo.getRequiredType().asParameterizedType().arguments().size() == 1) {
                actualType = (Type)injectionPointInfo.getRequiredType().asParameterizedType().arguments().get(0);
                ipTarget = injectionPointInfo.getAnnotationTarget();
                expectedType = null;
                if (ipTarget.kind() == AnnotationTarget.Kind.FIELD) {
                    expectedType = ipTarget.asField().declaringClass().name();
                } else if (ipTarget.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                    expectedType = ipTarget.asMethodParameter().method().declaringClass().name();
                }
                if (expectedType != null && !expectedType.equals((Object)actualType.name())) {
                    throw new DefinitionException("Type of injected Interceptor<T> does not match the type of the bean declaring the injection point. Problematic injection point: " + injectionPointInfo.getTargetInfo());
                }
            }
        }
    }

    private static void validateInjections(List<Injection> injections, BeanType beanType) {
        for (Injection injection : injections) {
            for (InjectionPointInfo ipi : injection.injectionPoints) {
                Injection.validateInjections(ipi, beanType);
            }
        }
    }

    static List<Injection> forBean(AnnotationTarget beanTarget, BeanInfo declaringBean, BeanDeployment beanDeployment, InjectionPointModifier transformer, BeanType beanType) {
        if (AnnotationTarget.Kind.CLASS.equals((Object)beanTarget.kind())) {
            List<Injection> injections = Injection.forClassBean(beanTarget.asClass(), beanTarget.asClass(), beanDeployment, transformer, false, new HashSet<MethodOverrideKey>());
            Set injectConstructors = injections.stream().filter(Injection::isConstructor).map(Injection::getTarget).collect(Collectors.toSet());
            if (injectConstructors.size() > 1) {
                throw new DefinitionException("Multiple @Inject constructors found on " + String.valueOf(beanTarget.asClass().name()) + ":\n" + injectConstructors.stream().map(Object::toString).collect(Collectors.joining("\n")));
            }
            for (AnnotationTarget injectConstructor : injectConstructors) {
                Set<AnnotationInstance> parameterAnnotations = Annotations.getParameterAnnotations(beanDeployment, injectConstructor.asMethod());
                for (AnnotationInstance annotation : parameterAnnotations) {
                    if (DotNames.DISPOSES.equals((Object)annotation.name())) {
                        throw new DefinitionException("Bean constructor must not have a @Disposes parameter: " + String.valueOf(injectConstructor));
                    }
                    if (DotNames.OBSERVES.equals((Object)annotation.name())) {
                        throw new DefinitionException("Bean constructor must not have an @Observes parameter: " + String.valueOf(injectConstructor));
                    }
                    if (!DotNames.OBSERVES_ASYNC.equals((Object)annotation.name())) continue;
                    throw new DefinitionException("Bean constructor must not have an @ObservesAsync parameter: " + String.valueOf(injectConstructor));
                }
            }
            Set initializerMethods = injections.stream().filter(it -> it.isMethod() && !it.isConstructor()).map(Injection::getTarget).map(AnnotationTarget::asMethod).collect(Collectors.toSet());
            for (MethodInfo initializerMethod : initializerMethods) {
                if (beanDeployment.hasAnnotation((AnnotationTarget)initializerMethod, DotNames.PRODUCES)) {
                    throw new DefinitionException("Initializer method must not be annotated @Produces (alternatively, producer method must not be annotated @Inject): " + String.valueOf(beanTarget.asClass()) + "." + initializerMethod.name());
                }
                if (Annotations.hasParameterAnnotation(beanDeployment, initializerMethod, DotNames.DISPOSES)) {
                    throw new DefinitionException("Initializer method must not have a @Disposes parameter (alternatively, disposer method must not be annotated @Inject): " + String.valueOf(beanTarget.asClass()) + "." + initializerMethod.name());
                }
                if (Annotations.hasParameterAnnotation(beanDeployment, initializerMethod, DotNames.OBSERVES)) {
                    throw new DefinitionException("Initializer method must not have an @Observes parameter (alternatively, observer method must not be annotated @Inject): " + String.valueOf(beanTarget.asClass()) + "." + initializerMethod.name());
                }
                if (!Annotations.hasParameterAnnotation(beanDeployment, initializerMethod, DotNames.OBSERVES_ASYNC)) continue;
                throw new DefinitionException("Initializer method must not have an @ObservesAsync parameter (alternatively, async observer method must not be annotated @Inject): " + String.valueOf(beanTarget.asClass()) + "." + initializerMethod.name());
            }
            Injection.validateInjections(injections, beanType);
            return injections;
        }
        if (AnnotationTarget.Kind.METHOD.equals((Object)beanTarget.kind())) {
            MethodInfo producerMethod = beanTarget.asMethod();
            if (beanDeployment.hasAnnotation((AnnotationTarget)producerMethod, DotNames.INJECT)) {
                throw new DefinitionException("Producer method must not be annotated @Inject (alternatively, initializer method must not be annotated @Produces): " + String.valueOf(producerMethod));
            }
            if (Annotations.hasParameterAnnotation(beanDeployment, producerMethod, DotNames.DISPOSES)) {
                throw new DefinitionException("Producer method must not have a @Disposes parameter (alternatively, disposer method must not be annotated @Produces): " + String.valueOf(producerMethod));
            }
            if (Annotations.hasParameterAnnotation(beanDeployment, producerMethod, DotNames.OBSERVES)) {
                throw new DefinitionException("Producer method must not have an @Observes parameter (alternatively, observer method must not be annotated @Produces): " + String.valueOf(producerMethod));
            }
            if (Annotations.hasParameterAnnotation(beanDeployment, producerMethod, DotNames.OBSERVES_ASYNC)) {
                throw new DefinitionException("Producer method must not have an @ObservesAsync parameter (alternatively, async observer method must not be annotated @Produces): " + String.valueOf(producerMethod));
            }
            if (producerMethod.parameterTypes().isEmpty()) {
                return Collections.emptyList();
            }
            List<Injection> injections = Collections.singletonList(new Injection((AnnotationTarget)producerMethod, InjectionPointInfo.fromMethod(producerMethod, declaringBean.getImplClazz(), beanDeployment, transformer)));
            Injection.validateInjections(injections, beanType);
            return injections;
        }
        throw new IllegalArgumentException("Unsupported annotation target");
    }

    private static List<Injection> forClassBean(ClassInfo beanClass, ClassInfo classInfo, BeanDeployment beanDeployment, InjectionPointModifier transformer, boolean skipConstructors, Set<MethodOverrideKey> seenMethods) {
        ClassInfo info;
        Object injectTarget;
        List<Injection> injections = new ArrayList<Injection>();
        List<AnnotationInstance> injectAnnotations = Injection.getAllInjectionPoints(beanDeployment, classInfo, DotNames.INJECT, skipConstructors, seenMethods);
        block4: for (AnnotationInstance injectAnnotation : injectAnnotations) {
            injectTarget = injectAnnotation.target();
            switch (injectAnnotation.target().kind()) {
                case FIELD: {
                    injections.add(new Injection((AnnotationTarget)injectTarget, Collections.singletonList(InjectionPointInfo.fromField(injectTarget.asField(), beanClass, beanDeployment, transformer))));
                    continue block4;
                }
                case METHOD: {
                    if (!injectTarget.asMethod().isConstructor() && !injectTarget.asMethod().typeParameters().isEmpty()) {
                        throw new DefinitionException("Initializer method may not be generic (declare type parameters): " + String.valueOf(injectTarget));
                    }
                    injections.add(new Injection((AnnotationTarget)injectTarget, InjectionPointInfo.fromMethod(injectTarget.asMethod(), beanClass, beanDeployment, transformer)));
                    continue block4;
                }
            }
            LOGGER.warn((Object)("Unsupported @Inject target ignored: " + String.valueOf(injectAnnotation.target())));
        }
        if (beanClass.equals(classInfo)) {
            boolean isNonStaticInnerClass;
            boolean bl = isNonStaticInnerClass = classInfo.name().isInner() && !Modifier.isStatic(classInfo.flags());
            if (!(isNonStaticInnerClass || Injection.hasConstructorInjection(injections) || beanClass.hasNoArgsConstructor())) {
                ArrayList<MethodInfo> nonNoargConstrs = new ArrayList<MethodInfo>();
                for (MethodInfo constr : classInfo.methods()) {
                    if (!"<init>".equals(constr.name()) || constr.parametersCount() <= 0) continue;
                    nonNoargConstrs.add(constr);
                }
                if (nonNoargConstrs.size() == 1) {
                    injectTarget = (MethodInfo)nonNoargConstrs.get(0);
                    injections.add(new Injection((AnnotationTarget)injectTarget, InjectionPointInfo.fromMethod(injectTarget.asMethod(), beanClass, beanDeployment, transformer)));
                }
            }
        }
        for (DotName resourceAnnotation : beanDeployment.getResourceAnnotations()) {
            List<AnnotationInstance> resourceAnnotations = Injection.getAllInjectionPoints(beanDeployment, classInfo, resourceAnnotation, true, seenMethods);
            for (AnnotationInstance resourceAnnotationInstance : resourceAnnotations) {
                if (AnnotationTarget.Kind.FIELD != resourceAnnotationInstance.target().kind() || !resourceAnnotationInstance.target().asField().annotations().stream().noneMatch(a -> DotNames.INJECT.equals((Object)a.name()))) continue;
                injections.add(new Injection(resourceAnnotationInstance.target(), Collections.singletonList(InjectionPointInfo.fromResourceField(resourceAnnotationInstance.target().asField(), beanClass, beanDeployment, transformer))));
            }
        }
        if (!classInfo.superName().equals((Object)DotNames.OBJECT) && (info = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), classInfo.superName())) != null) {
            List<Injection> superInjections = Injection.forClassBean(beanClass, info, beanDeployment, transformer, true, seenMethods);
            superInjections.addAll(injections);
            injections = superInjections;
        }
        return injections;
    }

    static Injection forDisposer(MethodInfo disposerMethod, ClassInfo beanClass, BeanDeployment beanDeployment, InjectionPointModifier transformer) {
        if (beanDeployment.hasAnnotation((AnnotationTarget)disposerMethod, DotNames.INJECT)) {
            throw new DefinitionException("Disposer method must not be annotated @Inject (alternatively, initializer method must not have a @Disposes parameter): " + String.valueOf(disposerMethod));
        }
        if (beanDeployment.hasAnnotation((AnnotationTarget)disposerMethod, DotNames.PRODUCES)) {
            throw new DefinitionException("Disposer method must not be annotated @Produces (alternatively, producer method must not have a @Disposes parameter): " + String.valueOf(disposerMethod));
        }
        if (Annotations.hasParameterAnnotation(beanDeployment, disposerMethod, DotNames.OBSERVES)) {
            throw new DefinitionException("Disposer method must not have an @Observes parameter (alternatively, observer method must not have a @Disposes parameter): " + String.valueOf(disposerMethod));
        }
        if (Annotations.hasParameterAnnotation(beanDeployment, disposerMethod, DotNames.OBSERVES_ASYNC)) {
            throw new DefinitionException("Disposer method must not have an @ObservesAsync parameter (alternatively, async observer method must not have a @Disposes parameter): " + String.valueOf(disposerMethod));
        }
        if (Annotations.getParameterAnnotations(beanDeployment, disposerMethod).stream().filter(it -> DotNames.DISPOSES.equals((Object)it.name())).count() > 1L) {
            throw new DefinitionException("Disposer method must not have more than 1 @Disposes parameter: " + String.valueOf(disposerMethod));
        }
        Injection injection = new Injection((AnnotationTarget)disposerMethod, InjectionPointInfo.fromMethod(disposerMethod, beanClass, beanDeployment, (annotations, position) -> annotations.stream().anyMatch(a -> a.name().equals((Object)DotNames.DISPOSES)), transformer));
        injection.injectionPoints.forEach(ipi -> Injection.validateInjections(ipi, BeanType.MANAGED_BEAN));
        return injection;
    }

    static Injection forObserver(MethodInfo observerMethod, ClassInfo beanClass, BeanDeployment beanDeployment, InjectionPointModifier transformer) {
        return new Injection((AnnotationTarget)observerMethod, InjectionPointInfo.fromMethod(observerMethod, beanClass, beanDeployment, (annotations, position) -> annotations.stream().anyMatch(a -> a.name().equals((Object)DotNames.OBSERVES) || a.name().equals((Object)DotNames.OBSERVES_ASYNC)), transformer));
    }

    static Injection forInvokerArgumentLookups(ClassInfo targetBeanClass, MethodInfo targetMethod, boolean[] argumentLookups, BeanDeployment beanDeployment, InjectionPointModifier transformer) {
        return new Injection((AnnotationTarget)targetMethod, InjectionPointInfo.fromMethod(targetMethod, targetBeanClass, beanDeployment, (annotations, position) -> !argumentLookups[position], transformer));
    }

    public Injection(AnnotationTarget target, List<InjectionPointInfo> injectionPoints) {
        this.target = target;
        this.injectionPoints = injectionPoints;
    }

    boolean isMethod() {
        return this.target != null && AnnotationTarget.Kind.METHOD == this.target.kind();
    }

    boolean isConstructor() {
        return this.isMethod() && this.target.asMethod().name().equals("<init>");
    }

    boolean isField() {
        return this.target != null && AnnotationTarget.Kind.FIELD == this.target.kind();
    }

    boolean isSynthetic() {
        return this.target == null;
    }

    public AnnotationTarget getTarget() {
        return this.target;
    }

    public void init(BeanInfo targetBean) {
        for (InjectionPointInfo injectionPoint : this.injectionPoints) {
            injectionPoint.setTargetBean(targetBean);
        }
    }

    private static boolean hasConstructorInjection(List<Injection> injections) {
        for (Injection injection : injections) {
            if (!injection.isConstructor()) continue;
            return true;
        }
        return false;
    }

    private static List<AnnotationInstance> getAllInjectionPoints(BeanDeployment beanDeployment, ClassInfo beanClass, DotName annotationName, boolean skipConstructors, Set<MethodOverrideKey> seenMethods) {
        ArrayList<AnnotationInstance> injectAnnotations = new ArrayList<AnnotationInstance>();
        for (FieldInfo field : beanClass.fields()) {
            AnnotationInstance inject = beanDeployment.getAnnotation((AnnotationTarget)field, annotationName);
            if (inject == null) continue;
            if (Modifier.isFinal(field.flags()) || Modifier.isStatic(field.flags())) {
                LOGGER.warn((Object)("An injection field must be non-static and non-final - ignoring: " + String.valueOf(field.declaringClass().name()) + "#" + field.name()));
                continue;
            }
            injectAnnotations.add(inject);
        }
        for (MethodInfo method : beanClass.methods()) {
            MethodOverrideKey key;
            if (skipConstructors && method.name().equals("<init>") || Injection.isOverriden(key = new MethodOverrideKey(method), seenMethods)) continue;
            seenMethods.add(key);
            AnnotationInstance inject = beanDeployment.getAnnotation((AnnotationTarget)method, annotationName);
            if (inject == null) continue;
            if (Modifier.isStatic(method.flags())) {
                LOGGER.warn((Object)("An initializer method must be non-static - ignoring: " + String.valueOf(method.declaringClass().name()) + "#" + method.name() + "()"));
                continue;
            }
            injectAnnotations.add(inject);
        }
        return injectAnnotations;
    }

    static boolean isOverriden(MethodOverrideKey method, Set<MethodOverrideKey> previousMethods) {
        short flags = method.method.flags();
        if (Modifier.isPublic(flags) || Modifier.isProtected(flags)) {
            return previousMethods.contains(method);
        }
        if (Modifier.isPrivate(flags)) {
            return false;
        }
        if (previousMethods.contains(method)) {
            return true;
        }
        String packageName = method.packageName();
        MethodOverrideKey methodWithoutVisibility = method.withoutVisibility();
        for (MethodOverrideKey previousMethod : previousMethods) {
            if (!methodWithoutVisibility.equals(previousMethod) || !packageName.equals(previousMethod.packageName())) continue;
            return true;
        }
        return false;
    }

    static enum BeanType {
        MANAGED_BEAN,
        PRODUCER_METHOD,
        SYNTHETIC_BEAN,
        INTERCEPTOR,
        SYNTHETIC_INTERCEPTOR,
        DECORATOR;

    }

    static class MethodOverrideKey {
        final String name;
        final List<DotName> params;
        final DotName returnType;
        final String visibility;
        final MethodInfo method;

        public MethodOverrideKey(MethodInfo method) {
            this.method = Objects.requireNonNull(method, "Method must not be null");
            this.name = method.name();
            this.returnType = method.returnType().name();
            this.params = new ArrayList<DotName>();
            for (Type i : method.parameterTypes()) {
                this.params.add(i.name());
            }
            this.visibility = Modifier.isPublic(method.flags()) || Modifier.isProtected(method.flags()) ? "" : (Modifier.isPrivate(method.flags()) ? method.declaringClass().name().toString() : method.declaringClass().name().packagePrefix());
        }

        private MethodOverrideKey(String name, List<DotName> params, DotName returnType, String visibility, MethodInfo method) {
            this.name = name;
            this.params = params;
            this.returnType = returnType;
            this.visibility = visibility;
            this.method = method;
        }

        MethodOverrideKey withoutVisibility() {
            return new MethodOverrideKey(this.name, this.params, this.returnType, "", this.method);
        }

        String packageName() {
            return this.method.declaringClass().name().packagePrefix();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodOverrideKey)) {
                return false;
            }
            MethodOverrideKey methodKey = (MethodOverrideKey)o;
            return Objects.equals(this.name, methodKey.name) && Objects.equals(this.params, methodKey.params) && Objects.equals(this.returnType, methodKey.returnType) && Objects.equals(this.visibility, methodKey.visibility);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.params, this.returnType, this.visibility);
        }
    }
}

