/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator;

import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.util.BitrateTracker;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.AimdRateControl;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.BandwidthUsage;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.InterArrival;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.OverUseDetectorOptions;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.OveruseDetector;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.OveruseEstimator;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.RateControlInput;

public class RemoteBitrateEstimatorAbsSendTime {
    private static final int kBitrateWindowMs = 1000;
    static final int kDefaultMinBitrateBps = 30000;
    private static final int kStreamTimeOutMs = 2000;
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(RemoteBitrateEstimatorAbsSendTime.class);
    private static final int kAbsSendTimeFraction = 18;
    private static final int kAbsSendTimeInterArrivalUpshift = 8;
    private static final int kTimestampGroupLengthMs = 5;
    private static final int kInterArrivalShift = 26;
    private static final long kTimestampGroupLengthTicks = 335544L;
    private static final double kTimestampToMs = 1.4901161193847656E-5;
    private final long[] deltas = new long[3];
    private final RateControlInput input = new RateControlInput(BandwidthUsage.kBwNormal, 0L, 0.0);
    private long lastPacketTimeMs;
    private long firstPacketTimeMs;
    private long lastUpdateMs;
    private final AimdRateControl remoteRate;
    private Detector detector;
    private BitrateTracker incomingBitrate;
    private boolean incomingBitrateInitialized;
    private final DiagnosticContext diagnosticContext;
    private final Logger logger;

    public RemoteBitrateEstimatorAbsSendTime(@NotNull DiagnosticContext diagnosticContext, @NotNull Logger parentLogger) {
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
        this.diagnosticContext = diagnosticContext;
        this.remoteRate = new AimdRateControl(diagnosticContext);
        this.incomingBitrate = new BitrateTracker(Duration.ofMillis(1000L));
        this.incomingBitrateInitialized = false;
        this.firstPacketTimeMs = -1L;
        this.lastPacketTimeMs = -1L;
        this.lastUpdateMs = -1L;
    }

    public synchronized void reset() {
        this.remoteRate.reset();
        this.incomingBitrate = new BitrateTracker(Duration.ofMillis(1000L));
        this.incomingBitrateInitialized = false;
        this.firstPacketTimeMs = -1L;
        this.lastPacketTimeMs = -1L;
        this.lastUpdateMs = -1L;
        this.detector = null;
    }

    public synchronized void incomingPacketInfo(long nowMs, long sendTimeMs, long arrivalTimeMs, int payloadSize) {
        long incomingRate_;
        long incomingBitrate_;
        long sendTime24bits = RemoteBitrateEstimatorAbsSendTime.convertMsTo24Bits(sendTimeMs);
        long timestamp = sendTime24bits << 8;
        if (timeSeriesLogger.isTraceEnabled()) {
            timeSeriesLogger.trace(this.diagnosticContext.makeTimeSeriesPoint("in_pkt", nowMs).addField("rbe_id", this.hashCode()).addField("recv_ts_ms", arrivalTimeMs).addField("timestamp", timestamp).addField("pkt_sz_bytes", payloadSize));
        }
        if ((incomingBitrate_ = this.incomingBitrate.getRateBps(arrivalTimeMs)) != 0L) {
            this.incomingBitrateInitialized = true;
        } else if (this.incomingBitrateInitialized) {
            this.incomingBitrate = new BitrateTracker(Duration.ofMillis(1000L));
            this.incomingBitrateInitialized = false;
        }
        this.incomingBitrate.update(DataSizeKt.getBytes(payloadSize), arrivalTimeMs);
        if (this.firstPacketTimeMs == -1L) {
            this.firstPacketTimeMs = nowMs;
        }
        boolean updateEstimate = false;
        this.checkTimeouts(nowMs);
        this.lastPacketTimeMs = nowMs;
        long[] deltas = this.deltas;
        deltas[0] = 0L;
        deltas[1] = 0L;
        deltas[2] = 0L;
        if (this.detector == null) {
            this.detector = new Detector(new OverUseDetectorOptions(), true, this.logger);
        }
        if (this.detector.interArrival.computeDeltas(timestamp, arrivalTimeMs, payloadSize, deltas, nowMs)) {
            double tsDeltaMs = (double)deltas[0] * 1.4901161193847656E-5;
            this.detector.estimator.update(deltas[1], tsDeltaMs, (int)deltas[2], this.detector.detector.getState(), nowMs);
            this.detector.detector.detect(this.detector.estimator.getOffset(), tsDeltaMs, this.detector.estimator.getNumOfDeltas(), arrivalTimeMs);
        }
        if (this.lastUpdateMs == -1L || nowMs - this.lastUpdateMs > this.remoteRate.getFeedBackInterval()) {
            updateEstimate = true;
        } else if (this.detector.detector.getState() == BandwidthUsage.kBwOverusing && (incomingRate_ = this.incomingBitrate.getRateBps(arrivalTimeMs)) > 0L && this.remoteRate.isTimeToReduceFurther(nowMs, incomingBitrate_)) {
            updateEstimate = true;
        }
        if (updateEstimate) {
            this.input.bwState = this.detector.detector.getState();
            this.input.incomingBitRate = this.incomingBitrate.getRateBps(arrivalTimeMs);
            this.input.noiseVar = this.detector.estimator.getVarNoise();
            this.remoteRate.update(this.input, nowMs);
            this.remoteRate.updateBandwidthEstimate(nowMs);
            updateEstimate = this.remoteRate.isValidEstimate();
        }
        if (updateEstimate) {
            this.lastUpdateMs = nowMs;
        }
    }

    private synchronized void checkTimeouts(long nowMs) {
        if (nowMs - this.lastPacketTimeMs > 2000L) {
            this.detector = null;
        }
    }

    public synchronized void onRttUpdate(long nowMs, long avgRttMs) {
        if (timeSeriesLogger.isTraceEnabled()) {
            timeSeriesLogger.trace(this.diagnosticContext.makeTimeSeriesPoint("new_rtt", nowMs).addField("avg_ms", avgRttMs));
        }
        this.remoteRate.setRtt(nowMs, avgRttMs);
    }

    public synchronized long getLatestEstimate() {
        if (!this.remoteRate.isValidEstimate()) {
            return -1L;
        }
        long bitrateBps = this.detector == null ? 0L : this.remoteRate.getLatestEstimate();
        return bitrateBps;
    }

    public synchronized void setMinBitrate(int minBitrateBps) {
        this.remoteRate.setMinBitrate(minBitrateBps);
    }

    @Nullable
    public synchronized Statistics getStatistics() {
        if (this.detector == null) {
            return null;
        }
        return new Statistics(this.detector.estimator.getOffset(), this.detector.detector.getThreshold(), this.detector.detector.getState());
    }

    public static long convertMsTo24Bits(long timeMs) {
        return ((timeMs << 18) + 500L) / 1000L & 0xFFFFFFL;
    }

    public static class Statistics {
        public double offset;
        public double threshold;
        public BandwidthUsage hypothesis;

        public Statistics(double o, double t2, BandwidthUsage h2) {
            this.offset = o;
            this.threshold = t2;
            this.hypothesis = h2;
        }
    }

    private class Detector {
        private final InterArrival interArrival;
        private final OveruseEstimator estimator;
        private final OveruseDetector detector;

        Detector(OverUseDetectorOptions options2, boolean enableBurstGrouping, Logger parentLogger) {
            this.interArrival = new InterArrival(335544L, 1.4901161193847656E-5, enableBurstGrouping, RemoteBitrateEstimatorAbsSendTime.this.diagnosticContext, parentLogger);
            this.estimator = new OveruseEstimator(options2, RemoteBitrateEstimatorAbsSendTime.this.diagnosticContext, RemoteBitrateEstimatorAbsSendTime.this.logger);
            this.detector = new OveruseDetector(options2, RemoteBitrateEstimatorAbsSendTime.this.diagnosticContext);
        }
    }
}

