/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data;

import jadx.plugins.input.java.data.ConstantType;
import jadx.plugins.input.java.data.DataReader;

public class ClassOffsets {
    private final int[] constPoolOffsets;
    private final int constPoolEnd;
    private final int interfacesEnd;
    private final int attributesOffset;

    public ClassOffsets(DataReader data) {
        this.constPoolOffsets = ClassOffsets.readConstPool(data);
        this.constPoolEnd = data.getOffset();
        int interfacesCount = data.absPos(this.constPoolEnd + 6).readU2();
        data.skip(interfacesCount * 2);
        this.interfacesEnd = data.getOffset();
        this.skipFields(data);
        this.skipMethods(data);
        this.attributesOffset = data.getOffset();
    }

    private static int[] readConstPool(DataReader data) {
        int cpSize = data.absPos(8).readU2();
        int[] cpOffsets = new int[cpSize + 1];
        block4: for (int i = 1; i < cpSize; ++i) {
            int tag = data.readU1();
            cpOffsets[i] = data.getOffset();
            ConstantType constType = ConstantType.getTypeByTag(tag);
            switch (constType) {
                case UTF8: {
                    data.skip(data.readU2());
                    continue block4;
                }
                case LONG: 
                case DOUBLE: {
                    data.skip(8);
                    ++i;
                    continue block4;
                }
                default: {
                    data.skip(constType.getDataSize());
                }
            }
        }
        return cpOffsets;
    }

    private void skipFields(DataReader data) {
        int fieldsCount = data.readU2();
        for (int i = 0; i < fieldsCount; ++i) {
            data.skip(6);
            this.skipAttributes(data);
        }
    }

    private void skipMethods(DataReader data) {
        int methodsCount = data.readU2();
        for (int i = 0; i < methodsCount; ++i) {
            data.skip(6);
            this.skipAttributes(data);
        }
    }

    private void skipAttributes(DataReader data) {
        int attrCount = data.readU2();
        for (int i = 0; i < attrCount; ++i) {
            data.skip(2);
            int len = data.readU4();
            data.skip(len);
        }
    }

    public int getOffsetOfConstEntry(int num) {
        return this.constPoolOffsets[num];
    }

    public int getAccessFlagsOffset() {
        return this.constPoolEnd;
    }

    public int getClsTypeOffset() {
        return this.constPoolEnd + 2;
    }

    public int getSuperTypeOffset() {
        return this.constPoolEnd + 4;
    }

    public int getInterfacesOffset() {
        return this.constPoolEnd + 6;
    }

    public int getFieldsOffset() {
        return this.interfacesEnd;
    }

    public int getAttributesOffset() {
        return this.attributesOffset;
    }
}

