/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.logs;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import jadx.gui.utils.logs.ILogIssuesListener;
import jadx.gui.utils.logs.ILogListener;
import jadx.gui.utils.logs.LimitedQueue;
import jadx.gui.utils.logs.LogEvent;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class LogCollector
extends AppenderBase<ILoggingEvent> {
    public static final int BUFFER_SIZE = 5000;
    private static final LogCollector INSTANCE = new LogCollector();
    private Layout<ILoggingEvent> layout;
    @Nullable
    private ILogListener listener;
    @Nullable
    private ILogIssuesListener issuesListener;
    private int errors = 0;
    private int warnings = 0;
    private final Queue<LogEvent> buffer = new LimitedQueue<LogEvent>(5000);

    public static LogCollector getInstance() {
        return INSTANCE;
    }

    public static void register() {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext loggerContext = rootLogger.getLoggerContext();
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)loggerContext);
        layout.setPattern("%-5level: %msg%n");
        layout.start();
        INSTANCE.setContext((Context)loggerContext);
        INSTANCE.setLayout((Layout<ILoggingEvent>)layout);
        INSTANCE.start();
        rootLogger.addAppender((Appender)INSTANCE);
    }

    public LogCollector() {
        this.setName("LogCollector");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent event) {
        LogCollector logCollector = this;
        synchronized (logCollector) {
            Level level = event.getLevel();
            String msg = this.layout.doLayout((Object)event);
            this.store(level, msg);
            if (this.listener != null && level.isGreaterOrEqual(this.listener.getFilterLevel())) {
                this.listener.onAppend(msg);
            }
            if (level == Level.ERROR) {
                ++this.errors;
                this.issuesUpdated();
            } else if (level == Level.WARN) {
                ++this.warnings;
                this.issuesUpdated();
            }
        }
    }

    private void issuesUpdated() {
        if (this.issuesListener != null) {
            this.issuesListener.onChange(this.errors, this.warnings);
        }
    }

    private void store(Level level, String msg) {
        this.buffer.offer(new LogEvent(level, msg));
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(@NotNull ILogListener listener) {
        this.listener = listener;
        LogCollector logCollector = this;
        synchronized (logCollector) {
            listener.onAppend(this.init(listener.getFilterLevel()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIssueListener(@NotNull ILogIssuesListener listener) {
        this.issuesListener = listener;
        LogCollector logCollector = this;
        synchronized (logCollector) {
            listener.onChange(this.errors, this.warnings);
        }
    }

    public void resetListener() {
        this.listener = null;
    }

    public void reset() {
        this.buffer.clear();
        this.errors = 0;
        this.warnings = 0;
        this.issuesUpdated();
    }

    public int getErrors() {
        return this.errors;
    }

    public int getWarnings() {
        return this.warnings;
    }

    private String init(Level filterLevel) {
        StringBuilder sb = new StringBuilder();
        for (LogEvent event : this.buffer) {
            if (!event.getLevel().isGreaterOrEqual(filterLevel)) continue;
            sb.append(event.getMsg());
        }
        return sb.toString();
    }
}

