/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.filesystem;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CommandDomain;

@CommandDefinition(name="cd", description="Changes the current work dir")
public class CdCommand
extends PmSessionCommand {
    @Argument(description="Target directory")
    private File path;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        if (this.path == null) {
            return;
        }
        Path p = this.path.toPath();
        if (this.path.getName().equals("-")) {
            Path previous = session.getPmSession().getPreviousDirectory();
            if (previous == null) {
                return;
            }
            p = previous;
        }
        try {
            session.getPmSession().setCurrentDirectory(p);
            session.setPrompt(session.getPmSession().buildPrompt());
        }
        catch (IOException ex) {
            throw new CommandExecutionException(ex.getMessage());
        }
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.OTHERS;
    }
}

