/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;

public final class IndianSettlementPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(IndianSettlementPanel.class.getName());

    public IndianSettlementPanel(FreeColClient freeColClient, IndianSettlement is) {
        super(freeColClient, null, new MigLayout("wrap 2, gapx 20", "", ""));
        GoodsType gt;
        ImageLibrary lib = this.getImageLibrary();
        JLabel settlementLabel = new JLabel(new ImageIcon(lib.getScaledSettlementImage(is)));
        Player indian = is.getOwner();
        Player player = this.getMyPlayer();
        boolean contacted = is.hasContacted(player);
        boolean visited = is.hasVisited(player);
        String text = Messages.message(is.getLocationLabelFor(player)) + ", " + Messages.message(StringTemplate.template(is.isCapital() ? "indianSettlementPanel.indianCapital" : "indianSettlementPanel.indianSettlement").addStringTemplate("%nation%", indian.getNationLabel()));
        Tension tension = is.getAlarm(player);
        if (tension != null) {
            text = text + " (" + Messages.getName(tension) + ")";
        }
        if (is.worthScouting(player)) {
            text = text + ResourceManager.getString("unscoutedIndianSettlement");
        }
        settlementLabel.setText(text);
        this.add(settlementLabel);
        Unit missionary = is.getMissionary();
        if (missionary != null) {
            this.add(Utility.localizedLabel(missionary.getLabel(Unit.UnitLabelType.NATIONAL), new ImageIcon(lib.getSmallUnitImage(missionary)), 0));
        }
        this.add((Component)Utility.localizedLabel("indianSettlementPanel.learnableSkill"), "newline");
        UnitType skillType = is.getLearnableSkill();
        this.add(Utility.localizedLabel(is.getLearnableSkillLabel(visited), visited && skillType != null ? new ImageIcon(lib.getSmallUnitTypeImage(skillType)) : null, 0));
        this.add((Component)Utility.localizedLabel("indianSettlementPanel.mostHated"), "newline");
        Player mostHated = is.getMostHated();
        this.add(Utility.localizedLabel(is.getMostHatedLabel(contacted), contacted && mostHated != null ? new ImageIcon(lib.getSmallNationImage(mostHated.getNation())) : null, 0));
        List<StringTemplate> wants = is.getWantedGoodsLabel(0, player);
        this.add((Component)Utility.localizedLabel("indianSettlementPanel.highlyWanted"), "newline");
        JLabel label = Utility.localizedLabel(wants.get(0), visited && (gt = is.getWantedGoods(0)) != null ? new ImageIcon(lib.getScaledGoodsTypeImage(gt)) : null, 0);
        if (wants.size() > 1) {
            Utility.localizeToolTip((JComponent)label, wants.get(1));
        }
        this.add(label);
        this.add((Component)Utility.localizedLabel("indianSettlementPanel.otherWanted"), "newline");
        int n = is.getWantedGoodsCount();
        String x = "split " + (n <= 1 ? "1" : Integer.toString(n - 1));
        for (int i = 1; i < n; ++i) {
            wants = is.getWantedGoodsLabel(i, player);
            label = Utility.localizedLabel(wants.get(0), visited && (gt = is.getWantedGoods(i)) != null ? new ImageIcon(lib.getScaledGoodsTypeImage(gt)) : null, 0);
            if (wants.size() > 1) {
                Utility.localizeToolTip((JComponent)label, wants.get(1));
            }
            this.add((Component)label, x);
            x = null;
        }
        this.add((Component)this.okButton, "newline 20, span, tag ok");
        this.setEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IndianSettlementPanel.this.okButton.doClick();
            }
        });
        this.setSize(this.getPreferredSize());
    }
}

