/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SubnetAttribute;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.Options;

public class ModifySubnetAttribute
extends BaseCmd {
    private static final String[] MAP_PUBLIC_IP_ON_LAUNCH_DESC = new String[]{"Sets whether public IPs should be assigned to instances launched into this subnet."};

    public ModifySubnetAttribute(String[] args) {
        super("ec2msubnetatt", "ec2-modify-subnet-attribute");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(ModifySubnetAttribute.createOptionWithArgs("m", "map-public-ip-on-launch", MAP_PUBLIC_IP_ON_LAUNCH_DESC, "BOOLEAN"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "[SPECIFIC OPTIONS] SUBNET";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("map-public-ip-on-launch");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Modifies a subnet attribute. Only one attribute can be specified per");
        System.out.println("     call.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        SubnetAttribute<?> subnetAttribute;
        String subnetId = this.getSubnetId();
        RequestResultPair rsp = jec2.modifySubnetAttribute(subnetId, subnetAttribute = this.getSubnetAttribute());
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputSubnetAttribute(System.out, subnetId, subnetAttribute);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    private SubnetAttribute<?> getSubnetAttribute() {
        ArrayList attributes = new ArrayList(1);
        ModifySubnetAttribute.addIfNotNull(attributes, this.getBooleanAttribute(SubnetAttribute.SubnetAttributeType.mapPublicIpOnLaunch, "map-public-ip-on-launch"));
        if (attributes.isEmpty()) {
            throw new InvalidArgumentCombination("An attribute must be specified.");
        }
        if (attributes.size() > 1) {
            throw new InvalidArgumentCombination("Only one attribute may be specified.");
        }
        return (SubnetAttribute)attributes.get(0);
    }

    private static <T> void addIfNotNull(List<T> list, T item) {
        if (item != null) {
            list.add(item);
        }
    }

    private SubnetAttribute<Boolean> getBooleanAttribute(SubnetAttribute.SubnetAttributeType type, String param) {
        String value = this.getOptionValue(param);
        if (value == null) {
            return null;
        }
        if (!"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
            throw new GeneralError("The argument for --" + param + " must be 'true' or 'false', " + "but was '" + value + "'");
        }
        return new SubnetAttribute(type, (Object)Boolean.parseBoolean(value.toLowerCase()));
    }

    protected String getSubnetId() {
        String[] subnetIds = this.getNonOptions();
        if (subnetIds.length == 0) {
            throw new InvalidArgumentCombination("A subnet ID must be specified.");
        }
        if (subnetIds.length > 1) {
            throw new InvalidArgumentCombination("Only one subnet ID may be specified.");
        }
        return subnetIds[0];
    }

    public static void main(String[] args) {
        new ModifySubnetAttribute(args).invoke();
    }
}

