/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.swingui.DataEntryPanel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class KettleDataSourceOptionsPanel
implements DataEntryPanel {
    private static final Logger logger = Logger.getLogger(KettleDataSourceOptionsPanel.class);
    private final JPanel panel = this.buildKettleOptionsPanel();
    private final SPDataSource dbcs;
    private JTextField kettleHostName;
    private JTextField kettlePort;
    private JTextField kettleDatabase;
    private JTextField kettleLogin;
    private JPasswordField kettlePassword;

    public KettleDataSourceOptionsPanel(@Nonnull JDBCDataSource dbcs) {
        this.dbcs = dbcs;
        this.parentTypeChanged(dbcs.getParentType());
        this.kettleHostName.setText(dbcs.get("ca.sqlpower.architect.etl.kettle.hostname"));
        this.kettlePort.setText(dbcs.get("ca.sqlpower.architect.etl.kettle.port"));
        this.kettleDatabase.setText(dbcs.get("ca.sqlpower.architect.etl.kettle.database"));
        this.kettleLogin.setText(dbcs.get("ca.sqlpower.architect.etl.kettle.repos.login"));
        this.kettlePassword.setText(dbcs.get("ca.sqlpower.architect.etl.kettle.repos.password"));
    }

    private JPanel buildKettleOptionsPanel() {
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref, 4dlu, pref:grow"));
        this.kettleHostName = new JTextField();
        builder.append(Messages.getString("KettleDataSourceOptionsPanel.hostname"), (Component)this.kettleHostName);
        this.kettlePort = new JTextField();
        builder.append(Messages.getString("KettleDataSourceOptionsPanel.port"), (Component)this.kettlePort);
        this.kettleDatabase = new JTextField();
        builder.append(Messages.getString("KettleDataSourceOptionsPanel.database"), (Component)this.kettleDatabase);
        this.kettleLogin = new JTextField();
        builder.append(Messages.getString("KettleDataSourceOptionsPanel.repositoryLoginName"), (Component)this.kettleLogin);
        this.kettlePassword = new JPasswordField();
        builder.append(Messages.getString("KettleDataSourceOptionsPanel.repositoryPassword"), (Component)this.kettlePassword);
        return builder.getPanel();
    }

    public void parentTypeChanged(JDBCDataSourceType dsType) {
        Map map = dsType.retrieveURLDefaults();
        logger.error((Object)(" The map is: " + map));
        if (map.containsKey("Hostname")) {
            this.kettleHostName.setEnabled(false);
        } else {
            this.kettleHostName.setEnabled(true);
        }
        if (map.containsKey("Port")) {
            this.kettlePort.setEnabled(false);
        } else {
            this.kettlePort.setEnabled(true);
        }
        if (map.containsKey("Database")) {
            this.kettleDatabase.setEnabled(false);
        } else {
            this.kettleDatabase.setEnabled(true);
        }
    }

    public boolean applyChanges() {
        this.dbcs.put("ca.sqlpower.architect.etl.kettle.database", this.kettleDatabase.getText());
        this.dbcs.put("ca.sqlpower.architect.etl.kettle.port", this.kettlePort.getText());
        this.dbcs.put("ca.sqlpower.architect.etl.kettle.hostname", this.kettleHostName.getText());
        this.dbcs.put("ca.sqlpower.architect.etl.kettle.repos.login", this.kettleLogin.getText());
        this.dbcs.put("ca.sqlpower.architect.etl.kettle.repos.password", new String(this.kettlePassword.getPassword()));
        return true;
    }

    public void discardChanges() {
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }
}

