/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.net.URL;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.URLPathname;

public final class Site {
    private static LispObject LISP_HOME;
    private static final Symbol _LISP_HOME_;

    private static void init() {
        Object s = System.getProperty("abcl.home");
        if (s != null) {
            String fileSeparator = System.getProperty("file.separator");
            if (!((String)s).endsWith(fileSeparator)) {
                s = (String)s + fileSeparator;
            }
            LISP_HOME = Pathname.create((String)s);
            return;
        }
        URL url = Lisp.class.getResource("boot.lisp");
        if (url != null) {
            if (!Pathname.isSupportedProtocol(url.getProtocol())) {
                LISP_HOME = Lisp.NIL;
            } else {
                URLPathname p = URLPathname.create(url);
                p.setName(Lisp.NIL).setType(Lisp.NIL);
                LISP_HOME = p;
            }
            return;
        }
        Lisp.simple_error("Unable to determine LISP_HOME.", new Object[0]);
    }

    public static final LispObject getLispHome() {
        if (LISP_HOME == null) {
            Site.init();
        }
        return LISP_HOME;
    }

    static {
        _LISP_HOME_ = Lisp.exportSpecial("*LISP-HOME*", Lisp.PACKAGE_EXT, Lisp.NIL);
        LispObject p = Site.getLispHome();
        if (p != null) {
            _LISP_HOME_.setSymbolValue(p);
        }
    }
}

